/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs.reporting;

import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteReportDataSource;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.TestReportCopy;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.jobs.reporting.TestReportingJob;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.ReportLocationSetting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestReportCopyJob
extends TestReportingJob {
    private final TestReportCopy testReportCopy;
    private final File originalReportFolder;
    private final IReportDataSource dataSource;

    protected TestReportCopyJob(IExecutionManager manager, IEventBroker eventBroker, TestReportCopy testReportCopy, IReportDataSource dataSource, File originalReportFolder) {
        super(manager, eventBroker);
        this.testReportCopy = testReportCopy;
        this.dataSource = dataSource;
        this.originalReportFolder = originalReportFolder;
    }

    @Override
    protected void start() throws ExecutionException {
        super.start();
        this.performCopyReport();
        this.updateJobStatus(ExecutionJobStatus.COMPLETED);
    }

    private ReportLocationSetting rebuildReportLocationSettingsIfNecessary() {
        TestSuiteExecution tse;
        LegacyTestSuiteReportDataSource legacyDataSource;
        TestSuiteExecutionAttempt attempt;
        EntityExecution entityExecution;
        ReportLocationSetting originalSetting = this.testReportCopy.getReportLocationSetting();
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteReportDataSource && (entityExecution = (attempt = (legacyDataSource = (LegacyTestSuiteReportDataSource)iReportDataSource).getTestSuiteExecutionAttempt()).getParentEntityExecution()) instanceof TestSuiteExecution && (tse = (TestSuiteExecution)entityExecution).isPartOfCollection()) {
            ReportLocationSetting childReportLocation = new ReportLocationSetting();
            childReportLocation.setReportFileName(originalSetting.getReportFileName());
            childReportLocation.enableReportFolder(originalSetting.isReportFolderSet());
            childReportLocation.setCleanReportFolder(originalSetting.isCleanReportFolderFlagActive());
            Path executionDirPath = attempt.getExecutionSettings().getExecutionDirPath();
            String executionId = FilenameUtils.getBaseName((String)executionDirPath.toString());
            if (originalSetting.isReportFolderPathSet()) {
                childReportLocation.setReportFolderPath(originalSetting.getReportFolderPath() + File.separator + executionId);
            }
            this.logger.info("Rebuilt report location for test suite part of collection: " + childReportLocation.getReportFolderPath());
            return childReportLocation;
        }
        return this.testReportCopy.getReportLocationSetting();
    }

    private void performCopyReport() {
        try {
            ReportLocationSetting reportLocationSetting = this.rebuildReportLocationSettingsIfNecessary();
            File userReportFolder = this.getUserReportFolder(reportLocationSetting);
            if (userReportFolder == null) {
                return;
            }
            this.logger.info(MessageFormat.format(StringConstants.LAU_PRT_COPYING_RPT_TO_USR_RPT_FOLDER, userReportFolder.getAbsolutePath()));
            if (reportLocationSetting.isCleanReportFolderFlagActive()) {
                this.logger.info(StringConstants.LAU_PRT_CLEANING_USR_RPT_FOLDER);
                FileUtils.cleanDirectory((File)userReportFolder);
            }
            File[] fileArray = this.originalReportFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File reportChildSourceFile = fileArray[n2];
                String fileName = FilenameUtils.getBaseName((String)reportChildSourceFile.getName());
                String fileExtension = FilenameUtils.getExtension((String)reportChildSourceFile.getName());
                if (!fileExtension.equalsIgnoreCase("lck")) {
                    if (fileExtension.equalsIgnoreCase("csv") || fileExtension.equalsIgnoreCase("html")) {
                        fileName = reportLocationSetting.getReportFileName();
                    }
                    if (reportChildSourceFile.isFile()) {
                        FileUtils.copyFile((File)reportChildSourceFile, (File)new File(userReportFolder, fileName + "." + fileExtension));
                    } else if (reportChildSourceFile.isDirectory()) {
                        File newCoppiedFolder = new File(userReportFolder, fileName);
                        newCoppiedFolder.mkdirs();
                        FileUtils.copyDirectory((File)reportChildSourceFile, (File)newCoppiedFolder);
                    }
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            this.logger.error("Failed to copy report to user-defined folder.", (Throwable)ex);
        }
    }

    private File getUserReportFolder(ReportLocationSetting rpLocSetting) {
        ProjectEntity project = null;
        EntityExecution entityExecution = this.testReportCopy.getTargetExecution();
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution tse = (TestSuiteExecution)entityExecution;
            project = tse.getTestSuite().getProject();
        } else {
            EntityExecution entityExecution2 = this.testReportCopy.getTargetExecution();
            if (entityExecution2 instanceof TestSuiteCollectionExecution) {
                TestSuiteCollectionExecution tsce = (TestSuiteCollectionExecution)entityExecution2;
                project = tsce.getTestSuiteCollection().getProject();
            } else {
                this.logger.warn("Target execution is null for test report copy.");
                return null;
            }
        }
        File reportFolder = new File(PathUtil.relativeToAbsolutePath((String)rpLocSetting.getReportFolderPath(), (String)project.getFolderLocation()));
        if (reportFolder != null && !reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        return reportFolder;
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.testReportCopy.updateJobStatus(newStatus);
        super.updateJobStatus(newStatus, lastException);
    }

    @Override
    public boolean isPausible() {
        return false;
    }
}

