/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs.reporting;

import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteCollectionReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteReportDataSource;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.TestReportGeneration;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.jobs.reporting.TestReportingJob;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.KatalonExportReportProvider;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.core.reporting.pdf.exception.JasperReportException;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.entity.project.ProjectEntity;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestReportGeneratingJob
extends TestReportingJob {
    private final TestReportGeneration reportGeneration;
    private final IReportDataSource dataSource;
    private final File reportFolder;

    protected TestReportGeneratingJob(IExecutionManager manager, IEventBroker eventBroker, TestReportGeneration reportGeneration, IReportDataSource dataSource, File reportFolder) {
        super(manager, eventBroker);
        this.reportGeneration = reportGeneration;
        this.dataSource = dataSource;
        this.reportFolder = reportFolder;
    }

    @Override
    protected void start() throws ExecutionException {
        super.start();
        TestReportGeneration.ReportFormat format = this.reportGeneration.getFormat();
        switch (format) {
            case HTML_TEST_SUITE: {
                this.generateHtmlReportForTestSuite(this.reportFolder, this.reportGeneration.getReportSettings());
                break;
            }
            case JUNIT: {
                this.generateJUnitReport(this.reportFolder);
                break;
            }
            case CSV: {
                this.generateCsvReport(this.reportFolder);
                break;
            }
            case PDF: {
                this.generatePdfReport(this.reportFolder);
                break;
            }
            case CONSOLE_LOG: {
                this.generateConsoleLogReport();
                break;
            }
            case HTML_TSC: {
                this.generateHtmlReportForTestSuiteCollection(this.reportFolder);
                break;
            }
            default: {
                throw new ExecutionException("Unsupported report format: " + String.valueOf(format));
            }
        }
        this.updateJobStatus(ExecutionJobStatus.COMPLETED);
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.reportGeneration.updateJobStatus(newStatus);
        super.updateJobStatus(newStatus, lastException);
    }

    private void generatePdfReport(File reportFolder) throws ExecutionException {
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)iReportDataSource;
            try {
                this.logger.info("Start generating PDF report folder at: " + String.valueOf(reportFolder) + "...");
                ReportWriterUtil.writePdfReport((TestSuiteLogRecord)legacyDataSource.getTestSuiteLogRecord(), (File)new File(reportFolder.getAbsolutePath()));
                this.logger.info("PDF report generated");
            }
            catch (JasperReportException | IOException e) {
                throw new ExecutionException("Failed to generate PDF report, error: " + e.getMessage(), e);
            }
            return;
        }
        throw new ExecutionException("No valid data source for generating PDF report: " + String.valueOf(this.dataSource));
    }

    private void generateJUnitReport(File reportFolder) throws ExecutionException {
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)iReportDataSource;
            try {
                this.logger.info("Start generating JUnit report folder at: " + reportFolder.getAbsolutePath() + "...");
                ReportUtil.writeJUnitReport((TestSuiteLogRecord)legacyDataSource.getTestSuiteLogRecord(), (File)reportFolder);
                this.logger.info("JUnit report were generated");
            }
            catch (IOException | JAXBException e) {
                throw new ExecutionException("Failed to generate JUnit report, error: " + e.getMessage(), e);
            }
            return;
        }
        IReportDataSource iReportDataSource2 = this.dataSource;
        if (iReportDataSource2 instanceof LegacyTestSuiteCollectionReportDataSource) {
            LegacyTestSuiteCollectionReportDataSource legacyCollectionDataSource = (LegacyTestSuiteCollectionReportDataSource)iReportDataSource2;
            try {
                ReportUtil.writeJUnitReport((TestSuiteCollectionLogRecord)legacyCollectionDataSource.getTestSuiteCollectionLogRecord(), (File)reportFolder);
            }
            catch (IOException | JAXBException e) {
                throw new ExecutionException("Failed to generate JUnit report for test suite collection, error: " + e.getMessage(), e);
            }
            return;
        }
        throw new ExecutionException("No valid data source for generating JUnit report: " + String.valueOf(this.dataSource));
    }

    private void generateHtmlReportForTestSuite(File reportFolder, ReportSettings reportSettings) throws ExecutionException {
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)iReportDataSource;
            try {
                this.logger.info("Start generating HTML report at folder: " + String.valueOf(reportFolder) + "...");
                ReportWriterUtil.writeHTMLReport((ReportWriterUtil.SuiteReportGenerationOptions)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)ReportWriterUtil.SuiteReportGenerationOptionsBuilder.create().suiteLogRecord(legacyDataSource.getTestSuiteLogRecord()).settings(reportSettings)).reportDir(reportFolder)).build());
                this.logger.info("HTML report generated");
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to generate HTML report, error: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        throw new ExecutionException("No valid data source for generating HTML report: " + String.valueOf(this.dataSource));
    }

    private void generateHtmlReportForTestSuiteCollection(File reportFolder) throws ExecutionException {
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteCollectionReportDataSource) {
            LegacyTestSuiteCollectionReportDataSource legacyDataSource = (LegacyTestSuiteCollectionReportDataSource)iReportDataSource;
            try {
                EntityExecution targetExecution = this.reportGeneration.getTargetExecution();
                ProjectEntity projectEntity = null;
                if (!(targetExecution instanceof TestSuiteCollectionExecution)) {
                    throw new ExecutionException("Cannot get project entity from target execution: " + String.valueOf(targetExecution));
                }
                TestSuiteCollectionExecution tsce = (TestSuiteCollectionExecution)targetExecution;
                projectEntity = tsce.getTestSuiteCollection().getProject();
                KatalonExportReportProvider provider = new KatalonExportReportProvider();
                provider.exportTestSuiteCollection(reportFolder, projectEntity.getFolderLocation(), reportFolder.getAbsolutePath().toString(), "HTML", legacyDataSource.getTestSuiteCollectionLogRecord());
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to generate HTML report for test suite collection, error: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        throw new ExecutionException("No valid data source for generating HTML report: " + String.valueOf(this.dataSource));
    }

    private void generateConsoleLogReport() {
    }

    private void generateCsvReport(File reportFolder) throws ExecutionException {
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)iReportDataSource;
            try {
                this.logger.info("Start generating CSV report folder at: " + String.valueOf(reportFolder) + "...");
                ReportWriterUtil.writeCSVReport((TestSuiteLogRecord)legacyDataSource.getTestSuiteLogRecord(), (File)new File(reportFolder.getAbsolutePath()));
                this.logger.info("CSV report generated");
            }
            catch (IOException e) {
                throw new ExecutionException("Failed to generate CSV report, error: " + e.getMessage(), (Throwable)e);
            }
            return;
        }
        throw new ExecutionException("No valid data source for generating CSV report: " + String.valueOf(this.dataSource));
    }

    @Override
    public boolean isPausible() {
        return false;
    }
}

