/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs.reporting;

import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.TestReportIntegration;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.IReportIntegrationProvider;
import com.katalon.execution.services.events.ExecutionEventsPublisher;
import com.katalon.execution.services.jobs.reporting.TestReportingJob;
import com.kms.katalon.execution.constants.StringConstants;
import java.text.MessageFormat;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestReportIntegrationJob
extends TestReportingJob {
    private final TestReportIntegration testReportIntegration;
    private final IReportDataSource dataSource;
    private final ExecutionEventsPublisher eventsPublisher;

    protected TestReportIntegrationJob(IExecutionManager manager, IEventBroker eventBroker, ExecutionEventsPublisher eventsPublisher, TestReportIntegration testReportIntegration, IReportDataSource dataSource) {
        super(manager, eventBroker);
        this.testReportIntegration = testReportIntegration;
        this.dataSource = dataSource;
        this.eventsPublisher = eventsPublisher;
    }

    @Override
    protected void start() throws ExecutionException {
        super.start();
        IReportIntegrationProvider provider = this.testReportIntegration.getReportIntegrationProvider();
        EntityExecution targetExecution = this.testReportIntegration.getTargetExecution();
        IReportIntegrationProvider.Result result = IReportIntegrationProvider.Result.ok();
        if (targetExecution instanceof TestSuiteExecution) {
            TestSuiteExecution tse = (TestSuiteExecution)targetExecution;
            result = provider.shouldGenerateReportForTestSuite(tse);
        } else if (targetExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tsce = (TestSuiteCollectionExecution)targetExecution;
            result = provider.shouldGenerateReportForTestSuiteCollection(tsce);
        }
        if (!result.willDo()) {
            this.logger.info("Skipping report integration for " + provider.getName() + ". Reason: " + result.reasonIfNot().orElse("No reason provided."));
            this.updateJobStatus(ExecutionJobStatus.COMPLETED);
            return;
        }
        provider.enrichDataSourceBeforeUpload(this.dataSource, this.testReportIntegration.getAdditionalInfo());
        try {
            this.logger.info(MessageFormat.format(StringConstants.LAU_PRT_SENDING_RPT_TO, provider.getName()));
            provider.uploadExecutionResult(this.dataSource);
            this.logger.info(MessageFormat.format(StringConstants.LAU_PRT_REPORT_SENT, provider.getName()));
        }
        catch (Exception e) {
            String causeMessage = provider.buildFriendlyErrorMessage(e);
            this.logger.info(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_SEND_INTEGRATION_REPORT, provider.getName(), causeMessage));
            throw new ExecutionException(causeMessage, (Throwable)e);
        }
        this.updateJobStatus(ExecutionJobStatus.COMPLETED, null);
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.testReportIntegration.updateJobStatus(newStatus);
        if (newStatus == ExecutionJobStatus.COMPLETED) {
            this.eventsPublisher.onReportIntegrationCompleted(this.testReportIntegration, this.dataSource);
        }
        super.updateJobStatus(newStatus, lastException);
    }

    @Override
    public boolean isPausible() {
        return false;
    }
}

