/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs.reporting;

import com.katalon.execution.dto.result.JobDTO;
import com.katalon.execution.event.JobUpdatedEvent;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteCollectionReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteReportDataSource;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.reporting.TestReportCopy;
import com.katalon.execution.model.steps.reporting.TestReportEmailSending;
import com.katalon.execution.model.steps.reporting.TestReportGeneration;
import com.katalon.execution.model.steps.reporting.TestReportIntegration;
import com.katalon.execution.model.steps.reporting.TestReporting;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.events.ExecutionEventsPublisher;
import com.katalon.execution.services.jobs.ExecutionJob;
import com.katalon.execution.services.jobs.reporting.TestReportCopyJob;
import com.katalon.execution.services.jobs.reporting.TestReportGeneratingJob;
import com.katalon.execution.services.jobs.reporting.TestReportIntegrationJob;
import com.katalon.execution.services.jobs.reporting.TestReportingJob;
import com.katalon.execution.services.jobs.reporting.TestSuiteCollectionReportEmailSendingJob;
import com.katalon.execution.services.jobs.reporting.TestSuiteReportEmailSendingJob;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestReportingPhaseJob
extends ExecutionJob {
    private final TestReportingPhase reportingPhase;
    private final EntityExecution entityExecution;
    private final ExecutionEventsPublisher eventsPublisher;

    public TestReportingPhaseJob(IExecutionManager manager, IEventBroker eventBroker, ExecutionEventsPublisher eventsPublisher, TestReportingPhase reportingPhase, EntityExecution entityExecution) {
        super(manager, eventBroker);
        this.reportingPhase = reportingPhase;
        this.entityExecution = entityExecution;
        this.eventsPublisher = eventsPublisher;
    }

    @Override
    public boolean isPausible() {
        return false;
    }

    @Override
    public void start() throws ExecutionException {
        super.start();
        EntityExecution entityExecution = this.entityExecution;
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            for (TestSuiteExecutionAttempt attempt : testSuiteExecution.getAttempts()) {
                TestSuiteLogRecord testSuiteLogRecord;
                if (attempt.getExecutionJobStatus() == ExecutionJobStatus.PENDING || attempt.getExecutionJobStatus() == ExecutionJobStatus.TERMINATED || (testSuiteLogRecord = this.buildTestSuiteLogRecord(attempt)) == null) continue;
                LegacyTestSuiteReportDataSource reportDataSource = new LegacyTestSuiteReportDataSource(testSuiteLogRecord, attempt);
                List<TestReporting> steps = this.filterStepsForTestSuiteExecutionAttempt(attempt);
                File reportFolder = attempt.getExecutionSettings().getExecutionDirPath().toFile();
                if (attempt.getExecutionUUID() != null) {
                    this.writeExecutionUUID(reportFolder, attempt.getExecutionUUID());
                }
                future = future.thenCompose(v -> {
                    try {
                        return this.startReportingForTestSuiteAsync(reportDataSource, reportFolder, steps);
                    }
                    catch (ExecutionException e) {
                        return CompletableFuture.failedFuture(e);
                    }
                });
            }
            future.whenComplete((status, throwable) -> {
                if (throwable != null) {
                    this.updateJobStatus(ExecutionJobStatus.FAILED, (Throwable)throwable);
                    return;
                }
                this.updateJobStatus(ExecutionJobStatus.COMPLETED);
            });
            return;
        }
        EntityExecution entityExecution2 = this.entityExecution;
        if (entityExecution2 instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution2;
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            ArrayList<TestSuiteLogRecord> testSuiteLogRecords = new ArrayList<TestSuiteLogRecord>();
            for (TestSuiteExecution tsExecution : tscExecution.getTestSuiteExecutions()) {
                for (TestSuiteExecutionAttempt attempt : tsExecution.getAttempts()) {
                    TestSuiteLogRecord testSuiteLogRecord;
                    if (attempt.getExecutionJobStatus() == ExecutionJobStatus.PENDING || attempt.getExecutionJobStatus() == ExecutionJobStatus.TERMINATED || (testSuiteLogRecord = this.buildTestSuiteLogRecord(attempt)) == null) continue;
                    LegacyTestSuiteReportDataSource reportDataSource = new LegacyTestSuiteReportDataSource(testSuiteLogRecord, attempt);
                    List<TestReporting> steps = this.filterStepsForTestSuiteExecutionAttempt(attempt);
                    File reportFolder = attempt.getExecutionSettings().getExecutionDirPath().toFile();
                    if (attempt.getExecutionUUID() != null) {
                        this.writeExecutionUUID(reportFolder, attempt.getExecutionUUID());
                    }
                    testSuiteLogRecords.add(testSuiteLogRecord);
                    future = ((CompletableFuture)future).thenCompose(v -> {
                        try {
                            return this.startReportingForTestSuiteAsync(reportDataSource, reportFolder, steps);
                        }
                        catch (ExecutionException e) {
                            return CompletableFuture.failedFuture(e);
                        }
                    });
                }
            }
            future = ((CompletableFuture)future).thenCompose(v -> {
                try {
                    return this.startReportingForTestSuiteCollectionAsync(tscExecution, testSuiteLogRecords);
                }
                catch (ExecutionException e) {
                    return CompletableFuture.failedFuture(e);
                }
            });
            ((CompletableFuture)future).whenComplete((status, throwable) -> {
                if (throwable != null) {
                    this.updateJobStatus(ExecutionJobStatus.FAILED, (Throwable)throwable);
                    return;
                }
                this.updateJobStatus(ExecutionJobStatus.COMPLETED);
            });
        }
    }

    private CompletableFuture<ExecutionJobStatus> startReportingForTestSuiteAsync(LegacyTestSuiteReportDataSource reportDataSource, File reportFolder, List<TestReporting> steps) throws ExecutionException {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        for (TestReporting step : steps) {
            AtomicReference<Object> jobRef = new AtomicReference<Object>(null);
            TestReportingJob job = null;
            if (step instanceof TestReportGeneration) {
                TestReportGeneration testReportGeneration = (TestReportGeneration)step;
                job = new TestReportGeneratingJob(this.manager, this.eventBroker, testReportGeneration, (IReportDataSource)reportDataSource, reportFolder);
            } else if (step instanceof TestReportCopy) {
                TestReportCopy testReportCopy = (TestReportCopy)step;
                job = new TestReportCopyJob(this.manager, this.eventBroker, testReportCopy, (IReportDataSource)reportDataSource, reportFolder);
            } else if (step instanceof TestReportIntegration) {
                TestReportIntegration testReportIntegration = (TestReportIntegration)step;
                job = new TestReportIntegrationJob(this.manager, this.eventBroker, this.eventsPublisher, testReportIntegration, (IReportDataSource)reportDataSource);
            } else if (step instanceof TestReportEmailSending.TestSuiteReportEmailSending) {
                TestReportEmailSending.TestSuiteReportEmailSending testSuiteReportEmailSending = (TestReportEmailSending.TestSuiteReportEmailSending)step;
                job = new TestSuiteReportEmailSendingJob(this.manager, this.eventBroker, testSuiteReportEmailSending, (IReportDataSource)reportDataSource);
            }
            if (job == null) {
                throw new ExecutionException("Unsupported reporting step: " + step.getClass().getSimpleName());
            }
            jobRef.set(job);
            future = future.thenCompose(v -> {
                step.updateJobStatus(ExecutionJobStatus.RUNNING);
                this.notifyProgressChanged();
                return ((CompletableFuture)((TestReportingJob)jobRef.get()).startAsync().whenComplete((status, throwable) -> {
                    if (throwable != null) {
                        step.updateJobStatus(ExecutionJobStatus.FAILED, throwable.getMessage());
                    } else {
                        step.updateJobStatus(status);
                    }
                    this.notifyProgressChanged();
                })).thenApply(status -> null);
            });
        }
        return future.whenComplete((status, throwable) -> this.eventsPublisher.onReportGenerationCompleted((IReportDataSource)reportDataSource));
    }

    private CompletableFuture<ExecutionJobStatus> startReportingForTestSuiteCollectionAsync(TestSuiteCollectionExecution tscExecution, List<TestSuiteLogRecord> testSuiteLogRecords) throws ExecutionException {
        CompletionStage<Object> future = CompletableFuture.completedFuture(null);
        File reportFolder = this.findReportFolder(tscExecution);
        try {
            ReportWriterUtil.writeTestSuiteCollectionIdToFile((String)tscExecution.getTestSuiteCollectionId(), (File)reportFolder);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to write test suite collection ID to report folder.", (Throwable)e);
        }
        TestSuiteCollectionLogRecord testSuiteCollectionLogRecord = this.buildTestSuiteCollectionLogRecord(tscExecution, testSuiteLogRecords, reportFolder);
        LegacyTestSuiteCollectionReportDataSource reportDataSource = new LegacyTestSuiteCollectionReportDataSource(testSuiteCollectionLogRecord, tscExecution);
        List<TestExecutionStep> appliedSteps = this.reportingPhase.getChildren().stream().filter(step -> {
            TestReporting reportStep;
            return step instanceof TestReporting && (reportStep = (TestReporting)step).getTargetExecution().equals(tscExecution);
        }).toList();
        for (TestExecutionStep step2 : appliedSteps) {
            AtomicReference<Object> jobRef = new AtomicReference<Object>(null);
            TestReportingJob job = null;
            if (step2 instanceof TestReportGeneration) {
                TestReportGeneration testReportGeneration = (TestReportGeneration)step2;
                job = new TestReportGeneratingJob(this.manager, this.eventBroker, testReportGeneration, (IReportDataSource)reportDataSource, reportFolder);
            } else if (step2 instanceof TestReportCopy) {
                TestReportCopy testReportCopy = (TestReportCopy)step2;
                job = new TestReportCopyJob(this.manager, this.eventBroker, testReportCopy, (IReportDataSource)reportDataSource, reportFolder);
            } else if (step2 instanceof TestReportIntegration) {
                TestReportIntegration testReportIntegration = (TestReportIntegration)step2;
                job = new TestReportIntegrationJob(this.manager, this.eventBroker, this.eventsPublisher, testReportIntegration, (IReportDataSource)reportDataSource);
            } else if (step2 instanceof TestReportEmailSending.TestSuiteCollectionReportEmailSending) {
                TestReportEmailSending.TestSuiteCollectionReportEmailSending tscReportEmailSending = (TestReportEmailSending.TestSuiteCollectionReportEmailSending)step2;
                job = new TestSuiteCollectionReportEmailSendingJob(this.manager, this.eventBroker, tscReportEmailSending, (IReportDataSource)reportDataSource);
            }
            if (job == null) {
                this.logger.warn("Unsupported reporting step: " + step2.getClass().getSimpleName());
                continue;
            }
            jobRef.set(job);
            future = future.thenCompose(v -> {
                step2.updateJobStatus(ExecutionJobStatus.RUNNING);
                this.notifyProgressChanged();
                return ((CompletableFuture)((TestReportingJob)jobRef.get()).startAsync().whenComplete((status, throwable) -> {
                    if (throwable != null) {
                        step2.updateJobStatus(ExecutionJobStatus.FAILED, throwable.getMessage());
                    } else {
                        step2.updateJobStatus(status);
                    }
                    this.notifyProgressChanged();
                })).thenApply(status -> null);
            });
        }
        return future.whenComplete((arg_0, arg_1) -> this.lambda$13((IReportDataSource)reportDataSource, arg_0, arg_1));
    }

    private TestSuiteLogRecord buildTestSuiteLogRecord(TestSuiteExecutionAttempt attempt) throws ExecutionException {
        TestSuiteLogRecord testSuiteLogRecord;
        ExecutionSettings executionSettings = attempt.getExecutionSettings();
        Path executionFolder = executionSettings.getExecutionDirPath();
        String executionProfileName = executionSettings.getRunConfiguration().getExecution().getGeneral().getExecutionProfile();
        try {
            testSuiteLogRecord = ReportWriterUtil.parseCollectionSuiteLog((String)executionFolder.toAbsolutePath().toString());
            if (testSuiteLogRecord != null) {
                TestSuiteExecution tsExecution;
                EntityExecution entityExecution;
                testSuiteLogRecord.setExecutionProfile(executionProfileName != null ? executionProfileName : "default");
                EntityExecution entityExecution2 = attempt.getParentEntityExecution();
                if (entityExecution2 instanceof TestSuiteExecution && (entityExecution = (tsExecution = (TestSuiteExecution)entityExecution2).getParentEntityExecution()) instanceof TestSuiteCollectionExecution) {
                    TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
                    testSuiteLogRecord.setTestSuiteCollectionId(tscExecution.getTestSuiteCollectionId());
                }
            }
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to parse test suite log for reporting.", (Throwable)e);
        }
        return testSuiteLogRecord;
    }

    private TestSuiteCollectionLogRecord buildTestSuiteCollectionLogRecord(TestSuiteCollectionExecution tscExecution, List<TestSuiteLogRecord> testSuiteLogRecords, File reportFolder) throws ExecutionException {
        TestSuiteCollectionLogRecord suiteCollectionLogRecord = new TestSuiteCollectionLogRecord();
        suiteCollectionLogRecord.setId(tscExecution.getTestSuiteCollectionId());
        suiteCollectionLogRecord.setName(tscExecution.getTestSuiteCollection().getName());
        suiteCollectionLogRecord.setDescription(tscExecution.getTestSuiteCollection().getDescription());
        suiteCollectionLogRecord.setTestSuiteRecords(testSuiteLogRecords);
        suiteCollectionLogRecord.setStartTime(this.getTimeEpochMs(tscExecution.getStartDate()));
        suiteCollectionLogRecord.setEndTime(this.getTimeEpochMs(tscExecution.getEndDate()));
        suiteCollectionLogRecord.setTotalTestCases(String.valueOf(tscExecution.getTestCaseCount()));
        EnumMap stats = tscExecution.getDescendantTestCaseStats().getTestResultCount();
        suiteCollectionLogRecord.setTotalPassedTestCases(String.valueOf(stats.getOrDefault(ExecutionTestResult.PASSED, 0)));
        suiteCollectionLogRecord.setTotalFailedTestCases(String.valueOf(stats.getOrDefault(ExecutionTestResult.FAILED, 0)));
        suiteCollectionLogRecord.setTotalErrorTestCases(String.valueOf(stats.getOrDefault(ExecutionTestResult.ERROR, 0)));
        suiteCollectionLogRecord.setTotalIncompleteTestCases(String.valueOf(stats.getOrDefault(ExecutionTestResult.INCOMPLETE, 0)));
        suiteCollectionLogRecord.setTotalSkippedTestCases(String.valueOf(stats.getOrDefault(ExecutionTestResult.SKIPPED, 0)));
        suiteCollectionLogRecord.setReportFolder(reportFolder.getAbsolutePath());
        try {
            ReportWriterUtil.saveCollectionLogRecord((TestSuiteCollectionLogRecord)suiteCollectionLogRecord, (File)reportFolder);
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to save test suite collection log record.", (Throwable)e);
        }
        return suiteCollectionLogRecord;
    }

    private long getTimeEpochMs(Date date) {
        return date != null ? date.getTime() : 0L;
    }

    private List<TestReporting> filterStepsForTestSuiteExecutionAttempt(TestSuiteExecutionAttempt attempt) {
        return this.reportingPhase.getChildren().stream().filter(step -> {
            TestReporting reportStep;
            return step instanceof TestReporting && (reportStep = (TestReporting)step).getTargetExecution().equals(attempt.getParentEntityExecution());
        }).map(TestReporting.class::cast).toList();
    }

    private File findReportFolder(TestSuiteCollectionExecution tscExecution) throws ExecutionException {
        String executionSessionId = tscExecution.getExecutionSessionId();
        TestSuiteCollectionEntity tscEntity = tscExecution.getTestSuiteCollection();
        ReportCollectionEntity reportCollectionEntity = null;
        try {
            reportCollectionEntity = ReportController.getInstance().getReportCollection(tscEntity.getProject(), tscEntity, executionSessionId, executionSessionId);
        }
        catch (DALException e) {
            throw new ExecutionException("Failed to get report collection for test suite collection reporting.", (Throwable)e);
        }
        return reportCollectionEntity.getParentFolder().toFile();
    }

    private void writeExecutionUUID(File reportFolder, String executionUUID) {
        try {
            this.logger.info("Start writing execution.uuid file to folder: " + reportFolder.getAbsolutePath());
            ReportUtil.writeExecutionUUIDToFile((String)executionUUID, (File)reportFolder);
        }
        catch (IOException | URISyntaxException exception) {
            this.logger.error("Failed to write execution uuid");
        }
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.reportingPhase.updateJobStatus(newStatus);
        this.notifyProgressChanged();
        super.updateJobStatus(newStatus, lastException);
    }

    private void notifyProgressChanged() {
        this.eventBroker.post("EXECUTION_V2/ON_JOB_UPDATED", (Object)JobUpdatedEvent.withJob((JobDTO)JobDTO.fromReportingPhase((TestReportingPhase)this.reportingPhase)));
    }

    private /* synthetic */ void lambda$13(IReportDataSource iReportDataSource, ExecutionJobStatus status, Throwable throwable) {
        this.eventsPublisher.onReportGenerationCompleted(iReportDataSource);
    }
}

