/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs.reporting;

import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteCollectionReportDataSource;
import com.katalon.execution.model.steps.reporting.TestReportEmailSending;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.jobs.reporting.TestReportingJob;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.MailUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestSuiteCollectionReportEmailSendingJob
extends TestReportingJob {
    private final TestReportEmailSending.TestSuiteCollectionReportEmailSending tscReportEmailSending;
    private final IReportDataSource dataSource;

    public TestSuiteCollectionReportEmailSendingJob(IExecutionManager manager, IEventBroker eventBroker, TestReportEmailSending.TestSuiteCollectionReportEmailSending tscReportEmailSending, IReportDataSource dataSource) {
        super(manager, eventBroker);
        this.tscReportEmailSending = tscReportEmailSending;
        this.dataSource = dataSource;
    }

    @Override
    protected void start() throws ExecutionException {
        super.start();
        this.sendTestSuiteCollectionReportEmail();
        this.updateJobStatus(ExecutionJobStatus.COMPLETED);
    }

    private void sendTestSuiteCollectionReportEmail() throws ExecutionException {
        EmailConfig emailConfig = this.tscReportEmailSending.getEmailConfig();
        TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)this.tscReportEmailSending.getTargetExecution();
        String executionSessionId = tscExecution.getExecutionSessionId();
        TestSuiteCollectionEntity tscEntity = tscExecution.getTestSuiteCollection();
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteCollectionReportDataSource) {
            LegacyTestSuiteCollectionReportDataSource legacyDataSource = (LegacyTestSuiteCollectionReportDataSource)iReportDataSource;
            Map variables = EmailVariableBinding.getVariablesForTestSuiteCollectionEmail((TestSuiteCollectionLogRecord)legacyDataSource.getTestSuiteCollectionLogRecord());
            this.logger.info(MessageFormat.format(StringConstants.LAU_PRT_SENDING_EMAIL_RPT_TO, Arrays.toString(emailConfig.getTos())));
            try {
                ReportCollectionEntity reportCollectionEntity = null;
                try {
                    reportCollectionEntity = ReportController.getInstance().getReportCollection(tscEntity.getProject(), tscEntity, executionSessionId, executionSessionId);
                }
                catch (DALException e) {
                    throw new ExecutionException("Failed to get report collection for test suite collection reporting.", (Throwable)e);
                }
                MailUtil.sendSummaryMailForTestSuiteCollection((EmailConfig)emailConfig, (ReportCollectionEntity)reportCollectionEntity, (Map)variables);
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to send test suite collection report email: " + e.getMessage(), (Throwable)e);
            }
            this.logger.info(StringConstants.LAU_PRT_EMAIL_SENT);
        }
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.tscReportEmailSending.updateJobStatus(newStatus);
        super.updateJobStatus(newStatus, lastException);
    }

    @Override
    public boolean isPausible() {
        return false;
    }
}

