/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.jobs.reporting;

import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteReportDataSource;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.reporting.TestReportEmailSending;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.services.IExecutionManager;
import com.katalon.execution.services.jobs.reporting.TestReportingJob;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.service.IFailureAnalysisService;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.MailUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class TestSuiteReportEmailSendingJob
extends TestReportingJob {
    private final TestReportEmailSending.TestSuiteReportEmailSending testSuiteReportEmailSending;
    private final IReportDataSource dataSource;

    public TestSuiteReportEmailSendingJob(IExecutionManager manager, IEventBroker eventBroker, TestReportEmailSending.TestSuiteReportEmailSending testSuiteReportEmailSending, IReportDataSource dataSource) {
        super(manager, eventBroker);
        this.testSuiteReportEmailSending = testSuiteReportEmailSending;
        this.dataSource = dataSource;
    }

    @Override
    protected void start() throws ExecutionException {
        EntityExecution targetExecution;
        super.start();
        EmailConfig emailConfig = this.testSuiteReportEmailSending.getEmailConfig();
        if (emailConfig.isSendReportTestFailedOnly() && !(targetExecution = this.testSuiteReportEmailSending.getTargetExecution()).getDescendantTestCaseStats().hasFailedOrError()) {
            this.logger.info("Skipping sending test report email as no test case failed or error.");
            this.updateJobStatus(ExecutionJobStatus.COMPLETED);
            return;
        }
        this.sendTestSuiteReportEmail();
        this.updateJobStatus(ExecutionJobStatus.COMPLETED);
    }

    private void sendTestSuiteReportEmail() throws ExecutionException {
        ExecutionProfileEntity executionProfile;
        EmailConfig emailConfig = this.testSuiteReportEmailSending.getEmailConfig();
        EntityExecution targetExecution = this.testSuiteReportEmailSending.getTargetExecution();
        this.logger.info(MessageFormat.format(StringConstants.LAU_PRT_SENDING_EMAIL_RPT_TO, Arrays.toString(emailConfig.getTos())));
        ProjectEntity project = null;
        String executionProfileName = null;
        if (!(targetExecution instanceof TestSuiteExecution)) {
            throw new ExecutionException("Unsupported target execution for test suite report email sending: " + targetExecution.getClass().getName());
        }
        TestSuiteExecution tse = (TestSuiteExecution)targetExecution;
        project = tse.getTestSuite().getProject();
        executionProfileName = tse.getExecutionSettings().getRunConfiguration().getExecution().getGeneral().getExecutionProfile();
        try {
            executionProfile = GlobalVariableController.getInstance().getExecutionProfile(executionProfileName, project);
        }
        catch (ControllerException e) {
            throw new ExecutionException("Cannot get execution profile: " + executionProfileName + " for project: " + project.getName(), (Throwable)e);
        }
        IReportDataSource iReportDataSource = this.dataSource;
        if (iReportDataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)iReportDataSource;
            Map variables = EmailVariableBinding.getVariablesForTestSuiteEmail((TestSuiteLogRecord)legacyDataSource.getTestSuiteLogRecord(), (ExecutionProfileEntity)executionProfile, (EmailConfig)emailConfig, (IFailureAnalysisService)this.getFailureAnalysisService());
            try {
                MailUtil.sendSummaryMailForTestSuite((EmailConfig)emailConfig, (TestSuiteLogRecord)legacyDataSource.getTestSuiteLogRecord(), (Map)variables, (ExecutionProfileEntity)executionProfile);
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to send test report email: " + e.getMessage(), (Throwable)e);
            }
            this.logger.info(StringConstants.LAU_PRT_EMAIL_SENT);
        }
    }

    @Override
    protected void updateJobStatus(ExecutionJobStatus newStatus, Throwable lastException) {
        this.testSuiteReportEmailSending.updateJobStatus(newStatus);
        super.updateJobStatus(newStatus, lastException);
    }

    private IFailureAnalysisService getFailureAnalysisService() {
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (bundleContext != null) {
                IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
                return (IFailureAnalysisService)eclipseContext.get(IFailureAnalysisService.class);
            }
        }
        catch (Exception e) {
            this.logger.warn("Cannot get IFailureAnalysisService from Eclipse context.", (Throwable)e);
        }
        return null;
    }

    @Override
    public boolean isPausible() {
        return false;
    }
}

