/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.kre;

import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.util.StringUtil;
import com.kms.katalon.license.ConsoleLicenseService;
import java.text.MessageFormat;
import java.time.LocalTime;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KRELogPrinter {
    private static final Logger logger = LoggerFactory.getLogger(KRELogPrinter.class);
    private static final int CONSOLE_WIDTH = 80;

    public static void printTestSuiteConfigsWithInvalidLicense(String testSuiteCollectionName, List<TestSuiteRunConfiguration> invalidTsRunConfigs, ICapabilitySetting overridingCapability) {
        KRELogPrinter.printTextWithDash("CHECKING LICENSE INFORMATION", 80);
        logger.info(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TEST_SUITE_COLLECTION, testSuiteCollectionName));
        logger.info(ConsoleLicenseService.getInstance().getMsgAfterCheckingTSCLicense());
        for (TestSuiteRunConfiguration tsRunConfig : invalidTsRunConfigs) {
            String browserName;
            String runConfigId = tsRunConfig.getConfiguration().getRunConfigurationId();
            Object runConfigName = runConfigId;
            String string = browserName = overridingCapability != null ? overridingCapability.getDisplayName() : null;
            if (StringUtils.isNotBlank((CharSequence)browserName)) {
                runConfigName = runConfigId + " (overridden with " + browserName + ")";
                runConfigId = browserName;
            }
            logger.info(tsRunConfig.getTestSuiteEntity().getIdForDisplay() + " - " + (String)runConfigName);
        }
        KRELogPrinter.printTextWithDash("", 80);
    }

    public static void printRetrySettings(TestSuiteCollectionExecution tscExecution) {
        KRELogPrinter.printTextWithDash(ExecutionMessageConstants.MSG_INFO_RETRY_EXECUTION_INFO_LABEL, 80);
        logger.info(MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TEST_SUITE_COLLECTION, tscExecution.getName()));
        for (TestSuiteExecution testSuiteExecution : tscExecution.getTestSuiteExecutions()) {
            TestSuiteRerunSettings.RetryStrategy retryStrategy = testSuiteExecution.getExecutionSettings().getTestSuiteRerunSettings().getRetryStrategy();
            String retryInfo = MessageFormat.format(ExecutionMessageConstants.MSG_INFO_TS_RETRY, testSuiteExecution.getName(), retryStrategy.toString(), testSuiteExecution.getExecutionSettings().getTestSuiteRerunSettings().getMaxRetryCount());
            logger.info(retryInfo);
        }
        KRELogPrinter.printTextWithDash("", 80);
    }

    public static void printReadyToStartMessage(TestSuiteExecutionAttempt testSuiteExecutionAttempt, LocalTime timestamp, int maxFailedTests) {
        String launchName = KRELogPrinter.buildDisplayName(testSuiteExecutionAttempt);
        String msg = MessageFormat.format(ExecutionMessageConstants.TestSuiteCollectionLauncher_MSG_TEST_SUITE_READY_TO_START, launchName, timestamp);
        logger.info(msg);
        logger.info(MessageFormat.format(ExecutionMessageConstants.LAU_PRT_RUNNING_LAUNCHER, launchName));
    }

    public static void printMaxFailedTestMessage(TestSuiteExecutionAttempt testSuiteExecutionAttempt, int maxFailedTests, int remainingFailedThreshold) {
        String launchName = KRELogPrinter.buildDisplayName(testSuiteExecutionAttempt);
        if (remainingFailedThreshold > 0) {
            logger.info(MessageFormat.format(ExecutionMessageConstants.LAU_PRT_LAUNCHER_THRESHOLD_INFO, launchName, remainingFailedThreshold));
        } else {
            logger.info(MessageFormat.format(ExecutionMessageConstants.LAU_MESSAGE_REACH_FAILED_TEST_THRESHOLD, launchName, maxFailedTests));
        }
    }

    public static void printExecutionProgress(EntityExecution entityExecution) {
        KRELogPrinter.printTextWithDash("", 80);
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            for (TestSuiteExecutionAttempt attempt : testSuiteExecution.getAttempts()) {
                logger.info(KRELogPrinter.buildProgressMessage((EntityExecution)attempt));
            }
        } else if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            logger.info(KRELogPrinter.buildProgressMessage((EntityExecution)tscExecution));
            KRELogPrinter.printTextWithDash("", 80);
            for (TestSuiteExecution testSuiteExecution : tscExecution.getTestSuiteExecutions()) {
                for (TestSuiteExecutionAttempt attempt : testSuiteExecution.getAttempts()) {
                    logger.info(KRELogPrinter.buildProgressMessage((EntityExecution)attempt));
                }
            }
        }
        KRELogPrinter.printTextWithDash("", 80);
    }

    public static void printReadyToStartTestSuiteRetry(TestSuiteExecutionAttempt attempt) {
        logger.info(MessageFormat.format(ExecutionMessageConstants.LAU_RPT_RERUN_TEST_SUITE, attempt.getTestSuiteId(), attempt.getAttemptIndex()));
    }

    private static String buildProgressMessage(EntityExecution entityExecution) {
        int executedCount = entityExecution.getExecutedTestCaseCount();
        int totalCount = entityExecution.getTestCaseCount();
        int percentage = Math.round((float)executedCount / (float)totalCount * 100.0f);
        String displayName = entityExecution.getName();
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt attempt = (TestSuiteExecutionAttempt)entityExecution;
            displayName = KRELogPrinter.buildDisplayName(attempt);
        }
        StringBuilder builder = new StringBuilder(displayName).append(executedCount + "/" + totalCount + "(" + percentage + "%)");
        builder.insert(displayName.length(), StringUtils.repeat((String)".", (int)(80 - builder.length() % 80)));
        String result = StringUtil.wrap((String)builder.toString(), (int)80);
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - "\n".length());
        }
        return result;
    }

    private static String buildDisplayName(TestSuiteExecutionAttempt attempt) {
        Object fullName = attempt.getTestSuiteId();
        String driverName = attempt.getExecutionSettings().getDriverName();
        if (driverName != null && !driverName.isEmpty()) {
            fullName = (String)fullName + " - " + driverName;
        }
        String timestampId = FilenameUtils.getBaseName((String)attempt.getExecutionSettings().getExecutionDirPath().toString());
        fullName = (String)fullName + " - " + timestampId;
        if (attempt.getAttemptIndex() > 0) {
            fullName = (String)fullName + " - Re-run " + attempt.getAttemptIndex();
        }
        return fullName;
    }

    private static void printTextWithDash(String text, int consoleWidth) {
        String leftDash = StringUtils.repeat((String)"-", (int)((consoleWidth - text.length()) / 2));
        Object rightDash = leftDash;
        if (consoleWidth - text.length() % 2 != 0) {
            rightDash = (String)rightDash + "-";
        }
        StringBuilder builder = new StringBuilder().append("\n").append(leftDash).append(text).append((String)rightDash).append("\n");
        logger.info(builder.toString());
    }
}

