/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.launch;

import com.kms.katalon.core.model.RunningMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.launchers.LaunchShortcutHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;

public abstract class CustomGroovyLaunchShortcut {
    public static final String GROOVY_TYPE_TO_RUN = "org.codehaus.groovy.eclipse.launch.runType";

    public abstract ILaunchConfigurationType getGroovyLaunchConfigType();

    protected String applicationOrConsole() {
        return "script";
    }

    protected boolean canLaunchWithNoType() {
        return false;
    }

    protected String mainArgs(IType runType, IJavaProject javaProject) {
        CompilerOptions compilerOptions = new CompilerOptions(javaProject.getOptions(true));
        StringBuilder mainArgs = new StringBuilder("groovy.ui.GroovyMain");
        if (compilerOptions.groovyCompilerConfigScript != null && !compilerOptions.groovyCompilerConfigScript.isEmpty() && (runType == null || javaProject.isOnClasspath((IJavaElement)runType) && !CustomGroovyLaunchShortcut.matchesScriptFilter(runType.getResource()))) {
            mainArgs.append(" --configscript \"${workspace_loc:").append(javaProject.getElementName()).append('}').append(File.separatorChar).append(compilerOptions.groovyCompilerConfigScript).append('\"');
        }
        if (compilerOptions.defaultEncoding != null && !compilerOptions.defaultEncoding.isEmpty()) {
            mainArgs.append(" --encoding ").append(compilerOptions.defaultEncoding);
        }
        if ((compilerOptions.groovyFlags & 2) != 0) {
            mainArgs.append(" --indy");
        }
        if (compilerOptions.produceMethodParameters) {
            mainArgs.append(" --parameters");
        }
        if (compilerOptions.enablePreviewFeatures) {
            mainArgs.append(" --enable-preview");
        }
        if (runType != null) {
            try {
                mainArgs.append(" \"${workspace_loc:").append(runType.getResource().getFullPath().toOSString().substring(1)).append("}\"");
            }
            catch (NullPointerException nullPointerException) {
                GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_failureToLaunch, (Object)this.applicationOrConsole()), (Throwable)new IllegalArgumentException(LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_notFound, (Object)runType.getElementName())));
            }
        }
        return mainArgs.toString();
    }

    protected String classToRun() {
        throw new IllegalStateException(this.getClass().getSimpleName() + " must override classToRun() or mainArgs(IType,IJavaProject)");
    }

    protected Map<String, String> createLaunchProperties(RunningMode runningMode, IType runType, IJavaProject javaProject) {
        HashMap<String, String> launchConfigProperties = new HashMap<String, String>();
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, "org.codehaus.groovy.tools.GroovyStarter");
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, javaProject.getElementName());
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "-Dgroovy.home=\"${groovy_home}\" -Djava.system.class.loader=groovy.lang.GroovyClassLoader");
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "--classpath " + this.getRuntimeClasspath(runType, javaProject) + " --main " + this.mainArgs(runType, javaProject));
        launchConfigProperties.put(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.getWorkingDirectory(runningMode, runType, javaProject));
        launchConfigProperties.put(GROOVY_TYPE_TO_RUN, Optional.ofNullable(runType).map(IType::getFullyQualifiedName).orElse(""));
        return launchConfigProperties;
    }

    private String getRuntimeClasspath(IType runType, IJavaProject javaProject) {
        LinkedHashSet<IPath> classpath = new LinkedHashSet<IPath>();
        LinkedHashSet<IJavaProject> done = new LinkedHashSet<IJavaProject>();
        LinkedList<IJavaProject> todo = new LinkedList<IJavaProject>(Arrays.asList(javaProject));
        try {
            boolean excludeTestCode;
            boolean bl = excludeTestCode = runType != null && !CustomGroovyLaunchShortcut.hasTestAttribute((IJavaElement)runType);
            do {
                IJavaProject nextProject;
                if (!done.add(nextProject = (IJavaProject)todo.removeFirst()) || !nextProject.getProject().isAccessible()) continue;
                IClasspathEntry[] iClasspathEntryArray = nextProject.getRawClasspath();
                int n = iClasspathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClasspathEntry entry = iClasspathEntryArray[n2];
                    if (!(excludeTestCode && entry.isTest() || entry.getEntryKind() == 5 && ("GROOVY_DSL_SUPPORT".equals(entry.getPath().segment(0)) || JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))))) {
                        switch (entry.getEntryKind()) {
                            case 3: {
                                if (entry.getOutputLocation() != null) {
                                    classpath.add(entry.getOutputLocation());
                                } else {
                                    classpath.add(nextProject.getOutputLocation());
                                }
                            }
                            case 1: {
                                classpath.add(entry.getPath());
                                break;
                            }
                            case 4: {
                                entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                                if (entry == null) break;
                                classpath.add(entry.getPath());
                                break;
                            }
                            case 2: {
                                String projectName = entry.getPath().segment(0);
                                todo.add(javaProject.getJavaModel().getJavaProject(projectName));
                                break;
                            }
                            case 5: {
                                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)nextProject);
                                Arrays.stream(container.getClasspathEntries()).filter(it -> !excludeTestCode || !it.isTest()).map(IClasspathEntry::getPath).forEach(classpath::add);
                            }
                        }
                    }
                    ++n2;
                }
            } while (!todo.isEmpty());
        }
        catch (JavaModelException e) {
            GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_classpathError, (Object)this.applicationOrConsole()), (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        for (IPath path : classpath) {
            if (path.isEmpty()) {
                sb.append("${workspace_loc}");
            } else {
                path = path.makeAbsolute();
                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)).exists()) {
                    sb.append(path.toOSString());
                } else {
                    sb.append("${workspace_loc:").append(path.segment(0)).append('}');
                    if (path.segmentCount() > 1) {
                        sb.append(File.separatorChar).append(path.removeFirstSegments(1).toOSString());
                    }
                }
            }
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() > 0) {
            sb.insert(0, '\"').deleteCharAt(sb.length() - 1).append('\"');
        }
        return sb.toString();
    }

    private String getWorkingDirectory(RunningMode runningMode, IType runType, IJavaProject javaProject) {
        if (runningMode != RunningMode.GUI) {
            return null;
        }
        String workingDirPreference = this.readWorkingDirPreference();
        if (workingDirPreference == null) {
            return null;
        }
        switch (workingDirPreference) {
            case "eclipse_home": {
                return "${eclipse_home}";
            }
            case "script_loc": {
                if (runType == null) break;
                try {
                    return "${workspace_loc:" + runType.getResource().getParent().getFullPath().toOSString().substring(1) + "}";
                }
                catch (Exception e) {
                    GroovyCore.logException((String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_notFound, (Object)runType.getElementName()), (Throwable)e);
                }
            }
        }
        return null;
    }

    private String readWorkingDirPreference() {
        try {
            return GroovyPlugin.getDefault().getPreferenceStore().getString("groovy.scripts.workingdir");
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected ILaunchConfigurationWorkingCopy findOrCreateLaunchConfig(Map<String, String> launchProperties, String launchName) throws CoreException {
        ILaunchConfiguration config = this.findConfiguration(launchProperties.get(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME), launchProperties.get(GROOVY_TYPE_TO_RUN));
        if (config == null) {
            return this.createLaunchConfig(launchProperties, launchName);
        }
        ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, launchProperties.get(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS));
        return workingCopy;
    }

    private ILaunchConfigurationWorkingCopy createLaunchConfig(Map<String, String> launchProperties, String launchName) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = this.getGroovyLaunchConfigType().newInstance(null, CustomGroovyLaunchShortcut.getLaunchManager().generateLaunchConfigurationName(launchName));
        for (Map.Entry<String, String> entry : launchProperties.entrySet()) {
            workingCopy.setAttribute(entry.getKey(), entry.getValue());
        }
        return workingCopy;
    }

    private ILaunchConfiguration findConfiguration(String projectName, String mainTypeName) throws CoreException {
        ILaunchConfiguration[] configs;
        ILaunchConfiguration returnValue = null;
        ILaunchConfigurationType configType = this.getGroovyLaunchConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = CustomGroovyLaunchShortcut.getLaunchManager().getLaunchConfigurations(configType);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (config.getAttribute(GROOVY_TYPE_TO_RUN, "").equals(mainTypeName) && config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "").equals(projectName)) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        int candidateCount = candidateConfigs.size();
        if (candidateCount == 1) {
            returnValue = (ILaunchConfiguration)candidateConfigs.get(0);
        } else if (candidateCount > 1) {
            returnValue = this.chooseConfiguration(candidateConfigs);
        }
        return returnValue;
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList) {
        return (ILaunchConfiguration)LaunchShortcutHelper.chooseFromList(configList, (ILabelProvider)DebugUITools.newDebugModelPresentation(), (String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_title, (Object)this.applicationOrConsole()), (String)LaunchShortcutHelper.bind((String)LaunchShortcutHelper.GroovyLaunchShortcut_message, (Object)this.applicationOrConsole()));
    }

    protected static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected static boolean hasTestAttribute(IJavaElement element) throws JavaModelException {
        return element.getJavaProject().isOnClasspath(element) && JavaModelUtil.getPackageFragmentRoot((IJavaElement)element).getResolvedClasspathEntry().isTest();
    }

    protected static boolean matchesScriptFilter(IResource resource) {
        return new ScriptFolderSelector(resource.getProject()).isScript(resource);
    }
}

