/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.launch;

import com.kms.katalon.core.logging.XMLLoggerParser;
import com.kms.katalon.core.logging.XmlLogRecord;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ServerSocketFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionLogServer {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionLogServer.class);
    private static final String[] IGNORED_LIST = new String[]{"<log>", "</log>", "<?xml", "<!DOCTYPE log SYSTEM \"logger.dtd\">"};
    private static final String TAG_END_RECORD = "</record>";
    private static final String LINE_SEPERATOR = System.getProperty("line.separator");
    private final int port;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final List<IExecutionLogListener> listeners = new ArrayList<IExecutionLogListener>();
    private ServerSocket serverSocket;
    private Thread serverThread;

    public ExecutionLogServer(int port) {
        this.port = port;
    }

    public void start() throws IOException {
        if (this.serverThread != null && this.serverThread.isAlive()) {
            logger.warn("Server is already running on port {}", (Object)this.port);
            return;
        }
        if (this.stopped.get()) {
            logger.warn("Server has been stopped and cannot be restarted.");
            return;
        }
        this.serverSocket = ServerSocketFactory.getDefault().createServerSocket(this.port);
        this.serverThread = new Thread(this::serverLoop, "ExecutionLogServer-" + this.port);
        this.serverThread.start();
    }

    public void stop() {
        if (this.stopped.get()) {
            return;
        }
        this.stopped.set(true);
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            IOUtils.closeQuietly((ServerSocket)this.serverSocket);
        }
        if (this.serverThread != null) {
            try {
                this.serverThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IExecutionLogListener listener) {
        List<IExecutionLogListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IExecutionLogListener listener) {
        List<IExecutionLogListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int getPort() {
        return this.port;
    }

    private void serverLoop() {
        while (!this.stopped.get()) {
            Socket clientSocket = null;
            try {
                clientSocket = this.serverSocket.accept();
                this.handleClient(clientSocket);
            }
            catch (Exception e) {
                if (!this.stopped.get()) {
                    logger.error("Error accepting client connection", (Throwable)e);
                }
                IOUtils.closeQuietly((Socket)clientSocket);
                break;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void handleClient(Socket clientSocket) {
        try {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));){
                    String line;
                    StringBuilder buffer = new StringBuilder();
                    while (!this.stopped.get() && (line = reader.readLine()) != null) {
                        if (this.isIgnoredLine(line)) continue;
                        buffer.append(LINE_SEPERATOR + line);
                        if (!TAG_END_RECORD.equals(line.trim())) continue;
                        String formattedString = buffer.insert(0, "<log>").append("</log>").toString();
                        List records = XMLLoggerParser.readFromString((String)formattedString);
                        buffer.setLength(0);
                        this.notifyLogRecordsReceived(records);
                    }
                    this.notifyReadingFinished();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.error("Failed to handle client socket", (Throwable)e);
                IOUtils.closeQuietly((Socket)clientSocket);
            }
            catch (XMLStreamException e) {
                logger.error("Failed to parse XML log records", (Throwable)e);
                IOUtils.closeQuietly((Socket)clientSocket);
            }
            catch (Exception e) {
                logger.error("Unexpected error while handling client socket", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Socket)clientSocket);
            }
        }
        finally {
            IOUtils.closeQuietly((Socket)clientSocket);
        }
    }

    protected boolean isIgnoredLine(String line) {
        String[] stringArray = IGNORED_LIST;
        int n = IGNORED_LIST.length;
        int n2 = 0;
        while (n2 < n) {
            String ignoredString = stringArray[n2];
            if (line.equals(ignoredString) || line.startsWith(ignoredString)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLogRecordsReceived(List<XmlLogRecord> records) {
        ArrayList<IExecutionLogListener> currentListeners;
        List<IExecutionLogListener> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<IExecutionLogListener>(this.listeners);
        }
        for (IExecutionLogListener listener : currentListeners) {
            try {
                listener.onLogRecordsReceived(records);
            }
            catch (Exception e) {
                logger.error("Failed to notify listener", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyReadingFinished() {
        ArrayList<IExecutionLogListener> currentListeners;
        List<IExecutionLogListener> list = this.listeners;
        synchronized (list) {
            currentListeners = new ArrayList<IExecutionLogListener>(this.listeners);
        }
        for (IExecutionLogListener listener : currentListeners) {
            try {
                listener.onReadingFinished();
            }
            catch (Exception e) {
                logger.error("Failed to notify listener", (Throwable)e);
            }
        }
    }

    public static interface IExecutionLogListener {
        public void onLogRecordsReceived(List<XmlLogRecord> var1);

        public void onReadingFinished();
    }
}

