/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.launch;

import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.execution.launcher.process.ProcessStdoutFileExporter;
import com.kms.katalon.execution.logging.RecordingOutputStreamHandler;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchOutputConsumer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(LaunchOutputConsumer.class);
    private final IEventBroker eventBroker;
    private final ILaunch launch;
    private final File outputFolder;
    private final RunningMode runningMode;
    private final boolean shouldPrintToConsole;
    private volatile ProcessStdoutFileExporter exporter;
    private ExecutorService executorService;
    private IStreamListener outListener;
    private IStreamListener errListener;
    private IStreamMonitor outMonitor;
    private IStreamMonitor errMonitor;

    public LaunchOutputConsumer(IEventBroker eventBroker, ILaunch launch, File outputFolder, RunningMode runningMode, boolean shouldPrintToConsole) throws SecurityException, IOException {
        if (launch == null) {
            throw new IllegalArgumentException("Launch cannot be null");
        }
        this.eventBroker = eventBroker;
        this.launch = launch;
        this.outputFolder = outputFolder;
        this.runningMode = runningMode;
        this.shouldPrintToConsole = shouldPrintToConsole;
    }

    public void start() {
        this.executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "LaunchOutputConsumer-Thread"));
        this.executorService.submit(() -> {
            try {
                this.internallyStart();
            }
            catch (Exception e) {
                logger.error("Failed to start LaunchOutputConsumer", (Throwable)e);
            }
        });
    }

    private void internallyStart() throws SecurityException, IOException {
        IProcess process;
        this.exporter = new ProcessStdoutFileExporter(this.outputFolder);
        IProcess iProcess = process = this.launch.getProcesses().length > 0 ? this.launch.getProcesses()[0] : null;
        if (process == null) {
            throw new IllegalArgumentException("Launch has no associated process");
        }
        this.outMonitor = process.getStreamsProxy().getOutputStreamMonitor();
        this.errMonitor = process.getStreamsProxy().getErrorStreamMonitor();
        if (this.runningMode == RunningMode.CONSOLE && this.shouldPrintToConsole) {
            this.outListener = (text, monitor) -> this.processLog(text, false, true);
            this.errListener = (text, monitor) -> this.processLog(text, true, true);
        } else {
            this.outListener = (text, monitor) -> this.processLog(text, false, false);
            this.errListener = (text, monitor) -> this.processLog(text, true, false);
        }
        this.outMonitor.addListener(this.outListener);
        this.errMonitor.addListener(this.errListener);
        this.exporter.run();
    }

    private void processLog(String text, boolean isStderr, boolean shouldPrintToConsole) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        if (isStderr) {
            if (shouldPrintToConsole) {
                System.err.println(text);
            }
            this.exporter.recordStderrLog(text);
        } else {
            if (shouldPrintToConsole) {
                System.out.println(text);
            }
            this.exporter.recordStdoutLog(text);
        }
        if (this.eventBroker == null) {
            return;
        }
        String eventTopic = "EXECUTION_V2/ON_CONSOLE_LOG_RECEIVED";
        this.eventBroker.post(eventTopic, (Object)RecordingOutputStreamHandler.RecordedOutputLine.newInstance((RecordingOutputStreamHandler.OutputType)(isStderr ? RecordingOutputStreamHandler.OutputType.ERROR : RecordingOutputStreamHandler.OutputType.OUTPUT), (String)text));
    }

    @Override
    public void close() {
        if (this.exporter != null) {
            try {
                this.exporter.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close ProcessStdoutFileExporter", (Throwable)e);
            }
        }
        if (this.outMonitor != null && this.outListener != null) {
            this.outMonitor.removeListener(this.outListener);
        }
        if (this.errMonitor != null && this.errListener != null) {
            this.errMonitor.removeListener(this.errListener);
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

