/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.launch;

import com.katalon.execution.services.launch.CustomGroovyLaunchShortcut;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.groovy.eclipse.launchers.LaunchShortcutHelper;
import org.codehaus.jdt.groovy.model.GroovyProjectFacade;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ILabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchShortcut
extends CustomGroovyLaunchShortcut {
    private static final Logger logger = LoggerFactory.getLogger(LaunchShortcut.class);
    private static final String JVM_ARGUMENT_MAX_MEMORY_KEY = "-Xmx";
    private static final String LAUNCH_CONFIGURATION_TYPE_ID_FOR_GUI = "com.katalon.execution.ideLaunchConfiguration";
    private static final String LAUNCH_CONFIGURATION_TYPE_ID_FOR_CONSOLE = "com.katalon.execution.consoleLaunchConfiguration";
    private RunningMode runningMode;

    public LaunchShortcut(RunningMode runningMode) {
        this.runningMode = runningMode;
    }

    public ILaunch launch(IFile scriptFile, LaunchMode launchMode, Map<String, String> environmentVariables, List<String> vmArgs, String[] defaultClassPaths) throws CoreException {
        if (scriptFile == null) {
            return null;
        }
        ICompilationUnit compilationUnit = JavaCore.createCompilationUnitFrom((IFile)scriptFile);
        if (compilationUnit == null) {
            logger.warn("Cannot create compilation unit from file: {}", (Object)scriptFile.getFullPath());
            return null;
        }
        return this.internallyLaunchGroovy(compilationUnit, launchMode.toString(), environmentVariables, vmArgs, defaultClassPaths);
    }

    public static void cleanConfiguration(ILaunch launch) {
        LaunchShortcut.getLaunchManager().removeLaunch(launch);
    }

    public static void cleanAllConfigurations() throws CoreException {
        while (LaunchShortcut.getLaunchManager().getLaunchConfigurations().length > 0) {
            LaunchShortcut.getLaunchManager().getLaunchConfigurations()[0].delete();
        }
    }

    @Override
    public ILaunchConfigurationType getGroovyLaunchConfigType() {
        String configurationTypeId = this.runningMode == RunningMode.GUI ? LAUNCH_CONFIGURATION_TYPE_ID_FOR_GUI : LAUNCH_CONFIGURATION_TYPE_ID_FOR_CONSOLE;
        ILaunchConfigurationType result = LaunchShortcut.getLaunchManager().getLaunchConfigurationType(configurationTypeId);
        if (result == null) {
            logger.info("Cannot find launch configuration type for id: {}", (Object)configurationTypeId);
            logger.info("Available launch configuration types:" + Arrays.toString(LaunchShortcut.getLaunchManager().getLaunchConfigurationTypes()));
        }
        return result;
    }

    @Override
    protected String classToRun() {
        return "groovy.ui.GroovyMain";
    }

    private ILaunch internallyLaunchGroovy(ICompilationUnit unit, String mode, Map<String, String> environmentVariables, List<String> vmArgs, String[] defaultClassPaths) throws CoreException {
        Object vmArguments;
        IType[] types = unit.getAllTypes();
        if (types == null || types.length == 0) {
            logger.warn("No types found in the compilation unit: {}", (Object)unit.getElementName());
            return null;
        }
        IType runType = this.findClassToRun(types);
        if (runType == null) {
            logger.warn("No runnable class found in the compilation unit: {}", (Object)unit.getElementName());
            return null;
        }
        IJavaProject javaProject = unit.getJavaProject();
        Map<String, String> launchConfigProperties = this.createLaunchProperties(this.runningMode, runType, javaProject);
        ILaunchConfigurationWorkingCopy workingConfig = this.findOrCreateLaunchConfig(launchConfigProperties, runType.getElementName());
        if (environmentVariables != null && !environmentVariables.isEmpty()) {
            workingConfig.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environmentVariables);
        }
        if (!((String)(vmArguments = workingConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, ""))).contains(JVM_ARGUMENT_MAX_MEMORY_KEY)) {
            vmArguments = (String)vmArguments + " -Xmx" + LaunchShortcut.byteToMegabytes(Runtime.getRuntime().maxMemory()) + "m";
        }
        if (vmArgs != null) {
            for (String eachArg : vmArgs) {
                vmArguments = (String)vmArguments + " " + eachArg;
            }
        }
        workingConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, (String)vmArguments);
        Object[] classPaths = defaultClassPaths;
        if (classPaths == null || ArrayUtils.isEmpty((Object[])classPaths)) {
            classPaths = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        workingConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, Arrays.asList(classPaths));
        workingConfig.setAttribute(IJavaLaunchConfigurationConstants.ATTR_USE_ARGFILE, true);
        workingConfig.setAttribute("org.eclipse.debug.core.TERMINATE_DESCENDANTS", false);
        ILaunchConfiguration config = workingConfig.doSave();
        config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
        return config.launch(mode, (IProgressMonitor)new NullProgressMonitor());
    }

    private IType findClassToRun(IType[] types) {
        ArrayList<IType> candidates = new ArrayList<IType>();
        int i = 0;
        while (i < types.length) {
            if (GroovyProjectFacade.hasGroovyMainMethod((IType)types[i])) {
                candidates.add(types[i]);
            }
            ++i;
        }
        if (candidates.isEmpty()) {
            logger.warn("No candidates found to run.");
            return null;
        }
        if (candidates.size() == 1) {
            return (IType)candidates.get(0);
        }
        if (candidates.size() > 1) {
            logger.info("Multiple candidates found to run: {}", candidates);
        }
        return (IType)LaunchShortcutHelper.chooseFromList(Arrays.asList(types), (ILabelProvider)new JavaUILabelProvider(), (String)LaunchShortcutHelper.SelectMainTypeDialog_title, (String)LaunchShortcutHelper.SelectMainTypeDialog_message);
    }

    private static long byteToMegabytes(long maxMemory) {
        return maxMemory / 0x100000L;
    }
}

