/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.launch.jdt;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.logging.LogExceptionFilter;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.File;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;

public class SourceLocator
extends JavaSourceLookupDirector {
    public Object getSourceElement(Object element) {
        if (element instanceof JDIStackFrame) {
            JDIStackFrame stackFrame = (JDIStackFrame)element;
            try {
                String className = stackFrame.getDeclaringTypeName();
                if (LogExceptionFilter.isTestCaseScript((String)className)) {
                    TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByScriptName(className);
                    String testCaseRelative = GroovyUtil.getScriptPackageRelativePathForTestCase((TestCaseEntity)testCase);
                    String testCaseScriptName = GroovyUtil.getScriptNameForTestCase((TestCaseEntity)testCase) + ".groovy";
                    return GroovyUtil.getGroovyProject((ProjectEntity)testCase.getProject()).getFile(testCaseRelative + File.separator + testCaseScriptName);
                }
                if (LogExceptionFilter.isCustomKeywordScript((String)className)) {
                    for (IFile scriptFile : GroovyUtil.getAllScriptFiles((IFolder)GroovyUtil.getCustomKeywordSourceFolder((ProjectEntity)ProjectController.getInstance().getCurrentProject()))) {
                        GroovyCompilationUnit unit = (GroovyCompilationUnit)JavaCore.createCompilationUnitFrom((IFile)scriptFile);
                        if (!className.equals(unit.getModuleNode().getMainClassName())) continue;
                        return scriptFile;
                    }
                }
                if (stackFrame.getDeclaringTypeName() != null) {
                    IJavaProject javaProject = JavaCore.create((IProject)GroovyUtil.getGroovyProject((ProjectEntity)ProjectController.getInstance().getCurrentProject()));
                    IJavaElement javaElement = JavaDebugUtils.findElement((String)stackFrame.getDeclaringTypeName(), (IJavaProject)javaProject);
                    if (javaElement != null) {
                        className.startsWith("com.kms.katalon.core");
                    }
                    return javaElement;
                }
            }
            catch (Exception exception) {}
        }
        return super.getSourceElement(element);
    }
}

