/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.logrecord;

import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestStepLogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.services.logrecord.LogRecordTestResultCalculator;
import com.kms.katalon.core.logging.LogLevel;
import com.kms.katalon.core.logging.XmlLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.testcase.VariableReport;
import com.kms.katalon.util.DateTimes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionXMLLogParser {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionXMLLogParser.class);
    private Deque<LogRecord> logRecordStack = new ArrayDeque<LogRecord>();
    private static String listenerStepPrefix = "^(Start listener action|Start setup action|Start tear down) : ";
    private static final Pattern LISTENER_STEP_PATTERN = Pattern.compile(listenerStepPrefix);

    public LogRecord mapLogRecord(XmlLogRecord xmlLogRecord) {
        String sourceMethodName = xmlLogRecord.getSourceMethodName();
        if (LogLevel.START.toString().equals(xmlLogRecord.getLevel().getName())) {
            if ("startSuite".equals(sourceMethodName)) {
                return this.processStartTestSuiteLog(xmlLogRecord);
            }
            if ("startTest".equals(sourceMethodName)) {
                return this.processStartTestCaseLog(xmlLogRecord);
            }
            if ("startKeyword".equals(sourceMethodName)) {
                return this.processStartKeywordLog(xmlLogRecord);
            }
            logger.warn("Unknown START log with source method: {}", (Object)sourceMethodName);
            return null;
        }
        if (LogLevel.END.toString().equals(xmlLogRecord.getLevel().getName())) {
            if ("endKeyword".equals(sourceMethodName) || "endTest".equals(sourceMethodName) || "endSuite".equals(sourceMethodName)) {
                return this.processEndLog(xmlLogRecord);
            }
            logger.warn("Unknown END log with source method: {}", (Object)sourceMethodName);
            return null;
        }
        if (LogLevel.RUN_DATA.toString().equals(xmlLogRecord.getLevel().getName())) {
            LogRecord logRecord;
            Map runData = xmlLogRecord.getProperties();
            if (runData != null && runData.containsKey("executionBindingVariables")) {
                logRecord = this.logRecordStack.peekLast();
                if (logRecord instanceof TestCaseLogRecord) {
                    TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
                    List<VariableReport> variableList = ExecutionXMLLogParser.extractVariableList((String)runData.get("executionBindingVariables"));
                    if (variableList != null) {
                        testCaseLogRecord.setVariableReports(variableList);
                    }
                }
                runData.remove("executionBindingVariables");
            }
            if ((logRecord = this.logRecordStack.peekFirst()) instanceof TestSuiteLogRecord) {
                TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)logRecord;
                if (runData == null || runData.isEmpty()) {
                    return testSuiteLogRecord;
                }
                testSuiteLogRecord.addRunData(runData);
                return testSuiteLogRecord;
            }
            LogRecord logRecord2 = this.logRecordStack.peekFirst();
            if (logRecord2 instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord2;
                if (runData == null || runData.isEmpty()) {
                    return testCaseLogRecord;
                }
                testCaseLogRecord.addRunData(runData);
                return testCaseLogRecord;
            }
            logger.warn("Unexpected RUN_DATA log of type: {}. Props = {}", (Object)this.logRecordStack.peekFirst().getClass().getSimpleName(), (Object)xmlLogRecord.getProperties());
            return null;
        }
        LogRecord latestRecord = this.logRecordStack.peekLast();
        return this.processStepMessageLog(xmlLogRecord, latestRecord);
    }

    public List<LogRecord> collectIncompleteLogRecords() {
        return new ArrayList<LogRecord>(this.logRecordStack);
    }

    private TestSuiteLogRecord processStartTestSuiteLog(XmlLogRecord xmlLogRecord) {
        TestSuiteLogRecord testSuiteLogRecord = new TestSuiteLogRecord();
        testSuiteLogRecord.setStartTime(xmlLogRecord.getMillis());
        if (StringUtils.isNotBlank((CharSequence)xmlLogRecord.getEndTime())) {
            testSuiteLogRecord.setEndTime(DateTimes.parseISO8601((String)xmlLogRecord.getEndTime()).getTime());
        }
        String name = this.getStringProperty(xmlLogRecord, "name", ExecutionXMLLogParser.getTestLogName(xmlLogRecord, false));
        StringUtils.isBlank((CharSequence)name);
        testSuiteLogRecord.setName(name);
        testSuiteLogRecord.setId(this.getStringProperty(xmlLogRecord, "id", ""));
        testSuiteLogRecord.setSource(this.getStringProperty(xmlLogRecord, "source", ""));
        testSuiteLogRecord.setDevicePlatform(this.getStringProperty(xmlLogRecord, "devicePlatform", ""));
        testSuiteLogRecord.setDescription(this.getStringProperty(xmlLogRecord, "description", ""));
        this.logRecordStack.add((LogRecord)testSuiteLogRecord);
        return testSuiteLogRecord;
    }

    private TestCaseLogRecord processStartTestCaseLog(XmlLogRecord xmlLogRecord) {
        TestCaseLogRecord testCaseLogRecord = new TestCaseLogRecord();
        String testCaseExecutionIdStr = this.getStringProperty(xmlLogRecord, "uuid", "");
        if (!StringUtils.isBlank((CharSequence)testCaseExecutionIdStr)) {
            testCaseLogRecord.setTestCaseExecutionId(UUID.fromString(testCaseExecutionIdStr));
        }
        testCaseLogRecord.setStartTime(xmlLogRecord.getMillis());
        if (StringUtils.isNotBlank((CharSequence)xmlLogRecord.getEndTime())) {
            testCaseLogRecord.setEndTime(DateTimes.parseISO8601((String)xmlLogRecord.getEndTime()).getTime());
        }
        String name = this.getStringProperty(xmlLogRecord, "name", ExecutionXMLLogParser.getTestLogName(xmlLogRecord, false));
        StringUtils.isBlank((CharSequence)name);
        testCaseLogRecord.setName(name);
        String uniqueIdStr = testCaseExecutionIdStr;
        if (StringUtils.isBlank((CharSequence)uniqueIdStr) && StringUtils.isBlank((CharSequence)(uniqueIdStr = this.getStringProperty(xmlLogRecord, "BDD_TESTRUN_UUID", "")))) {
            uniqueIdStr = UUID.randomUUID().toString();
        }
        testCaseLogRecord.setId(uniqueIdStr);
        testCaseLogRecord.setSource(this.getStringProperty(xmlLogRecord, "source", ""));
        testCaseLogRecord.setDescription(this.getStringProperty(xmlLogRecord, "description", ""));
        testCaseLogRecord.setTag(xmlLogRecord.getProperties().containsKey("tag") ? StringEscapeUtils.unescapeJava((String)((String)xmlLogRecord.getProperties().get("tag"))) : "");
        testCaseLogRecord.setOrigin(this.getStringProperty(xmlLogRecord, "origin", ""));
        testCaseLogRecord.setOptional(this.getStringProperty(xmlLogRecord, "isOptional", "false").equalsIgnoreCase("true"));
        testCaseLogRecord.setIterationVariableValue(this.getStringProperty(xmlLogRecord, "iteration", ""));
        testCaseLogRecord.setAttemptIndex(this.getIntProperty(xmlLogRecord, "currentRetryCount", 0));
        LogRecord latestRecord = this.logRecordStack.peekLast();
        if (latestRecord instanceof TestSuiteLogRecord || latestRecord instanceof TestStepLogRecord) {
            latestRecord.addChildRecord((LogRecord)testCaseLogRecord);
        }
        this.logRecordStack.add((LogRecord)testCaseLogRecord);
        return testCaseLogRecord;
    }

    private TestStepLogRecord processStartKeywordLog(XmlLogRecord xmlLogRecord) {
        TestStepLogRecord testStepLogRecord = new TestStepLogRecord();
        if (ExecutionXMLLogParser.isListenerStep(xmlLogRecord.getMessage())) {
            testStepLogRecord.setTestListenerStep(true);
        }
        testStepLogRecord.setId(UUID.randomUUID().toString());
        testStepLogRecord.setStartTime(xmlLogRecord.getMillis());
        if (StringUtils.isNotBlank((CharSequence)xmlLogRecord.getEndTime())) {
            testStepLogRecord.setEndTime(DateTimes.parseISO8601((String)xmlLogRecord.getEndTime()).getTime());
        }
        String name = ExecutionXMLLogParser.getTestLogName(xmlLogRecord, testStepLogRecord.isTestListenerStep());
        StringUtils.isBlank((CharSequence)name);
        testStepLogRecord.setName(name);
        testStepLogRecord.setDescription(this.getStringProperty(xmlLogRecord, "description", ""));
        String logStepIndexStr = (String)xmlLogRecord.getProperties().get("stepIndex");
        if (logStepIndexStr != null && !logStepIndexStr.isEmpty()) {
            try {
                testStepLogRecord.setIndex(Integer.valueOf(logStepIndexStr).intValue());
            }
            catch (NumberFormatException e) {
                logger.warn("Failed to parse test step index from log properties: " + logStepIndexStr, (Throwable)e);
                testStepLogRecord.setIndex(-1);
            }
        }
        testStepLogRecord.setIgnoredIfFailed(this.getStringProperty(xmlLogRecord, "isIgnoredIfFailed", "false").equalsIgnoreCase("true"));
        LogRecord latestRecord = this.logRecordStack.peekLast();
        if (latestRecord instanceof TestSuiteLogRecord) {
            if (testStepLogRecord.isTestListenerStep()) {
                latestRecord.addChildRecord((LogRecord)testStepLogRecord);
            }
        } else if (latestRecord instanceof TestCaseLogRecord || latestRecord instanceof TestStepLogRecord) {
            latestRecord.addChildRecord((LogRecord)testStepLogRecord);
        }
        this.logRecordStack.add((LogRecord)testStepLogRecord);
        return testStepLogRecord;
    }

    private LogRecord processEndLog(XmlLogRecord xmlLogRecord) {
        LogRecord latestRecord = this.logRecordStack.pollLast();
        if (latestRecord == null) {
            return null;
        }
        latestRecord.setEndTime(xmlLogRecord.getMillis());
        latestRecord.setProperties(xmlLogRecord.getProperties());
        if (latestRecord instanceof TestStepLogRecord) {
            TestStepLogRecord testStepLogRecord = (TestStepLogRecord)latestRecord;
            testStepLogRecord.setFailedReason((String)LogRecordTestResultCalculator.buildFailedReason((LogRecord)testStepLogRecord).orElse(null));
        }
        return latestRecord;
    }

    private MessageLogRecord processStepMessageLog(XmlLogRecord xmlLogRecord, LogRecord latestLogRecord) {
        if (latestLogRecord instanceof TestSuiteLogRecord) {
            return null;
        }
        MessageLogRecord messageLogRecord = new MessageLogRecord();
        messageLogRecord.setStartTime(xmlLogRecord.getMillis());
        messageLogRecord.setMessage(xmlLogRecord.getMessage());
        messageLogRecord.setLogLevel(xmlLogRecord.getLevel());
        if (xmlLogRecord.getProperties() != null) {
            if (xmlLogRecord.getProperties().get("attachment") != null) {
                messageLogRecord.setAttachment((String)xmlLogRecord.getProperties().get("attachment"));
            }
            if (xmlLogRecord.getProperties().get("video-attachment") != null) {
                messageLogRecord.setVideoAttachment((String)xmlLogRecord.getProperties().get("video-attachment"));
            }
            if (xmlLogRecord.getProperties().get("selfHealingApplied") != null) {
                boolean selfHealingApplied = ((String)xmlLogRecord.getProperties().get("selfHealingApplied")).equalsIgnoreCase("true");
                messageLogRecord.setSelfHealingApplied(selfHealingApplied);
                if (latestLogRecord instanceof TestStepLogRecord) {
                    TestStepLogRecord testStepLogRecord = (TestStepLogRecord)latestLogRecord;
                    testStepLogRecord.setSelfHealingApplied(selfHealingApplied);
                    TestCaseLogRecord ancestorTestCaseLogRecord = this.findAncestorTestCaseLogRecord(testStepLogRecord);
                    if (ancestorTestCaseLogRecord != null) {
                        ancestorTestCaseLogRecord.setSelfHealingApplied(selfHealingApplied);
                    }
                }
            }
        }
        messageLogRecord.setTestStatus(this.mapJavaLogLevelToTestStatus(xmlLogRecord.getLevel()));
        if (latestLogRecord != null) {
            latestLogRecord.addChildRecord((LogRecord)messageLogRecord);
        } else {
            logger.warn("No latest log record found to attach message log: {}", (Object)xmlLogRecord.getMessage());
        }
        return messageLogRecord;
    }

    private TestCaseLogRecord findAncestorTestCaseLogRecord(TestStepLogRecord testStepLogRecord) {
        LogRecord parent = testStepLogRecord.getParent();
        while (parent != null) {
            if (parent instanceof TestCaseLogRecord) {
                TestCaseLogRecord parentTestCaseLogRecord = (TestCaseLogRecord)parent;
                return parentTestCaseLogRecord;
            }
            if (parent instanceof TestStepLogRecord) {
                TestStepLogRecord parentTestStepLogRecord = (TestStepLogRecord)parent;
                parent = parentTestStepLogRecord.getParent();
                continue;
            }
            logger.warn("Unrecognized parent log record type: {}", (Object)parent.getClass().getSimpleName());
            break;
        }
        return null;
    }

    private TestStatus mapJavaLogLevelToTestStatus(Level javaLogLevel) {
        TestStatus testStatus = new TestStatus();
        testStatus.setStatusValue(TestStatus.TestStatusValue.valueOf((String)LogLevel.valueOf((String)javaLogLevel.toString()).name()));
        return testStatus;
    }

    private String getStringProperty(XmlLogRecord xmlLogRecord, String propertyKey, String defaultValue) {
        if (xmlLogRecord.getProperties() == null) {
            return defaultValue;
        }
        String value = (String)xmlLogRecord.getProperties().get(propertyKey);
        return value == null ? defaultValue : value;
    }

    private int getIntProperty(XmlLogRecord xmlLogRecord, String propertyKey, int defaultValue) {
        if (xmlLogRecord.getProperties() == null) {
            return defaultValue;
        }
        String value = (String)xmlLogRecord.getProperties().get(propertyKey);
        try {
            return value == null ? defaultValue : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static String getTestLogName(XmlLogRecord xmlLogRecord, boolean isTestListenerStep) {
        String testLogName = xmlLogRecord.getMessage();
        if (testLogName == null) {
            return "";
        }
        if (isTestListenerStep) {
            return testLogName.replaceFirst(listenerStepPrefix, "");
        }
        String startKeywordString = "Start action : ";
        if (testLogName.startsWith(startKeywordString)) {
            return testLogName.substring(startKeywordString.length(), testLogName.length());
        }
        return testLogName;
    }

    private static boolean isListenerStep(String stepMessage) {
        if (stepMessage == null) {
            return false;
        }
        Matcher matcher = LISTENER_STEP_PATTERN.matcher(stepMessage);
        return matcher.find();
    }

    private static List<VariableReport> extractVariableList(String rawDataBinding) {
        if (rawDataBinding == null || rawDataBinding.isEmpty()) {
            return null;
        }
        try {
            return ReportUtil.parseDataBinding((String)rawDataBinding);
        }
        catch (Exception e) {
            logger.error("Failed to parse variable reports from data binding: " + rawDataBinding, (Throwable)e);
            return null;
        }
    }
}

