/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.logrecord;

import com.katalon.execution.dto.result.TestCaseExecutionResult;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.dto.result.TestStepExecutionResult;
import com.katalon.execution.dto.result.TestSuiteCollectionExecutionResult;
import com.katalon.execution.dto.result.TestSuiteExecutionResult;
import com.katalon.execution.event.ExecutionResultUpdatedEvent;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestStepLogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestListenerExecution;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.logrecord.LogRecordTestResultCalculator;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.testcase.TestCaseBinding;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRecordSynchronizer {
    private final Logger logger = LoggerFactory.getLogger(LogRecordSynchronizer.class);
    private final IEventBroker eventBroker;
    private final EntityExecution entityExecution;
    private final Map<UUID, TestCaseExecution> testCaseExecutionMap = new HashMap<UUID, TestCaseExecution>();
    private final Map<UUID, TestCaseBinding> testCaseBindingMap = new HashMap<UUID, TestCaseBinding>();
    private final LogRecordTestResultCalculator testResultCalculator = new LogRecordTestResultCalculator();
    private final Map<String, TestEntityExecutionResult> cachedEntityResultMap = new HashMap<String, TestEntityExecutionResult>();
    private final Set<String> laterAddedNodeIds = new HashSet<String>();

    public LogRecordSynchronizer(EntityExecution entityExecution, IEventBroker eventBroker) {
        this.entityExecution = entityExecution;
        this.eventBroker = eventBroker;
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            for (BaseTestCaseExecution baseTestCaseExecution : testSuiteExecutionAttempt.getTestCaseExecutions()) {
                if (baseTestCaseExecution instanceof TestCaseExecution) {
                    TestCaseExecution testCaseExecution = (TestCaseExecution)baseTestCaseExecution;
                    this.testCaseExecutionMap.put(testCaseExecution.getId(), testCaseExecution);
                }
                if (!(baseTestCaseExecution instanceof TestCaseBindingExecution)) continue;
                TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)baseTestCaseExecution;
                for (TestCaseExecution iteration : testCaseBindingExecution.getIterations()) {
                    this.testCaseExecutionMap.put(iteration.getId(), iteration);
                }
                for (TestCaseBinding testCaseBinding : testCaseBindingExecution.getTestCaseBindings()) {
                    this.testCaseBindingMap.put(testCaseBinding.getTestCaseExecutionId(), testCaseBinding);
                }
            }
            return;
        }
        if (entityExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)entityExecution;
            for (TestCaseExecution iteration : testCaseBindingExecution.getIterations()) {
                this.testCaseExecutionMap.put(iteration.getId(), iteration);
            }
            for (TestCaseBinding testCaseBinding : testCaseBindingExecution.getTestCaseBindings()) {
                this.testCaseBindingMap.put(testCaseBinding.getTestCaseExecutionId(), testCaseBinding);
            }
        }
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            this.testCaseExecutionMap.put(testCaseExecution.getId(), testCaseExecution);
        }
    }

    public List<TestEntityExecutionResult> syncLogRecordsToOriginalPlan(List<LogRecord> newLogRecords) {
        EntityExecution entityExecution = this.entityExecution;
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            return this.syncLogRecordsToOriginalTestSuiteExecutionAttempt(newLogRecords, testSuiteExecutionAttempt);
        }
        EntityExecution entityExecution2 = this.entityExecution;
        if (entityExecution2 instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)entityExecution2;
            return this.syncLogRecordsToOriginalTestCaseBindingExecution(newLogRecords, testCaseBindingExecution);
        }
        EntityExecution entityExecution3 = this.entityExecution;
        if (entityExecution3 instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution3;
            return this.syncLogRecordsToOriginalTestCaseExecution(newLogRecords, testCaseExecution);
        }
        this.logger.warn("Unsupported EntityExecution type: " + this.entityExecution.getClass().getName());
        return List.of();
    }

    private List<TestEntityExecutionResult> syncLogRecordsToOriginalTestSuiteExecutionAttempt(List<LogRecord> newLogRecords, TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        ArrayList<TestEntityExecutionResult> changedItems = new ArrayList<TestEntityExecutionResult>();
        for (LogRecord newLogRecord : newLogRecords) {
            if (newLogRecord instanceof TestSuiteLogRecord) {
                TestSuiteExecution parentTestSuiteExecution;
                EntityExecution entityExecution;
                TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testSuiteLogRecord);
                this.syncTestSuiteToOriginalPlan(testSuiteLogRecord, testSuiteExecutionAttempt);
                String parentIdForUI = this.findParentIDForUI(testSuiteExecutionAttempt);
                TestSuiteCollectionExecution tscExecution = testSuiteExecutionAttempt.getTSCExecution();
                if (tscExecution != null) {
                    changedItems.add((TestEntityExecutionResult)TestSuiteCollectionExecutionResult.fromTestSuiteCollectionExecution((TestSuiteCollectionExecution)tscExecution));
                }
                if (testSuiteExecutionAttempt.getAttemptIndex() == 1 && (entityExecution = testSuiteExecutionAttempt.getParentEntityExecution()) instanceof TestSuiteExecution && !this.laterAddedNodeIds.contains((parentTestSuiteExecution = (TestSuiteExecution)entityExecution).getIdString())) {
                    this.laterAddedNodeIds.add(parentTestSuiteExecution.getIdString());
                    TestSuiteExecutionAttempt firstAttempt = parentTestSuiteExecution.getFirstAttempt();
                    changedItems.add((TestEntityExecutionResult)TestSuiteExecutionResult.fromTestSuiteExecution((TestSuiteExecution)parentTestSuiteExecution, null, (String)firstAttempt.getIdString()));
                    changedItems.add((TestEntityExecutionResult)TestSuiteExecutionResult.fromTestSuiteExecutionAttempt((TestSuiteExecutionAttempt)firstAttempt, (String)parentIdForUI));
                }
                if (testSuiteExecutionAttempt.getAttemptIndex() > 0 && (entityExecution = testSuiteExecutionAttempt.getParentEntityExecution()) instanceof TestSuiteExecution) {
                    parentTestSuiteExecution = (TestSuiteExecution)entityExecution;
                    changedItems.add((TestEntityExecutionResult)TestSuiteExecutionResult.fromTestSuiteExecution((TestSuiteExecution)parentTestSuiteExecution, (String)parentTestSuiteExecution.getParentIdString(), null));
                }
                changedItems.add((TestEntityExecutionResult)TestSuiteExecutionResult.fromTestSuiteExecutionAttempt((TestSuiteExecutionAttempt)testSuiteExecutionAttempt, (String)parentIdForUI));
                continue;
            }
            if (newLogRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testCaseLogRecord);
                if (!testCaseLogRecord.isTopLevelTestCase()) {
                    changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromLogRecord((TestCaseLogRecord)testCaseLogRecord, (String)this.findNiceParentId((LogRecord)testCaseLogRecord)));
                    continue;
                }
                TestCaseExecutionAttempt testCaseExecutionAttempt = this.findOrCreateTestCaseExecutionAttemptFromLogRecord(testCaseLogRecord);
                if (testCaseExecutionAttempt == null) {
                    this.logger.warn("Cannot find test case execution with log record: " + String.valueOf(testCaseLogRecord));
                    continue;
                }
                this.syncTestCaseToOriginalPlan(testCaseLogRecord, testCaseExecutionAttempt);
                TestCaseBinding testCaseBinding = this.findTestCaseBindingFromLogRecord(testCaseLogRecord);
                EntityExecution parentForUI = this.findParentForUI(testCaseExecutionAttempt);
                if (parentForUI instanceof TestCaseBindingExecution) {
                    TestCaseBindingExecution parentTestCaseBindingExecution = (TestCaseBindingExecution)parentForUI;
                    changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseBindingExecution((TestCaseBindingExecution)parentTestCaseBindingExecution, (String)parentTestCaseBindingExecution.getParentIdString()));
                } else if (parentForUI instanceof TestCaseExecution) {
                    TestCaseExecution parentTestCaseExecution = (TestCaseExecution)parentForUI;
                    EntityExecution entityExecution = parentForUI.getParentEntityExecution();
                    if (entityExecution instanceof TestCaseBindingExecution) {
                        TestCaseBindingExecution grandParentTestCaseBinding = (TestCaseBindingExecution)entityExecution;
                        changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseBindingExecution((TestCaseBindingExecution)grandParentTestCaseBinding, (String)grandParentTestCaseBinding.getParentIdString()));
                    }
                    if (!this.laterAddedNodeIds.contains(parentTestCaseExecution.getIdString())) {
                        this.laterAddedNodeIds.add(parentTestCaseExecution.getIdString());
                        TestCaseExecutionAttempt firstAttempt = parentTestCaseExecution.getFirstAttempt();
                        changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseExecution((TestCaseExecution)parentTestCaseExecution, (TestCaseBinding)testCaseBinding, null, (String)firstAttempt.getIdString()));
                        changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseExecutionAttempt((TestCaseExecutionAttempt)firstAttempt, (TestCaseBinding)this.findTestCaseBindingFromAttempt(firstAttempt), (String)parentForUI.getIdString()));
                    } else {
                        changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseExecution((TestCaseExecution)parentTestCaseExecution, (TestCaseBinding)testCaseBinding, (String)parentTestCaseExecution.getParentIdString(), null));
                    }
                }
                changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseExecutionAttempt((TestCaseExecutionAttempt)testCaseExecutionAttempt, (TestCaseBinding)testCaseBinding, (String)parentForUI.getIdString()));
                continue;
            }
            if (newLogRecord instanceof TestStepLogRecord) {
                TestStepLogRecord testStepLogRecord = (TestStepLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testStepLogRecord);
                if (testStepLogRecord.getParent() instanceof TestCaseLogRecord || testStepLogRecord.getParent() instanceof TestStepLogRecord) {
                    changedItems.add((TestEntityExecutionResult)TestStepExecutionResult.fromLogRecord((TestStepLogRecord)testStepLogRecord, (String)this.findNiceParentId((LogRecord)testStepLogRecord)));
                    continue;
                }
                if (!(testStepLogRecord.getParent() instanceof TestSuiteLogRecord)) continue;
                if (!testStepLogRecord.isTestListenerStep()) {
                    this.logger.warn("Unsupported TestStepLogRecord under TestSuiteLogRecord that is not a listener step");
                    continue;
                }
                TestListenerExecution testListenerExecution = this.linkTestListenerStepToParentTestSuite(testStepLogRecord, testSuiteExecutionAttempt);
                this.testResultCalculator.update((LogRecord)testStepLogRecord);
                changedItems.add((TestEntityExecutionResult)TestStepExecutionResult.fromListenerTestStep((TestListenerExecution)testListenerExecution, (String)testSuiteExecutionAttempt.getIdString()));
                continue;
            }
            if (newLogRecord instanceof MessageLogRecord) {
                MessageLogRecord messageLogRecord = (MessageLogRecord)newLogRecord;
                changedItems.addAll(this.recalculateTestResultOfAncestors(messageLogRecord));
                continue;
            }
            this.logger.warn("Unsupported LogRecord type: " + newLogRecord.getClass().getName());
        }
        return changedItems;
    }

    private List<TestEntityExecutionResult> syncLogRecordsToOriginalTestCaseBindingExecution(List<LogRecord> newLogRecords, TestCaseBindingExecution testCaseBindingExecution) {
        ArrayList<TestEntityExecutionResult> changedItems = new ArrayList<TestEntityExecutionResult>();
        for (LogRecord newLogRecord : newLogRecords) {
            if (newLogRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testCaseLogRecord);
                if (!testCaseLogRecord.isTopLevelTestCase()) {
                    changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromLogRecord((TestCaseLogRecord)testCaseLogRecord, (String)this.findNiceParentId((LogRecord)testCaseLogRecord)));
                    continue;
                }
                TestCaseExecutionAttempt testCaseExecutionAttempt = this.findOrCreateTestCaseExecutionAttemptFromLogRecord(testCaseLogRecord);
                if (testCaseExecutionAttempt == null) {
                    this.logger.warn("Cannot find test case execution with log record: " + String.valueOf(testCaseLogRecord));
                    continue;
                }
                this.syncTestCaseToOriginalPlan(testCaseLogRecord, testCaseExecutionAttempt);
                TestCaseBinding testCaseBinding = this.findTestCaseBindingFromLogRecord(testCaseLogRecord);
                EntityExecution parentForUI = this.findParentForUI(testCaseExecutionAttempt);
                if (parentForUI == null) {
                    this.logger.warn("Cannot find parent UI from test case execution attempt: " + String.valueOf(testCaseExecutionAttempt));
                    return null;
                }
                changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseBindingExecution((TestCaseBindingExecution)testCaseBindingExecution, null));
                changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseExecutionAttempt((TestCaseExecutionAttempt)testCaseExecutionAttempt, (TestCaseBinding)testCaseBinding, (String)parentForUI.getIdString()));
                continue;
            }
            if (newLogRecord instanceof TestStepLogRecord) {
                TestStepLogRecord testStepLogRecord = (TestStepLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testStepLogRecord);
                changedItems.add((TestEntityExecutionResult)TestStepExecutionResult.fromLogRecord((TestStepLogRecord)testStepLogRecord, (String)this.findNiceParentId((LogRecord)testStepLogRecord)));
                continue;
            }
            if (newLogRecord instanceof MessageLogRecord) {
                MessageLogRecord messageLogRecord = (MessageLogRecord)newLogRecord;
                changedItems.addAll(this.recalculateTestResultOfAncestors(messageLogRecord));
                continue;
            }
            this.logger.warn("Unsupported LogRecord type: " + newLogRecord.getClass().getName());
        }
        return changedItems;
    }

    private List<TestEntityExecutionResult> syncLogRecordsToOriginalTestCaseExecution(List<LogRecord> newLogRecords, TestCaseExecution testCaseExecution) {
        ArrayList<TestEntityExecutionResult> changedItems = new ArrayList<TestEntityExecutionResult>();
        TestCaseExecutionAttempt testCaseExecutionAttempt = testCaseExecution.getLastAttempt();
        if (testCaseExecutionAttempt == null) {
            this.logger.warn("Cannot find last attempt for test case execution with id: " + String.valueOf(testCaseExecution.getId()));
            return changedItems;
        }
        for (LogRecord newLogRecord : newLogRecords) {
            if (newLogRecord instanceof TestCaseLogRecord) {
                TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testCaseLogRecord);
                if (!testCaseLogRecord.isTopLevelTestCase()) {
                    changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromLogRecord((TestCaseLogRecord)testCaseLogRecord, (String)this.findNiceParentId((LogRecord)testCaseLogRecord)));
                    continue;
                }
                this.syncTestCaseToOriginalPlan(testCaseLogRecord, testCaseExecutionAttempt);
                TestCaseBinding testCaseBinding = null;
                changedItems.add((TestEntityExecutionResult)TestCaseExecutionResult.fromTestCaseExecutionAttempt((TestCaseExecutionAttempt)testCaseExecutionAttempt, testCaseBinding, null));
                continue;
            }
            if (newLogRecord instanceof TestStepLogRecord) {
                TestStepLogRecord testStepLogRecord = (TestStepLogRecord)newLogRecord;
                this.testResultCalculator.update((LogRecord)testStepLogRecord);
                changedItems.add((TestEntityExecutionResult)TestStepExecutionResult.fromLogRecord((TestStepLogRecord)testStepLogRecord, (String)this.findNiceParentId((LogRecord)testStepLogRecord)));
                continue;
            }
            if (newLogRecord instanceof MessageLogRecord) {
                MessageLogRecord messageLogRecord = (MessageLogRecord)newLogRecord;
                changedItems.addAll(this.recalculateTestResultOfAncestors(messageLogRecord));
                continue;
            }
            this.logger.warn("Unsupported LogRecord type: " + newLogRecord.getClass().getName());
        }
        return changedItems;
    }

    private void syncTestSuiteToOriginalPlan(TestSuiteLogRecord testSuiteLogRecord, TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        if (testSuiteLogRecord.getStartTime() > 0L) {
            Date startDate = new Date(testSuiteLogRecord.getStartTime());
            this.ensureJobStatusIsStarted((TestExecutionStep)testSuiteExecutionAttempt, startDate);
        }
        if (testSuiteLogRecord.getEndTime() > 0L) {
            Date endDate = new Date(testSuiteLogRecord.getEndTime());
            this.ensureJobStatusIsCompleted((TestExecutionStep)testSuiteExecutionAttempt, endDate);
        }
        if (!testSuiteExecutionAttempt.getLogRecords().contains(testSuiteLogRecord)) {
            testSuiteExecutionAttempt.addLogRecord((LogRecord)testSuiteLogRecord);
        }
    }

    private void syncTestCaseToOriginalPlan(TestCaseLogRecord testCaseLogRecord, TestCaseExecutionAttempt testCaseExecutionAttempt) {
        if (testCaseLogRecord.getStartTime() > 0L) {
            Date startDate = new Date(testCaseLogRecord.getStartTime());
            this.ensureJobStatusIsStarted((TestExecutionStep)testCaseExecutionAttempt, startDate);
        }
        if (testCaseLogRecord.getEndTime() > 0L) {
            Date endDate = new Date(testCaseLogRecord.getEndTime());
            this.ensureJobStatusIsCompleted((TestExecutionStep)testCaseExecutionAttempt, endDate);
        }
        if (!testCaseExecutionAttempt.getLogRecords().contains(testCaseLogRecord)) {
            testCaseExecutionAttempt.addLogRecord((LogRecord)testCaseLogRecord);
        }
        if (testCaseLogRecord.getTestStatus().getStatusValue().isFinal()) {
            Optional<String> failedReason;
            ExecutionTestResult newTestResult = ExecutionTestResult.fromTestStatusValue((TestStatus.TestStatusValue)testCaseLogRecord.getTestStatusValue());
            if (newTestResult == null) {
                this.logger.warn("Cannot map test status value to execution test result: " + String.valueOf(testCaseLogRecord.getTestStatus().getStatusValue()));
                return;
            }
            Optional oldTestResult = testCaseExecutionAttempt.getTestResult();
            testCaseExecutionAttempt.updateTestResultAndPropagateUp(newTestResult);
            if (newTestResult.isErrorOrFailed() && (failedReason = LogRecordTestResultCalculator.buildFailedReason((LogRecord)testCaseLogRecord)).isPresent()) {
                testCaseExecutionAttempt.updateTestFailedReasonAndPropagateUp(failedReason.get());
            }
            if (this.entityExecution instanceof TestSuiteExecutionAttempt && oldTestResult.isEmpty()) {
                this.eventBroker.post("EXECUTION_V2/ON_TEST_CASE_EXECUTION_RESULT_ENDED", (Object)ExecutionResultUpdatedEvent.testCaseUpdated((TestCaseExecutionAttempt)testCaseExecutionAttempt));
            }
        }
    }

    private TestListenerExecution linkTestListenerStepToParentTestSuite(TestStepLogRecord testStepLogRecord, TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        UUID listenerStepId = UUID.fromString(testStepLogRecord.getId());
        TestListenerExecution testListenerExecution = new TestListenerExecution(listenerStepId);
        testListenerExecution.setName(testStepLogRecord.getName());
        if (testStepLogRecord.getStartTime() > 0L) {
            Date startDate = new Date(testStepLogRecord.getStartTime());
            this.ensureJobStatusIsStarted((TestExecutionStep)testListenerExecution, startDate);
        }
        if (testStepLogRecord.getEndTime() > 0L) {
            Date endDate = new Date(testStepLogRecord.getEndTime());
            this.ensureJobStatusIsCompleted((TestExecutionStep)testListenerExecution, endDate);
        }
        testListenerExecution.addLogRecord((LogRecord)testStepLogRecord);
        testSuiteExecutionAttempt.addBeforeListenerStep(testListenerExecution);
        return testListenerExecution;
    }

    private void ensureJobStatusIsStarted(TestExecutionStep testExecutionStep, Date startDate) {
        if (testExecutionStep.getExecutionJobStatus() == ExecutionJobStatus.PENDING) {
            EntityExecution entityExecution;
            testExecutionStep.updateJobStatus(ExecutionJobStatus.RUNNING, Optional.of(startDate), Optional.empty());
            if (testExecutionStep instanceof EntityExecution && (entityExecution = (EntityExecution)testExecutionStep).getParentEntityExecution() != null) {
                this.ensureJobStatusIsStarted((TestExecutionStep)entityExecution.getParentEntityExecution(), startDate);
            }
        }
    }

    private void ensureJobStatusIsCompleted(TestExecutionStep testExecutionStep, Date endDate) {
        if (testExecutionStep.getExecutionJobStatus() == ExecutionJobStatus.RUNNING) {
            testExecutionStep.updateJobStatus(ExecutionJobStatus.COMPLETED, Optional.of(endDate), Optional.empty());
        }
    }

    private List<TestEntityExecutionResult> recalculateTestResultOfAncestors(MessageLogRecord messageLogRecord) {
        ArrayList<TestEntityExecutionResult> changedItems = new ArrayList<TestEntityExecutionResult>();
        LogRecord currentLogRecord = messageLogRecord.getParent();
        boolean isFirstParent = true;
        while (currentLogRecord != null) {
            TestEntityExecutionResult changedItem;
            TestStatus.TestStatusValue oldStatus = currentLogRecord.getTestStatusValue();
            TestStatus.TestStatusValue newStatus = this.testResultCalculator.update(currentLogRecord).getStatusValue();
            if (newStatus == oldStatus) {
                if (!isFirstParent || (changedItem = this.buildResultFromChangedLogRecord(currentLogRecord)) == null) break;
                changedItems.add(changedItem);
                break;
            }
            this.updateTestStatus(currentLogRecord, newStatus);
            changedItem = this.buildResultFromChangedLogRecord(currentLogRecord);
            if (changedItem != null) {
                changedItems.add(changedItem);
            }
            isFirstParent = false;
            currentLogRecord = currentLogRecord.getParent();
        }
        return changedItems;
    }

    private void updateTestStatus(LogRecord logRecord, TestStatus.TestStatusValue newStatus) {
        if (logRecord.getTestStatus() != null) {
            logRecord.getTestStatus().setStatusValue(newStatus);
            return;
        }
        logRecord.setTestStatus(new TestStatus(newStatus));
    }

    private TestEntityExecutionResult buildResultFromChangedLogRecord(LogRecord logRecord) {
        EntityExecution entityExecution;
        if (logRecord instanceof TestStepLogRecord) {
            TestStepLogRecord testStepLogRecord = (TestStepLogRecord)logRecord;
            return TestStepExecutionResult.fromLogRecord((TestStepLogRecord)testStepLogRecord, (String)this.findNiceParentId((LogRecord)testStepLogRecord));
        }
        if (logRecord instanceof TestCaseLogRecord) {
            TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
            if (!testCaseLogRecord.isTopLevelTestCase()) {
                return TestCaseExecutionResult.fromLogRecord((TestCaseLogRecord)testCaseLogRecord, (String)this.findNiceParentId((LogRecord)testCaseLogRecord));
            }
            TestCaseExecutionAttempt testCaseExecutionAttempt = this.findOrCreateTestCaseExecutionAttemptFromLogRecord(testCaseLogRecord);
            if (testCaseExecutionAttempt == null) {
                this.logger.warn("Cannot find test case execution with log record: " + String.valueOf(testCaseLogRecord));
                return null;
            }
            TestCaseBinding testCaseBinding = this.findTestCaseBindingFromLogRecord(testCaseLogRecord);
            EntityExecution parentForUI = this.findParentForUI(testCaseExecutionAttempt);
            String parentId = parentForUI == null ? null : parentForUI.getIdString();
            return TestCaseExecutionResult.fromTestCaseExecutionAttempt((TestCaseExecutionAttempt)testCaseExecutionAttempt, (TestCaseBinding)testCaseBinding, (String)parentId);
        }
        if (logRecord instanceof TestSuiteLogRecord && (entityExecution = this.entityExecution) instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            EntityExecution parentForUI = this.findParentForUI(testSuiteExecutionAttempt);
            String parentId = parentForUI == null ? null : parentForUI.getIdString();
            return TestSuiteExecutionResult.fromTestSuiteExecutionAttempt((TestSuiteExecutionAttempt)testSuiteExecutionAttempt, (String)parentId);
        }
        return null;
    }

    private TestCaseExecutionAttempt findOrCreateTestCaseExecutionAttemptFromLogRecord(TestCaseLogRecord testCaseLogRecord) {
        UUID testCaseExecutionId = testCaseLogRecord.getTestCaseExecutionId();
        int attemptIndex = testCaseLogRecord.getAttemptIndex();
        if (testCaseExecutionId == null && this.entityExecution instanceof TestCaseExecution) {
            testCaseExecutionId = this.entityExecution.getId();
        }
        if (testCaseExecutionId == null) {
            return null;
        }
        BaseTestCaseExecution baseTestCaseExecution = (BaseTestCaseExecution)this.testCaseExecutionMap.get(testCaseExecutionId);
        if (baseTestCaseExecution == null) {
            return null;
        }
        if (baseTestCaseExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)baseTestCaseExecution;
            if (attemptIndex > testCaseExecution.getAttempts().size()) {
                this.logger.warn("Unexpected attempt index " + attemptIndex + " for test case execution id: " + String.valueOf(testCaseExecutionId));
                return null;
            }
            if (attemptIndex == testCaseExecution.getAttempts().size()) {
                testCaseExecution.addNewAttempt();
            }
            return testCaseExecution.getLastAttempt();
        }
        this.logger.warn("Unsupported BaseTestCaseExecution type: " + baseTestCaseExecution.getClass().getName());
        return null;
    }

    private TestCaseBinding findTestCaseBindingFromLogRecord(TestCaseLogRecord testCaseLogRecord) {
        UUID testCaseExecutionId = testCaseLogRecord.getTestCaseExecutionId();
        if (testCaseExecutionId == null) {
            return null;
        }
        return this.testCaseBindingMap.get(testCaseExecutionId);
    }

    private TestCaseBinding findTestCaseBindingFromAttempt(TestCaseExecutionAttempt attempt) {
        UUID testCaseExecutionId = attempt.getId();
        if (testCaseExecutionId == null) {
            return null;
        }
        return this.testCaseBindingMap.get(testCaseExecutionId);
    }

    private String findNiceParentId(LogRecord logRecord) {
        if (logRecord.getParent() == null) {
            return null;
        }
        LogRecord parentLogRecord = logRecord.getParent();
        if (parentLogRecord instanceof TestStepLogRecord) {
            return parentLogRecord.getId();
        }
        if (parentLogRecord instanceof TestCaseLogRecord) {
            TestCaseLogRecord parenTestCaseLogRecord = (TestCaseLogRecord)parentLogRecord;
            if (!parenTestCaseLogRecord.isTopLevelTestCase()) {
                return parenTestCaseLogRecord.getId();
            }
            TestCaseExecutionAttempt testCaseExecutionAttempt = this.findOrCreateTestCaseExecutionAttemptFromLogRecord(parenTestCaseLogRecord);
            if (testCaseExecutionAttempt == null) {
                this.logger.warn("Cannot find test case execution with log record: " + String.valueOf(parenTestCaseLogRecord));
                return null;
            }
            return testCaseExecutionAttempt.getIdString();
        }
        if (parentLogRecord instanceof TestSuiteLogRecord) {
            TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)parentLogRecord;
            return testSuiteLogRecord.getId();
        }
        this.logger.warn("Unsupported parent log record type: " + parentLogRecord.getClass().getName());
        return null;
    }

    private EntityExecution findParentForUI(TestCaseExecutionAttempt attempt) {
        EntityExecution entityExecution = attempt.getParentEntityExecution();
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            if (testCaseExecution.getAttempts().size() == 1) {
                return testCaseExecution.getParentEntityExecution();
            }
            return testCaseExecution;
        }
        this.logger.warn("Unsupported parent entity execution type: " + attempt.getParentEntityExecution().getClass().getName());
        return null;
    }

    private EntityExecution findParentForUI(TestSuiteExecutionAttempt attempt) {
        EntityExecution entityExecution = attempt.getParentEntityExecution();
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            if (testSuiteExecution.getAttempts().size() == 1) {
                return testSuiteExecution.getParentEntityExecution();
            }
            return testSuiteExecution;
        }
        this.logger.warn("Unsupported parent entity execution type: " + attempt.getParentEntityExecution().getClass().getName());
        return null;
    }

    private String findParentIDForUI(TestSuiteExecutionAttempt attempt) {
        EntityExecution parentForUI = this.findParentForUI(attempt);
        return parentForUI == null ? null : parentForUI.getIdString();
    }
}

