/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.logrecord;

import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestStepLogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRecordTestResultCalculator {
    private final Logger logger = LoggerFactory.getLogger(LogRecordTestResultCalculator.class);
    private static final TestStatus.TestStatusValue[] RESULT_PRIORITY = new TestStatus.TestStatusValue[]{TestStatus.TestStatusValue.ERROR, TestStatus.TestStatusValue.FAILED, TestStatus.TestStatusValue.PASSED, TestStatus.TestStatusValue.SKIPPED};

    public TestStatus update(LogRecord logRecord) {
        if (logRecord instanceof TestSuiteLogRecord) {
            TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)logRecord;
            return this.updateTestSuite(testSuiteLogRecord);
        }
        if (logRecord instanceof TestCaseLogRecord) {
            TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
            return this.updateTestCase(testCaseLogRecord);
        }
        if (logRecord instanceof TestStepLogRecord) {
            TestStepLogRecord testStepLogRecord = (TestStepLogRecord)logRecord;
            return this.updateTestStep(testStepLogRecord);
        }
        this.logger.warn("Unknown LogRecord type: " + logRecord.getClass().getName());
        return this.updateDefault(logRecord);
    }

    public static Optional<String> buildFailedReason(LogRecord logRecord) {
        StringBuilder failedReasonBuilder = new StringBuilder();
        if (logRecord == null) {
            return Optional.empty();
        }
        for (LogRecord childLogRecord : logRecord.getChildRecords()) {
            Optional<String> childFailedReason;
            TestStatus.TestStatusValue statusValue = childLogRecord.getTestStatusValue();
            if (childLogRecord instanceof MessageLogRecord && statusValue != null && statusValue.isError()) {
                failedReasonBuilder.append(childLogRecord.getMessage());
                failedReasonBuilder.append(System.lineSeparator());
            }
            if (!(childFailedReason = LogRecordTestResultCalculator.buildFailedReason(childLogRecord)).isPresent()) continue;
            failedReasonBuilder.append(childFailedReason.get());
            failedReasonBuilder.append(System.lineSeparator());
        }
        String fullReason = failedReasonBuilder.toString();
        if (fullReason.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(fullReason.trim());
    }

    private TestStatus updateTestSuite(TestSuiteLogRecord logRecord) {
        TestStatus testStatus = logRecord.getTestStatus();
        if (logRecord.getEndTime() <= 0L) {
            return testStatus;
        }
        Set childRecordStatuses = logRecord.getChildRecords().stream().filter(childRecord -> childRecord instanceof TestCaseLogRecord).map(childRecord -> childRecord.getTestStatus().getStatusValue()).collect(Collectors.toSet());
        TestStatus.TestStatusValue[] testStatusValueArray = RESULT_PRIORITY;
        int n = RESULT_PRIORITY.length;
        int n2 = 0;
        while (n2 < n) {
            TestStatus.TestStatusValue status = testStatusValueArray[n2];
            if (childRecordStatuses.contains(status)) {
                testStatus.setStatusValue(status);
                return testStatus;
            }
            ++n2;
        }
        testStatus.setStatusValue(TestStatus.TestStatusValue.INCOMPLETE);
        return testStatus;
    }

    private TestStatus updateTestCase(TestCaseLogRecord logRecord) {
        TestStatus status = this.updateDefault((LogRecord)logRecord);
        return status;
    }

    private TestStatus updateTestStep(TestStepLogRecord testStepLogRecord) {
        TestStatus status = this.updateDefault((LogRecord)testStepLogRecord);
        List childRecords = testStepLogRecord.getChildRecords();
        if (childRecords == null || childRecords.isEmpty()) {
            return status;
        }
        if (childRecords.size() == 1 && ((LogRecord)childRecords.get(0)).getTestStatus().getStatusValue() == TestStatus.TestStatusValue.NOT_RUN) {
            status.setStatusValue(TestStatus.TestStatusValue.NOT_RUN);
        }
        if (testStepLogRecord.isIgnoredIfFailed()) {
            status.setStatusValue(TestStatus.TestStatusValue.PASSED);
        }
        return status;
    }

    private TestStatus updateDefault(LogRecord logRecord) {
        List<LogRecord> warningRecords;
        TestStatus testStatus = logRecord.getTestStatus();
        if (logRecord.getEndTime() <= 0L) {
            return testStatus;
        }
        List childRecords = logRecord.getChildRecords();
        List<LogRecord> messageRecordsWithFinalStatus = childRecords.stream().filter(childRecord -> childRecord instanceof MessageLogRecord).filter(childRecord -> childRecord.getTestStatus().getStatusValue().isFinal()).toList();
        Optional<Object> messageRecordWithFinalStatus = Optional.empty();
        if (messageRecordsWithFinalStatus.size() > 0) {
            messageRecordWithFinalStatus = Optional.of(messageRecordsWithFinalStatus.get(messageRecordsWithFinalStatus.size() - 1));
        }
        if (messageRecordWithFinalStatus.isPresent()) {
            testStatus.setStatusValue(((LogRecord)messageRecordWithFinalStatus.get()).getTestStatus().getStatusValue());
            logRecord.setMessage(((LogRecord)messageRecordWithFinalStatus.get()).getMessage());
            return testStatus;
        }
        Optional<LogRecord> recordWithErrorStatus = childRecords.stream().filter(childRecord -> {
            TestCaseLogRecord testCaseLogRecord;
            return !(childRecord instanceof TestCaseLogRecord) || !(testCaseLogRecord = (TestCaseLogRecord)childRecord).isOptional();
        }).filter(childRecord -> childRecord.getTestStatus().getStatusValue().isError()).findFirst();
        if (recordWithErrorStatus.isPresent()) {
            testStatus.setStatusValue(recordWithErrorStatus.get().getTestStatus().getStatusValue());
            logRecord.setMessage(recordWithErrorStatus.get().getMessage());
            return testStatus;
        }
        if (!childRecords.isEmpty()) {
            logRecord.setMessage(((LogRecord)childRecords.get(childRecords.size() - 1)).getMessage());
        }
        if (!(warningRecords = childRecords.stream().filter(childRecord -> childRecord instanceof MessageLogRecord).filter(childRecord -> childRecord.getTestStatus().getStatusValue() == TestStatus.TestStatusValue.WARNING).toList()).isEmpty()) {
            testStatus.setStatusValue(TestStatus.TestStatusValue.WARNING);
        } else {
            testStatus.setStatusValue(TestStatus.TestStatusValue.PASSED);
        }
        return testStatus;
    }
}

