/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.util.MailUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailConfigBuilder {
    private static final Logger logger = LoggerFactory.getLogger(EmailConfigBuilder.class);

    public EmailConfig build(TestExecutionRequest request) throws ExecutionException {
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        KREOverridingConfiguration kreOverridingConfiguration = request.getKreOverridingConfiguration();
        EmailConfig emailConfig = null;
        emailConfig = kreOverridingConfiguration != null && kreOverridingConfiguration.getEmailConfig() != null ? kreOverridingConfiguration.getEmailConfig() : MailUtil.getDefaultEmailConfig((ProjectEntity)currentProject);
        IExecutableEntity iExecutableEntity = request.getEntity();
        if (iExecutableEntity instanceof TestSuiteEntity) {
            TestSuiteEntity testSuite = (TestSuiteEntity)iExecutableEntity;
            ExecutionProfileEntity executionProfile = request.getExecutionProfile();
            HashMap variables = new HashMap();
            if (kreOverridingConfiguration != null && kreOverridingConfiguration.getGlobalVariablesConfiguration() != null) {
                variables.putAll(kreOverridingConfiguration.getGlobalVariablesConfiguration().getGlobalVariables());
            }
            variables.putAll(EmailVariableBinding.getVariablesForTestSuiteEmailSettings((TestSuiteEntity)testSuite));
            MailUtil.overrideEmailSettings((EmailConfig)emailConfig, (ExecutionProfileEntity)executionProfile, variables);
            emailConfig.addRecipients(testSuite.getMailRecipient());
            return emailConfig;
        }
        IExecutableEntity iExecutableEntity2 = request.getEntity();
        if (iExecutableEntity2 instanceof TestSuiteCollectionEntity) {
            TestSuiteCollectionEntity tscEntity = (TestSuiteCollectionEntity)iExecutableEntity2;
            ExecutionProfileEntity executionProfile = null;
            if (kreOverridingConfiguration != null && kreOverridingConfiguration.getExecutionProfile() != null) {
                executionProfile = kreOverridingConfiguration.getExecutionProfile();
            } else {
                try {
                    executionProfile = GlobalVariableController.getInstance().getDefaultExecutionProfile(currentProject);
                }
                catch (ControllerException e) {
                    throw new ExecutionException("Failed to get default execution profile", (Throwable)e);
                }
            }
            HashMap variables = new HashMap();
            if (kreOverridingConfiguration != null && kreOverridingConfiguration.getGlobalVariablesConfiguration() != null) {
                variables.putAll(kreOverridingConfiguration.getGlobalVariablesConfiguration().getGlobalVariables());
            }
            variables.putAll(EmailVariableBinding.getVariablesForTestSuiteCollectionEmailSettings((TestSuiteCollectionEntity)tscEntity));
            MailUtil.overrideEmailSettings((EmailConfig)emailConfig, (ExecutionProfileEntity)executionProfile, variables);
            return emailConfig;
        }
        logger.warn("EmailConfigBuilder: Unsupported entity type for building email config: " + request.getEntity().getClass().getName());
        return null;
    }
}

