/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.dto.request.GlobalVariablesConfiguration;
import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.factory.IDriverPropertiesBuilderFactory;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.preferences.IStudioAssistPreferences;
import com.kms.katalon.common.About;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.variable.ExecutionVariableManager;
import com.kms.katalon.network.core.model.config.AllNetworkPreferences;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.util.CryptoUtil;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEnvironmentVariablesBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEnvironmentVariablesBuilder.class);
    private IDriverPropertiesBuilderFactory driverPropertiesBuilderFactory;

    public ExecutionEnvironmentVariablesBuilder(IDriverPropertiesBuilderFactory driverPropertiesBuilderFactory) {
        this.driverPropertiesBuilderFactory = driverPropertiesBuilderFactory;
    }

    public Map<String, String> build(TestExecutionRequest request) throws ExecutionException {
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        Map<String, String> driverEnvVars = this.buildDriverEnvironmentVariables(request);
        environmentVariables.putAll(driverEnvVars);
        Map<String, Object> protectedGlobalVariables = this.getProtectedGlobalVariablesFromProfiles(request.getExecutionProfile());
        try {
            String protectedGlobalVariablesString = this.convertMapToString(protectedGlobalVariables, true);
            if (StringUtils.isNotBlank((CharSequence)protectedGlobalVariablesString)) {
                environmentVariables.put("ProtectedGlobalVariables", protectedGlobalVariablesString);
            }
        }
        catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
            throw new ExecutionException("Failed to build protected global variables", e);
        }
        Map<String, String> aiSelfHealingEnvVars = this.buildAISelfHealingEnvironmentVariables();
        environmentVariables.putAll(aiSelfHealingEnvVars);
        KREOverridingConfiguration kreOverridingConfigutation = request.getKreOverridingConfiguration();
        if (kreOverridingConfigutation == null || kreOverridingConfigutation.getGlobalVariablesConfiguration() == null) {
            return environmentVariables;
        }
        if (kreOverridingConfigutation.getGlobalVariablesConfiguration() == null) {
            return environmentVariables;
        }
        GlobalVariablesConfiguration overridingConfig = kreOverridingConfigutation.getGlobalVariablesConfiguration();
        if (overridingConfig == null) {
            return environmentVariables;
        }
        try {
            String overridingGlobalVariablesString = this.convertMapToString(overridingConfig.getGlobalVariables(), true);
            if (StringUtils.isNotBlank((CharSequence)overridingGlobalVariablesString)) {
                environmentVariables.put("OverridingGlobalVariables", overridingGlobalVariablesString);
            }
        }
        catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
            throw new ExecutionException("Failed to build overriding global variables", e);
        }
        try {
            String overridingProtectedGlobalVariablesString = this.convertMapToString(overridingConfig.getProtectedGlobalVariables(), true);
            if (StringUtils.isNotBlank((CharSequence)overridingProtectedGlobalVariablesString)) {
                environmentVariables.put("OverridingProtectedGlobalVariables", overridingProtectedGlobalVariablesString);
            }
        }
        catch (JsonProcessingException | UnsupportedEncodingException | GeneralSecurityException e) {
            throw new ExecutionException("Failed to build overriding protected global variables", e);
        }
        return environmentVariables;
    }

    private Map<String, Object> getProtectedGlobalVariablesFromProfiles(ExecutionProfileEntity selectedProfileEntity) {
        List globalVariableEntities;
        HashMap<String, Object> protectedGlobalVariables = new HashMap<String, Object>();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        ExecutionProfileEntity defaultProfileEntity = null;
        try {
            defaultProfileEntity = GlobalVariableController.getInstance().getDefaultExecutionProfile(currentProject);
            if (defaultProfileEntity != null && !(globalVariableEntities = defaultProfileEntity.getGlobalVariableEntities()).isEmpty()) {
                protectedGlobalVariables.putAll(globalVariableEntities.stream().filter(entry -> entry.isProtected()).filter(entry -> entry.getName() != null && entry.getValue() != null).collect(Collectors.toMap(GlobalVariableEntity::getName, GlobalVariableEntity::getValue)));
            }
        }
        catch (ControllerException controllerException) {}
        if (selectedProfileEntity != null && !selectedProfileEntity.isDefaultProfile() && !(globalVariableEntities = selectedProfileEntity.getGlobalVariableEntities()).isEmpty()) {
            protectedGlobalVariables.putAll(globalVariableEntities.stream().filter(entry -> entry.isProtected()).filter(entry -> entry.getName() != null && entry.getValue() != null).collect(Collectors.toMap(GlobalVariableEntity::getName, GlobalVariableEntity::getValue)));
        }
        return protectedGlobalVariables;
    }

    private String convertMapToString(Map<String, Object> map, boolean encrypted) throws JsonProcessingException, UnsupportedEncodingException, GeneralSecurityException {
        String mapString = new ObjectMapper().writeValueAsString(map);
        if (encrypted) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)mapString);
            mapString = CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return mapString;
    }

    private Map<String, String> buildDriverEnvironmentVariables(TestExecutionRequest request) throws ExecutionException {
        ICapabilitySetting capabilitySetting = request.getCapability();
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        if (capabilitySetting == null) {
            return environmentVariables;
        }
        for (DriverType driverType : capabilitySetting.getSupportedDriverTypes()) {
            IDriverPropertiesBuilder propsBuilder = this.driverPropertiesBuilderFactory.getBuilder(driverType, request.getDriverConfiguration());
            propsBuilder.buildEnvironmentVariables(request).forEach((key, value) -> environmentVariables.put((String)key, (String)value));
        }
        return environmentVariables;
    }

    private Map<String, String> buildAISelfHealingEnvironmentVariables() throws ExecutionException {
        ExecutionVariableManager executionVariableManager = new ExecutionVariableManager();
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        try {
            IStudioAssistPreferences studioAssistPrefs = this.getStudioAssistPrefsInstance();
            if (studioAssistPrefs == null) {
                logger.warn("Studio Assist Preferences service is not available.");
                return environmentVariables;
            }
            StudioAssistConfig aiServiceConfig = studioAssistPrefs.getConfig();
            environmentVariables.put("AIServiceConfig", executionVariableManager.encodeVariable((Object)aiServiceConfig));
            IDiscoveryService discoveryServiceInstance = this.getDiscoveryServiceInstance();
            String platformServerUrl = discoveryServiceInstance.getServerUrl(ServerType.PLATFORM);
            if (!StringUtils.isBlank((CharSequence)platformServerUrl)) {
                environmentVariables.put("serverInfo", executionVariableManager.encodeVariable(Map.of(ServerType.PLATFORM, platformServerUrl)));
            }
            environmentVariables.put("katalonVersion", executionVariableManager.encodeVariable((Object)About.releaseVersion()));
            ISessionManager sessionManager = this.getSessionManager();
            environmentVariables.put("account", executionVariableManager.encodeVariable((Object)sessionManager.getAccount()));
            environmentVariables.put("organization", executionVariableManager.encodeVariable((Object)sessionManager.getOrganization()));
            environmentVariables.put("user", executionVariableManager.encodeVariable((Object)sessionManager.getUser()));
            environmentVariables.put("katOneToken", executionVariableManager.encodeVariable((Object)sessionManager.getKatOneToken()));
        }
        catch (StudioAssistLoadingConfigException e) {
            throw new ExecutionException("Failed to load AI Self-healing configuration", (Throwable)e);
        }
        try {
            INetworkPreferences networkPrefs = this.getNetworkPrefsInstance();
            AllNetworkPreferences allNetworkPrefs = networkPrefs.getNetworkPrefs();
            environmentVariables.put("NetworkPreferences", executionVariableManager.encodeVariable((Object)allNetworkPrefs));
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to load network preferences", (Throwable)e);
        }
        return environmentVariables;
    }

    private ISessionManager getSessionManager() {
        return (ISessionManager)this.getServiceContext().get(ISessionManager.class);
    }

    private IDiscoveryService getDiscoveryServiceInstance() {
        return (IDiscoveryService)this.getServiceContext().get(IDiscoveryService.class);
    }

    private IStudioAssistPreferences getStudioAssistPrefsInstance() {
        return (IStudioAssistPreferences)this.getServiceContext().get(IStudioAssistPreferences.class);
    }

    private INetworkPreferences getNetworkPrefsInstance() {
        return (INetworkPreferences)this.getServiceContext().get(INetworkPreferences.class);
    }

    private IEclipseContext getServiceContext() {
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(ExecutionEnvironmentVariablesBuilder.class).getBundleContext());
        if (context == null) {
            logger.warn("Eclipse context is not available.");
        }
        return context;
    }
}

