/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.google.gson.Gson;
import com.katalon.capability.constant.DriverType;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.constant.ExecutionDriverType;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.ExistingDriverConfiguration;
import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.factory.IDriverPropertiesBuilderFactory;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.ExecutionProperties;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.GeneralProperties;
import com.katalon.execution.model.settings.HostProperties;
import com.katalon.execution.model.settings.PlatformsProperties;
import com.katalon.execution.model.settings.RunConfigurationProperties;
import com.katalon.execution.model.settings.SerializableMap;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.services.planner.ExecutionEnvironmentVariablesBuilder;
import com.katalon.execution.services.planner.ExecutionVMArgsBuilder;
import com.katalon.execution.services.planner.SessionIdGenerator;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.katalon.platform.api.model.TestSuiteCollectionEntity;
import com.kms.katalon.application.utils.VersionInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.configuration.core.interfaces.IHostConfiguration;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.custom.improvement.factory.NewPluginTestListenerFactory;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.impl.LocalHostConfiguration;
import com.kms.katalon.execution.entity.DefaultRerunSetting;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.session.ExecutionSessionSocketServer;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.setting.ExecutionSettingStore;
import com.kms.katalon.execution.setting.MobileSettingStore;
import com.kms.katalon.execution.setting.TestCaseSettingStore;
import com.kms.katalon.execution.setting.WebUiExecutionSettingStore;
import com.kms.katalon.execution.setting.WindowsExecutionSettingStore;
import com.kms.katalon.logging.LogConfigurator;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.UserInfo;
import com.kms.katalon.session.core.services.IFeatureManager;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.util.CryptoUtil;
import com.kms.katalon.util.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionSettingsBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionSettingsBuilder.class);
    private ISessionManager sessionManager;
    private IFeatureManager featureManager;
    private IDriverPropertiesBuilderFactory driverPropertiesBuilderFactory;

    public ExecutionSettingsBuilder(ISessionManager sessionManager, IFeatureManager featureManager, IDriverPropertiesBuilderFactory driverPropertiesBuilderFactory) {
        this.sessionManager = sessionManager;
        this.featureManager = featureManager;
        this.driverPropertiesBuilderFactory = driverPropertiesBuilderFactory;
    }

    public ExecutionSettings build(TestExecutionRequest request) throws ExecutionException {
        if (request.getEntity() instanceof TestSuiteCollectionEntity) {
            logger.warn("ExecutionSettingsBuilder does not support TestSuiteCollectionEntity.");
            return null;
        }
        ExecutionSettings settings = new ExecutionSettings();
        if (request.getParentExecutionSessionId().isPresent()) {
            settings.setExecutionSessionId((String)request.getParentExecutionSessionId().get());
        } else {
            settings.setExecutionSessionId(SessionIdGenerator.generateSessionId());
        }
        ExecutionDefaultSettingStore store = ExecutionDefaultSettingStore.getStore();
        Path executionDirPath = this.generateExecutionFolder(request.getEntity(), settings.getExecutionSessionId());
        settings.setExecutableEntity(request.getEntity());
        settings.setCapabilitySetting(request.getCapability());
        settings.setLaunchMode(request.getLaunchMode());
        settings.setExecutionDirPath(executionDirPath);
        settings.setSettingsFilePath(executionDirPath.resolve(ReportController.EXECUTION_SETTING_FILE_NAME));
        settings.setEventConfiguration(request.getEventConfiguration());
        settings.setOverridingExecutionUUID(request.getKreOverridingConfiguration() != null ? request.getKreOverridingConfiguration().getExecutionUUID() : Optional.empty());
        ExecutionVMArgsBuilder vmArgsBuilder = new ExecutionVMArgsBuilder(this.featureManager);
        settings.setVmArgs(vmArgsBuilder.build(request));
        ExecutionProperties executionProperties = new ExecutionProperties();
        try {
            executionProperties.setGeneral(this.buildGeneralProperties(request, store, executionDirPath));
            executionProperties.setDrivers(this.buildDriverProperties(request));
            executionProperties.setPlatforms(this.buildPlatformsProperties());
            executionProperties.setGlobalSmartWaitEnabled(Boolean.valueOf(store.getDefaultSmartWaitMode()));
            executionProperties.setEnhancedWaitingEnabled(Boolean.valueOf(store.getEnhancedWaitingEnabled()));
            executionProperties.setSmartLocatorEnabled(Boolean.valueOf(this.featureManager.canUse(ProductFeature.SMART_LOCATOR)));
            executionProperties.setSmartLocatorSettingDefaultEnabled(Boolean.valueOf(store.getDefaultSmartLocatorEnabled()));
            boolean doLogTestStep = this.featureManager.canUse(ProductFeature.CONSOLE_LOG_CUSTOMIZATION) ? store.getLogTestSteps() : true;
            executionProperties.setLogTestSteps(Boolean.valueOf(doLogTestStep));
            boolean isHideHostname = this.featureManager.canUse(ProductFeature.HIDE_HOSTNAME) ? store.getHideHostName() : false;
            executionProperties.setHideHostname(Boolean.valueOf(isHideHostname));
            RunConfiguration.TraceMode effectiveTraceMode = this.resolveTraceMode();
            String traceModeString = effectiveTraceMode.toCliValue();
            executionProperties.setTraceMode(traceModeString);
            RunConfiguration.setTraceMode((String)traceModeString);
            executionProperties.setTraceAllEnabled(Boolean.valueOf(RunConfiguration.isTraceAllEnabled()));
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to initialize execution settings: " + e.getMessage(), (Throwable)e);
        }
        LocalHostConfiguration localHostConfig = new LocalHostConfiguration();
        RunConfigurationProperties runConfig = new RunConfigurationProperties();
        if (request.getCapability() != null) {
            DriverType firstDriverType = (DriverType)request.getCapability().getSupportedDriverTypes().iterator().next();
            runConfig.setCapabilityName(this.driverPropertiesBuilderFactory.getBuilder(firstDriverType).buildDetailedDriverName(request));
            settings.setAdditionalInfo(this.driverPropertiesBuilderFactory.getBuilder(firstDriverType).buildAdditionalInfo(request));
        }
        ExecutionEnvironmentVariablesBuilder envVarsBuilder = new ExecutionEnvironmentVariablesBuilder(this.driverPropertiesBuilderFactory);
        settings.setEnvironmentVariables(envVarsBuilder.build(request));
        this.populateUserProjectAppMetadata(runConfig);
        this.populateExecutableEntityMetadata(runConfig, request.getEntity());
        this.populateFeatureEnabledFlags(runConfig);
        KREOverridingConfiguration kreOverridingConfiguration = request.getKreOverridingConfiguration();
        Optional maxFailedTests = kreOverridingConfiguration != null ? kreOverridingConfiguration.getMaxFailedTests() : Optional.empty();
        runConfig.setMaxFailedTests(maxFailedTests.orElse(-1));
        runConfig.setAppiumDirectory(RunConfiguration.getInstance().getAppiumDirectoryDefinedWithArgument());
        runConfig.setRunningMode(request.getRunningMode());
        runConfig.setIsDebugLaunchMode(Boolean.valueOf(request.getLaunchMode().isDebugLauchMode()));
        runConfig.setHost(HostProperties.fromLegacyModel((IHostConfiguration)localHostConfig));
        runConfig.setExecution(executionProperties);
        runConfig.setLogbackConfigFileLocation(this.getLogbackConfigFileLocation());
        runConfig.setPluginTestListeners(NewPluginTestListenerFactory.getInstance().getListeners().stream().toList());
        ExecutionSessionSocketServer sessionServer = ExecutionSessionSocketServer.getInstance();
        runConfig.setSessionServerHost(sessionServer.getServerHost());
        runConfig.setSessionServerPort(Integer.valueOf(sessionServer.getServerPort()));
        if (request.getRecordPlaybackCapturedTestObjectsFilePath() != null) {
            String capturedFilePath = request.getRecordPlaybackCapturedTestObjectsFilePath();
            runConfig.setRecordPlaybackCapturedTestObjectsFilePath(capturedFilePath);
            if (StringUtils.isNotEmpty((CharSequence)capturedFilePath)) {
                runConfig.setRecordPlaybackEnabled(true);
                logger.info("Record playback is enabled with captured test objects file: {}", (Object)capturedFilePath);
            }
        }
        settings.setRunConfiguration(runConfig);
        settings.setTestSuiteRerunSettings(this.buildTestSuiteRerunSettings(request));
        return settings;
    }

    private RunConfiguration.TraceMode resolveTraceMode() {
        RunConfiguration.TraceMode effectiveMode = RunConfiguration.getConfiguredTraceMode();
        try {
            String configuredTraceMode;
            ExecutionSettingStore projectStore;
            if (!RunConfiguration.isTraceModeExplicitlyConfigured() && (projectStore = ExecutionSettingStore.getStore()) != null && (configuredTraceMode = projectStore.getTraceMode()) != null && !configuredTraceMode.isBlank()) {
                effectiveMode = RunConfiguration.TraceMode.fromString((String)configuredTraceMode);
            }
        }
        catch (Exception e) {
            logger.error("Failed to resolve trace.mode from execution settings", (Throwable)e);
        }
        return effectiveMode;
    }

    public ExecutionSettings cloneSettingsForRetry(ExecutionSettings original, int suiteRerunIndex) throws ExecutionException {
        ExecutionSettings settings = ExecutionSettings.copyFrom((ExecutionSettings)original);
        IExecutableEntity executableEntity = original.getExecutableEntity();
        Path newExecutionDirPath = this.generateExecutionFolder(executableEntity, settings.getExecutionSessionId());
        settings.setExecutionDirPath(newExecutionDirPath);
        settings.setSettingsFilePath(newExecutionDirPath.resolve(ReportController.EXECUTION_SETTING_FILE_NAME));
        RunConfigurationProperties newRunConfiguration = (RunConfigurationProperties)SerializationUtils.clone((Serializable)original.getRunConfiguration());
        newRunConfiguration.setHost(HostProperties.fromLegacyModel((IHostConfiguration)new LocalHostConfiguration()));
        newRunConfiguration.setSuiteRerunIndex(Integer.valueOf(suiteRerunIndex));
        this.updateReportFolderForRetry(newRunConfiguration, newExecutionDirPath);
        DriversProperties.DriverPreferencesPropertiesMap driversPrefPropsMap = original.getRunConfiguration().getExecution().getDrivers().getPreferencesProps();
        DriversProperties.DriverPreferencesProperties originalWindowsDriverProps = (DriversProperties.DriverPreferencesProperties)driversPrefPropsMap.get((Object)ExecutionDriverType.DESKTOP);
        if (originalWindowsDriverProps != null) {
            IDriverPropertiesBuilder propsBuilder = this.driverPropertiesBuilderFactory.getBuilder(DriverType.WINDOWS_DRIVER);
            TestExecutionRequest retryRequest = new TestExecutionRequest();
            retryRequest.setCapability(settings.getCapabilitySetting());
            DriversProperties.DriverPreferencesProperties newWindowsDriverProps = propsBuilder.buildPreferencesProperties(retryRequest);
            driversPrefPropsMap.put((Object)ExecutionDriverType.DESKTOP, (Object)newWindowsDriverProps);
        }
        settings.setRunConfiguration(newRunConfiguration);
        return settings;
    }

    private void updateReportFolderForRetry(RunConfigurationProperties runConfiguration, Path executionDirPath) {
        if (runConfiguration == null || executionDirPath == null) {
            return;
        }
        ExecutionProperties execution = runConfiguration.getExecution();
        if (execution == null) {
            return;
        }
        GeneralProperties general = execution.getGeneral();
        if (general == null) {
            return;
        }
        GeneralProperties.Report report = general.getReport();
        if (report == null) {
            return;
        }
        report.setReportFolder(executionDirPath.toString());
    }

    private Path generateExecutionFolder(IExecutableEntity executableEntity, String executionSessionId) throws ExecutionException {
        if (executableEntity instanceof TestCaseEntity) {
            TestCaseEntity testCaseEntity = (TestCaseEntity)executableEntity;
            try {
                String executionFolderStr = ReportController.getInstance().generateTemporaryExecutionFolder((FileEntity)testCaseEntity);
                return Path.of(executionFolderStr, new String[0]);
            }
            catch (DALException | InterruptedException e) {
                throw new ExecutionException("Failed to create execution folder path", e);
            }
        }
        if (executableEntity instanceof SystemFileEntity) {
            SystemFileEntity systemFileEntity = (SystemFileEntity)executableEntity;
            try {
                String executionFolderStr = ReportController.getInstance().generateTemporaryExecutionFolder((FileEntity)systemFileEntity);
                return Path.of(executionFolderStr, new String[0]);
            }
            catch (DALException | InterruptedException e) {
                throw new ExecutionException("Failed to create execution folder path", e);
            }
        }
        if (executableEntity instanceof TestSuiteEntity) {
            TestSuiteEntity testSuiteEntity = (TestSuiteEntity)executableEntity;
            try {
                String executionFolderStr = ReportController.getInstance().generateReportFolder(testSuiteEntity, executionSessionId);
                return Path.of(executionFolderStr, new String[0]);
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to create execution folder path", (Throwable)e);
            }
        }
        throw new ExecutionException("Unsupported executable entity type for execution folder generation: " + executableEntity.getClass().getName());
    }

    private void populateUserProjectAppMetadata(RunConfigurationProperties runConfig) {
        UserInfo userInfo = this.sessionManager.getUserInfo();
        runConfig.setUserFullName(userInfo != null ? userInfo.getFullName() : "");
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        runConfig.setProjectName(project.getName());
        runConfig.setProjectDir(project.getFolderLocation().replace(File.separator, "/"));
        VersionInfo currentKsVersion = VersionUtil.getCurrentVersion();
        runConfig.setKatalonVersionNumber(currentKsVersion.getVersion());
        runConfig.setKatalonBuildNumber(String.valueOf(currentKsVersion.getBuildNumber()));
    }

    private void populateExecutableEntityMetadata(RunConfigurationProperties runConfig, IExecutableEntity executableEntity) {
        if (executableEntity instanceof TestCaseEntity) {
            runConfig.setExecutedEntity("TestCase");
        } else {
            runConfig.setExecutedEntity("TestSuite");
        }
        FileEntity fileEntity = (FileEntity)executableEntity;
        runConfig.setEntityId(fileEntity.getIdForDisplay());
        runConfig.setEntityName(fileEntity.getName());
        runConfig.setEntityDescription(fileEntity.getDescription());
        runConfig.setEntitySource(fileEntity.getLocation());
    }

    private void populateFeatureEnabledFlags(RunConfigurationProperties runConfig) {
        runConfig.setAllowUsingSelfHealing(Boolean.valueOf(this.featureManager.canUse(ProductFeature.SELF_HEALING)));
        runConfig.setAllowUsingTimeCapsule(Boolean.valueOf(true));
        runConfig.setAllowMobileImageBasedTesting(Boolean.valueOf(this.featureManager.canUse(ProductFeature.MOBILE_IMAGE_BASED_TESTING)));
        runConfig.setAllowCustomizeRequestTimeout(Boolean.valueOf(this.featureManager.canUse(ProductFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT)));
        runConfig.setAllowCustomizeRequestResponseSizeLimit(Boolean.valueOf(this.featureManager.canUse(ProductFeature.CUSTOM_WEB_SERVICE_RESPONSE_SIZE_LIMIT)));
    }

    private DriversProperties buildDriverProperties(TestExecutionRequest request) throws ExecutionException {
        ICapabilitySetting capabilitySetting = request.getCapability();
        if (capabilitySetting == null) {
            return new DriversProperties();
        }
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        DriversProperties.DriverPreferencesPropertiesMap driverPreferencesPropertiesMap = new DriversProperties.DriverPreferencesPropertiesMap();
        DriversProperties.DriverSystemPropertiesMap driverSystemPropertiesMap = new DriversProperties.DriverSystemPropertiesMap();
        for (DriverType driverType : capabilitySetting.getSupportedDriverTypes()) {
            ExecutionDriverType executionDriverType = this.resolveExecutionDriverType(driverType, driverConfiguration);
            IDriverPropertiesBuilder propsBuilder = this.driverPropertiesBuilderFactory.getBuilder(driverType, driverConfiguration);
            DriversProperties.DriverPreferencesProperties driverPreferencesProperties = propsBuilder.buildPreferencesProperties(request);
            driverPreferencesPropertiesMap.put((Object)executionDriverType, (Object)driverPreferencesProperties);
            driverSystemPropertiesMap.put((Object)executionDriverType, (Object)propsBuilder.buildSystemProperties(request));
        }
        DriversProperties driverProperties = new DriversProperties();
        driverProperties.setPreferencesProps(driverPreferencesPropertiesMap);
        driverProperties.setSystemProps(driverSystemPropertiesMap);
        return driverProperties;
    }

    private ExecutionDriverType resolveExecutionDriverType(DriverType driverType, DriverConfiguration driverConfiguration) {
        if (driverConfiguration instanceof ExistingDriverConfiguration) {
            return ExecutionDriverType.EXISTING;
        }
        ExecutionDriverType executionDriverType = ExecutionDriverType.WEB;
        switch (driverType) {
            case CHROME_DRIVER: 
            case FIREFOX_DRIVER: 
            case EDGE_CHROMIUM_DRIVER: 
            case SAFARI_DRIVER: 
            case HEADLESS_DRIVER: 
            case FIREFOX_HEADLESS_DRIVER: {
                executionDriverType = ExecutionDriverType.WEB;
                break;
            }
            case ANDROID_DRIVER: 
            case IOS_DRIVER: {
                executionDriverType = ExecutionDriverType.MOBILE;
                break;
            }
            case WINDOWS_DRIVER: {
                executionDriverType = ExecutionDriverType.DESKTOP;
                break;
            }
            case REMOTE_WEB_DRIVER: 
            case KOBITON_WEB_DRIVER: 
            case TESTCLOUD_DRIVER: {
                executionDriverType = ExecutionDriverType.REMOTE;
            }
        }
        return executionDriverType;
    }

    private PlatformsProperties buildPlatformsProperties() throws IOException {
        PlatformsProperties platformsProperties = new PlatformsProperties();
        platformsProperties.setWeb(WebUiExecutionSettingStore.getStore().getExecutionSettings());
        platformsProperties.setMobile(MobileSettingStore.getStore().getExecutionSettings());
        platformsProperties.setWindows(WindowsExecutionSettingStore.getStore().getExecutionSettings());
        return platformsProperties;
    }

    private GeneralProperties buildGeneralProperties(TestExecutionRequest request, ExecutionDefaultSettingStore store, Path executionDirPath) throws ExecutionException {
        GeneralProperties generalProperties = new GeneralProperties();
        ExecutionProfileEntity executionProfile = request.getExecutionProfile();
        if (executionProfile != null) {
            generalProperties.setExecutionProfile(executionProfile.getName());
        }
        generalProperties.setProxy(this.getJsonProxyInformationWithEncryptedPassword());
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        TestCaseSettingStore testCaseSettingStore = new TestCaseSettingStore(project.getFolderLocation());
        generalProperties.setDefaultFailureHandling(testCaseSettingStore.getDefaultFailureHandling());
        generalProperties.setAutoApplyNeighborXpaths(store.isAutoApplyNeighborXpathsEnabled());
        generalProperties.setTerminateDriverAfterTestCase(Boolean.valueOf(store.isPostTestCaseExecQuitDriver()));
        generalProperties.setTerminateDriverAfterTestSuite(Boolean.valueOf(store.isPostTestSuiteExecQuitDriver()));
        generalProperties.setTestDataInfo(new SerializableMap());
        generalProperties.setReport(this.buildReportProperties(executionDirPath));
        try {
            WebUiExecutionSettingStore webUiSettingStore = WebUiExecutionSettingStore.getStore();
            generalProperties.setXpathsPriority(this.buildXpathsPriority(webUiSettingStore.getCapturedTestObjectXpathLocators()));
            generalProperties.setActionDelay(Integer.valueOf(webUiSettingStore.getActionDelay()));
            generalProperties.setUseActionDelayInSecond(webUiSettingStore.getUseDelayActionTimeUnit().toString());
            generalProperties.setTimeCapsuleEnabled(Boolean.valueOf(webUiSettingStore.getTimeCapsuleEnabled()));
            generalProperties.setEnablePageLoadTimeout(Boolean.valueOf(webUiSettingStore.getEnablePageLoadTimeout()));
            generalProperties.setTimeout(Integer.valueOf(webUiSettingStore.getElementTimeout()));
            generalProperties.setIgnorePageLoadTimeoutException(Boolean.valueOf(webUiSettingStore.getIgnorePageLoadTimeout()));
            generalProperties.setSelfHealingEnabled(Boolean.valueOf(webUiSettingStore.getSelfHealingEnabled(this.featureManager.canUse(ProductFeature.SELF_HEALING))));
            generalProperties.setCanvasTextExtractionEnabled(Boolean.valueOf(webUiSettingStore.isEnableCanvasTextExtraction()));
            generalProperties.setClosedShadowDOMEnabled(Boolean.valueOf(webUiSettingStore.isEnableClosedShadowDOMTesting()));
            generalProperties.setFlutterAppTestingEnabled(Boolean.valueOf(webUiSettingStore.isEnableFlutterAppTesting()));
            generalProperties.setDefaultPageLoadTimeout(Integer.valueOf(webUiSettingStore.getPageLoadTimeout()));
            List methodsPriorityOrder = webUiSettingStore.getMethodsPriorityOrder();
            if (methodsPriorityOrder != null) {
                generalProperties.setMethodsPriorityOrder(this.buildMethodsPriority(methodsPriorityOrder));
            }
        }
        catch (Exception e) {
            throw new ExecutionException("Failed to build general properties", (Throwable)e);
        }
        return generalProperties;
    }

    private List<GeneralProperties.PriorityItem> buildXpathsPriority(List<Pair<String, Boolean>> capturedTestObjectXpathLocators) {
        return this.buildPriorityItems(capturedTestObjectXpathLocators);
    }

    private <T> List<GeneralProperties.PriorityItem> buildMethodsPriority(List<Pair<T, Boolean>> methodsPriorityOrder) {
        return this.buildPriorityItems(methodsPriorityOrder);
    }

    private <T> List<GeneralProperties.PriorityItem> buildPriorityItems(List<Pair<T, Boolean>> pairs) {
        if (pairs == null) {
            return List.of();
        }
        return pairs.stream().map(pair -> {
            GeneralProperties.PriorityItem priorityItem = new GeneralProperties.PriorityItem();
            Object left = pair.getLeft();
            priorityItem.setLeft(left != null ? left.toString() : "");
            priorityItem.setRight((Boolean)pair.getRight());
            return priorityItem;
        }).toList();
    }

    private GeneralProperties.Report buildReportProperties(Path executionDirPath) throws ExecutionException {
        GeneralProperties.Report reportProps = new GeneralProperties.Report();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        try {
            ExecutionSettingStore store = new ExecutionSettingStore(project);
            reportProps.setReportFolder(executionDirPath.toString());
            reportProps.setTakeScreenshotSettings(store.getTakeScreenSettings());
            reportProps.setVideoRecorderSettings(store.getVideoRecorderSettings());
            reportProps.setScreenCaptureOption(Boolean.valueOf(store.getScreenCaptureOption()));
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to build report properties", (Throwable)e);
        }
        return reportProps;
    }

    private String getLogbackConfigFileLocation() {
        String logbackConfigFileLocation = null;
        try {
            File logbackConfigFile = LogConfigurator.getConfigFile((String)"logback-execution.xml");
            if (logbackConfigFile != null && logbackConfigFile.exists()) {
                logbackConfigFileLocation = logbackConfigFile.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            logger.error("Failed to get logback config file for execution");
        }
        return logbackConfigFileLocation;
    }

    private String getJsonProxyInformationWithEncryptedPassword() {
        ProxyInformation proxyInfo = ProxyPreferences.getSystemProxyInformation();
        String password = proxyInfo.getPassword();
        if (!StringUtils.isEmpty((CharSequence)password)) {
            try {
                CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)password);
                proxyInfo.setPassword(CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo));
            }
            catch (IOException | GeneralSecurityException ex) {
                logger.error("Failed to get proxy password", (Throwable)ex);
            }
        }
        return new Gson().toJson((Object)proxyInfo);
    }

    private TestSuiteRerunSettings buildTestSuiteRerunSettings(TestExecutionRequest request) throws ExecutionException {
        IExecutableEntity iExecutableEntity = request.getEntity();
        if (iExecutableEntity instanceof TestSuiteEntity) {
            boolean shouldUseOverridingStrategy;
            TestSuiteEntity testSuiteEntity = (TestSuiteEntity)iExecutableEntity;
            KREOverridingConfiguration kreOverridingConfiguration = request.getKreOverridingConfiguration();
            DefaultRerunSetting overridingRerunSetting = kreOverridingConfiguration != null ? kreOverridingConfiguration.getRerunSetting() : null;
            int maxRetryCount = 0;
            maxRetryCount = overridingRerunSetting != null && overridingRerunSetting.isOverrideRemainingRerunTimes() ? overridingRerunSetting.getRemainingRerunTimes() : testSuiteEntity.getNumberOfRerun();
            TestSuiteRerunSettings.RetryStrategy retryStrategy = null;
            retryStrategy = overridingRerunSetting != null ? ((shouldUseOverridingStrategy = overridingRerunSetting.isOverrideRerunImmediately()) ? this.determineRetryStrategy(overridingRerunSetting) : this.determineRetryStrategy(testSuiteEntity)) : this.determineRetryStrategy(testSuiteEntity);
            if (retryStrategy == null) {
                throw new ExecutionException("Failed to determine retry strategy for test suite rerun settings.");
            }
            return new TestSuiteRerunSettings(retryStrategy, maxRetryCount);
        }
        return null;
    }

    private TestSuiteRerunSettings.RetryStrategy determineRetryStrategy(TestSuiteEntity testSuiteEntity) {
        if (testSuiteEntity.isRerunImmediately()) {
            return TestSuiteRerunSettings.RetryStrategy.IMMEDIATELY;
        }
        if (testSuiteEntity.isRerunFailedTestCasesOnly() || testSuiteEntity.isRerunFailedTestCasesAndTestDataOnly()) {
            return TestSuiteRerunSettings.RetryStrategy.FAILED_EXECUTIONS;
        }
        return TestSuiteRerunSettings.RetryStrategy.ALL_EXECUTIONS;
    }

    private TestSuiteRerunSettings.RetryStrategy determineRetryStrategy(DefaultRerunSetting rerunSetting) {
        if (rerunSetting.isRerunImmediately()) {
            return TestSuiteRerunSettings.RetryStrategy.IMMEDIATELY;
        }
        if (rerunSetting.isRerunFailedTestCasesOnly() || rerunSetting.isRerunFailedTestCasesAndTestDataOnly()) {
            return TestSuiteRerunSettings.RetryStrategy.FAILED_EXECUTIONS;
        }
        return TestSuiteRerunSettings.RetryStrategy.ALL_EXECUTIONS;
    }
}

