/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class ExecutionVMArgsBuilder {
    private static final String FILE_ENCODING_ARG = "-Dfile.encoding=";
    private static final String DEFAULT_FILE_ENCODING_ARG = "-Dfile.encoding=UTF-8";
    private static final String JAVA2D_METAL_ARG = "-Dsun.java2d.metal=";
    private static final String DISABLE_JAVA2D_METAL_ARG = "-Dsun.java2d.metal=false";
    private static final String PROFILING_VM_ARG = "-Dkatalon.enableProfiling=";
    private static final String ENABLE_PROFILING_VM_ARG = "-Dkatalon.enableProfiling=true";
    private final IFeatureManager featureManager;

    public ExecutionVMArgsBuilder(IFeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public List<String> build(TestExecutionRequest request) throws ExecutionException {
        String java2dMetalArg;
        Optional<String> fileEncodingArg;
        ArrayList<String> vmArgs = new ArrayList<String>();
        KREOverridingConfiguration kreOverridingConfiguration = request.getKreOverridingConfiguration();
        ExecutionDefaultSettingStore store = ExecutionDefaultSettingStore.getStore();
        if (this.featureManager.canUse(ProductFeature.LAUNCH_ARGUMENTS_SETTINGS)) {
            vmArgs.addAll(List.of(StringUtils.split((String)store.getVmArgs())));
        }
        if ((fileEncodingArg = vmArgs.stream().filter(vmArg -> vmArg.startsWith(FILE_ENCODING_ARG)).findFirst()).isEmpty()) {
            vmArgs.add(DEFAULT_FILE_ENCODING_ARG);
        }
        if (kreOverridingConfiguration != null && kreOverridingConfiguration.isEnableProfiling()) {
            String profilingVmArg = vmArgs.stream().filter(vmArg -> vmArg.startsWith(PROFILING_VM_ARG)).findFirst().orElse(null);
            if (!StringUtils.isEmpty((CharSequence)profilingVmArg)) {
                vmArgs.remove(profilingVmArg);
            }
            vmArgs.add(0, ENABLE_PROFILING_VM_ARG);
        }
        if (StringUtils.isEmpty((CharSequence)(java2dMetalArg = (String)vmArgs.stream().filter(vmArg -> vmArg.startsWith(JAVA2D_METAL_ARG)).findFirst().orElse(null)))) {
            vmArgs.add(DISABLE_JAVA2D_METAL_ARG);
        }
        return vmArgs;
    }
}

