/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.KobitonConfig;
import com.katalon.execution.dto.request.LocalMobileDeviceConfig;
import com.katalon.execution.dto.request.RemoteDriverConfig;
import com.katalon.execution.dto.request.TestCloudConfig;
import com.katalon.execution.dto.request.WindowsDriverConfig;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.execution.mobile.configuration.MobileRunConfiguration;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.execution.windows.WindowsRunConfiguration;
import com.kms.katalon.integration.kobiton.configuration.KobitonRunConfiguration;
import com.kms.katalon.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.service.ITestCloudEntity;
import com.kms.katalon.testcloud.driver.TestCloudDriverConnector;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyDriverConfigurationConverter {
    private static final Logger logger = LoggerFactory.getLogger(LegacyDriverConfigurationConverter.class);

    public static DriverConfiguration fromLegacyConfig(IRunConfiguration legacyFlowConfig) {
        if (legacyFlowConfig instanceof TestCloudRunConfiguration) {
            TestCloudRunConfiguration legacyTestCloudConfig = (TestCloudRunConfiguration)legacyFlowConfig;
            TestCloudDriverConnector legacyConnector = legacyTestCloudConfig.getTestCloudDriverConnector();
            Map systemProps = legacyConnector.getSystemProperties();
            Map userProps = legacyConnector.getUserConfigProperties();
            TestCloudEntity testCloudEntity = legacyConnector.getTestCloudEntity();
            TestCloudSessionType testCloudSessionType = legacyConnector.getTestCloudSessionType();
            TestCloudConfig testCloudConfig = new TestCloudConfig(systemProps, userProps, testCloudSessionType, (ITestCloudEntity)testCloudEntity);
            return testCloudConfig;
        }
        if (legacyFlowConfig instanceof KobitonRunConfiguration) {
            KobitonRunConfiguration legacyKobitonConfig = (KobitonRunConfiguration)legacyFlowConfig;
            RemoteWebDriverConnector legacyConnector = legacyKobitonConfig.getRemoteDriverConnector();
            Map systemProps = legacyConnector.getSystemProperties();
            KobitonConfig kobitonConfig = new KobitonConfig(systemProps, legacyKobitonConfig.getKobitonDevice());
            return kobitonConfig;
        }
        if (legacyFlowConfig instanceof MobileRunConfiguration) {
            MobileRunConfiguration legacyMobileConfig = (MobileRunConfiguration)legacyFlowConfig;
            return new LocalMobileDeviceConfig(legacyMobileConfig.getDevice());
        }
        if (legacyFlowConfig instanceof RemoteWebRunConfiguration) {
            RemoteWebRunConfiguration legacyRemoteConfig = (RemoteWebRunConfiguration)legacyFlowConfig;
            RemoteWebDriverConnector legacyConnector = legacyRemoteConfig.getRemoteDriverConnector();
            Map systemProps = legacyConnector.getSystemProperties();
            RemoteDriverConfig remoteWebDriverConfig = new RemoteDriverConfig(systemProps);
            return remoteWebDriverConfig;
        }
        if (legacyFlowConfig instanceof WindowsRunConfiguration) {
            WindowsRunConfiguration legacyWindowsConfig = (WindowsRunConfiguration)legacyFlowConfig;
            WindowsDriverConnector legacyConnector = legacyWindowsConfig.getDriverConnector();
            WindowsDriverConfig windowsDriverConfig = new WindowsDriverConfig(legacyConnector.getDriverUrl());
            return windowsDriverConfig;
        }
        return null;
    }
}

