/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.exception.ExecutionException;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.testdata.TestData;
import com.kms.katalon.entity.link.IterationType;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestDataCombinationType;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.util.SyntaxUtil;
import com.kms.katalon.groovy.util.GroovyStringUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;

public final class TestCaseBindingBuilder {
    private TestCaseBindingBuilder() {
    }

    public static List<TestCaseBinding> buildForTestCase(TestCaseEntity testCase) throws Exception {
        String projectDir;
        String string = projectDir = testCase.getProject() != null ? testCase.getProject().getFolderLocation() : null;
        if (projectDir == null) {
            throw new ExecutionException("Failed to resolve project directory for test case: " + testCase.getName());
        }
        List testDataLinks = TestCaseController.getInstance().getTestDataLinkUsedInTestCase(testCase);
        DataBindingContext bindingContext = TestCaseBindingBuilder.buildDataBindingContext(testDataLinks, projectDir, testCase.getIdForDisplay());
        boolean appendSuffix = bindingContext.iterationCount > 1;
        ArrayList<TestCaseBinding> bindings = new ArrayList<TestCaseBinding>();
        int iterationIdx = 0;
        while (iterationIdx < bindingContext.iterationCount) {
            StringBuilder iterationErrors = new StringBuilder();
            HashMap<String, String> variableBinding = new HashMap<String, String>();
            for (VariableEntity variableEntity : testCase.getVariables()) {
                VariableLink variableLink = null;
                try {
                    variableLink = TestCaseController.getInstance().getVariableLink(testCase.getIdForDisplay(), variableEntity.getName());
                }
                catch (Exception e) {
                    iterationErrors.append(e.getMessage()).append(SyntaxUtil.LINE_SEPARATOR);
                    continue;
                }
                if (variableLink == null) continue;
                try {
                    String variableValue = TestCaseBindingBuilder.evaluateVariableValue(variableEntity.getName(), variableLink, bindingContext, iterationIdx);
                    if (variableValue == null) continue;
                    variableBinding.put(variableEntity.getName(), variableValue);
                }
                catch (IllegalArgumentException e) {
                    iterationErrors.append(e.getMessage()).append(SyntaxUtil.LINE_SEPARATOR);
                }
            }
            if (iterationErrors.length() > 0) {
                throw new IllegalArgumentException(iterationErrors.toString());
            }
            TestCaseBinding binding = TestCaseBindingBuilder.createTestCaseBinding(testCase.getIdForDisplay(), testCase.getIdForDisplay(), appendSuffix, iterationIdx, variableBinding, null);
            bindings.add(binding);
            ++iterationIdx;
        }
        return bindings;
    }

    public static List<TestCaseBinding> buildForTestCaseInTestSuite(TestSuiteTestCaseLink testCaseLink, TestSuiteEntity testSuite, List<TestCaseTestDataLink> testDataLinks) throws Exception {
        String projectDir;
        String string = projectDir = testSuite.getProject() != null ? testSuite.getProject().getFolderLocation() : null;
        if (projectDir == null) {
            throw new ExecutionException("Failed to resolve project directory for test suite: " + testSuite.getName());
        }
        DataBindingContext bindingContext = TestCaseBindingBuilder.buildDataBindingContext(testDataLinks, projectDir, testCaseLink.getTestCaseId());
        boolean appendSuffix = bindingContext.iterationCount > 1;
        ArrayList<TestCaseBinding> bindings = new ArrayList<TestCaseBinding>();
        int iterationIdx = 0;
        while (iterationIdx < bindingContext.iterationCount) {
            StringBuilder iterationErrors = new StringBuilder();
            HashMap<String, String> variableBinding = new HashMap<String, String>();
            for (VariableLink variableLink : testCaseLink.getVariableLinks()) {
                try {
                    String variableValue;
                    VariableEntity variableEntity = TestSuiteController.getInstance().getVariable(testCaseLink, variableLink);
                    if (variableEntity == null || (variableValue = TestCaseBindingBuilder.evaluateVariableValue(variableEntity.getName(), variableLink, bindingContext, iterationIdx)) == null) continue;
                    variableBinding.put(variableEntity.getName(), variableValue);
                }
                catch (Exception e) {
                    iterationErrors.append(e.getMessage()).append(SyntaxUtil.LINE_SEPARATOR);
                }
            }
            if (iterationErrors.length() > 0) {
                throw new IllegalArgumentException(iterationErrors.toString());
            }
            String iterationVariableName = testCaseLink.getIterationNameVariable() != null ? testCaseLink.getIterationNameVariable().getName() : "";
            TestCaseBinding binding = TestCaseBindingBuilder.createTestCaseBinding(testCaseLink.getTestCaseId(), testCaseLink.getTestCaseId(), appendSuffix, iterationIdx, variableBinding, iterationVariableName);
            bindings.add(binding);
            ++iterationIdx;
        }
        return bindings;
    }

    private static TestCaseBinding createTestCaseBinding(String baseTestCaseName, String testCaseId, boolean appendSuffix, int iterationIdx, Map<String, String> variableBinding, String iterationVariableName) {
        Object testCaseName = baseTestCaseName;
        if (appendSuffix) {
            testCaseName = (String)testCaseName + " - Iteration " + (iterationIdx + 1);
        }
        HashMap<String, String> bindingValues = variableBinding.isEmpty() ? null : new HashMap<String, String>(variableBinding);
        TestCaseBinding binding = new TestCaseBinding((String)testCaseName, testCaseId, bindingValues);
        binding.setIterationVariableName(iterationVariableName != null ? iterationVariableName : "");
        binding.setTestCaseExecutionId(UUID.randomUUID());
        return binding;
    }

    private static String evaluateVariableValue(String variableName, VariableLink variableLink, DataBindingContext bindingContext, int iterationIdx) {
        String variableValue = null;
        try {
            switch (variableLink.getType()) {
                case DATA_COLUMN: {
                    variableValue = TestCaseBindingBuilder.evaluateDataColumn(variableName, variableLink, bindingContext, iterationIdx);
                    break;
                }
                case DATA_COLUMN_INDEX: {
                    variableValue = TestCaseBindingBuilder.evaluateDataColumnIndex(variableName, variableLink, bindingContext, iterationIdx);
                    break;
                }
                case DEFAULT: {
                    variableValue = null;
                    break;
                }
                case SCRIPT_VARIABLE: {
                    variableValue = variableLink.getValue();
                    break;
                }
                default: {
                    throw new NotImplementedException(variableLink.getType().name());
                }
            }
            return variableValue;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception ex) {
            String rawValue = variableLink.getValue();
            throw new IllegalArgumentException(TestCaseBindingBuilder.getErrorSyntaxMessageWithReason(variableName, rawValue != null ? rawValue : "", ex.getMessage()), ex);
        }
    }

    private static String evaluateDataColumn(String variableName, VariableLink variableLink, DataBindingContext bindingContext, int iterationIdx) throws IOException {
        String columnName = variableLink.getValue();
        if (StringUtils.isEmpty((CharSequence)columnName)) {
            throw new IllegalArgumentException(TestCaseBindingBuilder.getErrorSyntaxMessageWithReason(variableName, "", ExecutionMessageConstants.ERR_COLUMN_NAME_CANNOT_EMPTY));
        }
        DataBindingInfo bindingInfo = bindingContext.bindingsById.get(variableLink.getTestDataLinkId());
        if (bindingInfo == null) {
            throw new IllegalArgumentException(TestCaseBindingBuilder.getErrorSyntaxMessageWithReason(variableName, columnName, ExecutionMessageConstants.ERR_TEST_DATA_VALUE_CANNOT_EMPTY));
        }
        int rowNumber = TestCaseBindingBuilder.resolveRowNumber(bindingInfo, iterationIdx);
        Object cellValue = bindingInfo.testData.getObjectValue(columnName, rowNumber);
        return TestCaseBindingBuilder.convertBindingValue(cellValue);
    }

    private static String evaluateDataColumnIndex(String variableName, VariableLink variableLink, DataBindingContext bindingContext, int iterationIdx) throws IOException {
        String columnIndexAsString = variableLink.getValue();
        if (StringUtils.isEmpty((CharSequence)columnIndexAsString) || !TestCaseBindingBuilder.isIntegerFormat(columnIndexAsString)) {
            throw new IllegalArgumentException(TestCaseBindingBuilder.getErrorSyntaxMessageWithReason(variableName, "", ExecutionMessageConstants.ERR_VARIABLE_VALUE_NOT_INTEGER_FORMAT));
        }
        DataBindingInfo bindingInfo = bindingContext.bindingsById.get(variableLink.getTestDataLinkId());
        if (bindingInfo == null) {
            throw new IllegalArgumentException(TestCaseBindingBuilder.getErrorSyntaxMessageWithReason(variableName, columnIndexAsString, ExecutionMessageConstants.ERR_TEST_DATA_VALUE_CANNOT_EMPTY));
        }
        int rowNumber = TestCaseBindingBuilder.resolveRowNumber(bindingInfo, iterationIdx);
        Object cellValue = bindingInfo.testData.getObjectValue(Integer.parseInt(columnIndexAsString), rowNumber);
        return TestCaseBindingBuilder.convertBindingValue(cellValue);
    }

    private static String convertBindingValue(Object cellValue) {
        if (cellValue == null) {
            return null;
        }
        if (cellValue instanceof String) {
            return GroovyStringUtil.toGroovyStringFormat((String)cellValue.toString());
        }
        return cellValue.toString();
    }

    private static DataBindingContext buildDataBindingContext(List<TestCaseTestDataLink> testDataLinks, String projectDir, String entityId) throws Exception {
        int effectiveOneCount;
        HashMap<String, TestData> testDataCache = new HashMap<String, TestData>();
        LinkedHashMap<String, DataBindingInfo> bindingsById = new LinkedHashMap<String, DataBindingInfo>();
        ArrayList<DataBindingInfo> bindingInfos = new ArrayList<DataBindingInfo>();
        int numberTestCaseUsedOnce = 0;
        int numTestDataRowUsedManyTimes = 1;
        for (TestCaseTestDataLink testDataLink : testDataLinks) {
            TestData testData;
            int[] rowIndexes = TestCaseBindingBuilder.resolveRowIndexes(entityId, testDataLink, testData = TestCaseBindingBuilder.findTestData(projectDir, testDataCache, testDataLink));
            if (rowIndexes.length == 0) {
                throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_DOES_NOT_CONTAIN_ANY_RECORDS, testDataLink.getTestDataId()));
            }
            DataBindingInfo bindingInfo = new DataBindingInfo(testDataLink, testData, rowIndexes);
            bindingInfo.multiplier = numTestDataRowUsedManyTimes;
            if (testDataLink.getCombinationType() == TestDataCombinationType.ONE) {
                numberTestCaseUsedOnce = numberTestCaseUsedOnce < 1 ? rowIndexes.length : Math.min(numberTestCaseUsedOnce, rowIndexes.length);
            } else {
                for (DataBindingInfo sibling : bindingInfos) {
                    if (sibling.link.getCombinationType() != TestDataCombinationType.MANY) continue;
                    sibling.multiplier *= rowIndexes.length;
                }
                numTestDataRowUsedManyTimes *= rowIndexes.length;
            }
            bindingInfos.add(bindingInfo);
            bindingsById.put(testDataLink.getId(), bindingInfo);
        }
        int n = effectiveOneCount = numberTestCaseUsedOnce > 0 ? numberTestCaseUsedOnce : 1;
        if (numberTestCaseUsedOnce > 0) {
            for (DataBindingInfo info : bindingInfos) {
                if (info.link.getCombinationType() != TestDataCombinationType.ONE || info.rowIndexes.length <= effectiveOneCount) continue;
                info.rowIndexes = Arrays.copyOf(info.rowIndexes, effectiveOneCount);
            }
        }
        int iterationCount = bindingInfos.isEmpty() ? 1 : numTestDataRowUsedManyTimes * effectiveOneCount;
        return new DataBindingContext(bindingsById, iterationCount);
    }

    private static TestData findTestData(String projectDir, Map<String, TestData> cache, TestCaseTestDataLink testDataLink) throws Exception {
        TestData testData = cache.get(testDataLink.getTestDataId());
        if (testData == null) {
            testData = TestDataController.getInstance().getTestDataInstance(testDataLink.getTestDataId(), projectDir);
        }
        if (testData == null) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_DATA_SRC_X_UNAVAILABLE, testDataLink.getTestDataId()));
        }
        if (testData.getRowNumbers() < 1) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_DOES_NOT_CONTAIN_ANY_RECORDS, testDataLink.getTestDataId()));
        }
        cache.put(testDataLink.getTestDataId(), testData);
        return testData;
    }

    private static int[] resolveRowIndexes(String entityId, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        IterationType iterationType;
        IterationType iterationType2 = iterationType = testDataLink.getIterationEntity() != null ? testDataLink.getIterationEntity().getIterationType() : null;
        if (iterationType == null) {
            iterationType = IterationType.ALL;
        }
        switch (iterationType) {
            case RANGE: {
                return TestCaseBindingBuilder.resolveRowIndexesForRange(entityId, testDataLink, testData);
            }
            case SPECIFIC: {
                return TestCaseBindingBuilder.resolveRowIndexesForSpecific(entityId, testDataLink, testData);
            }
        }
        return TestCaseBindingBuilder.resolveRowIndexesForAll(testData, testDataLink);
    }

    private static int[] resolveRowIndexesForAll(TestData testData, TestCaseTestDataLink testDataLink) throws IOException {
        int rowCount = testData.getRowNumbers();
        if (rowCount <= 0) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_DOES_NOT_CONTAIN_ANY_RECORDS, testDataLink.getTestDataId()));
        }
        int[] rowIndexes = new int[rowCount];
        int index = 0;
        while (index < rowCount) {
            rowIndexes[index] = index + 1;
            ++index;
        }
        return rowIndexes;
    }

    private static int[] resolveRowIndexesForRange(String entityId, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        int rowStart = testDataLink.getIterationEntity().getFrom();
        int rowEnd = testDataLink.getIterationEntity().getTo();
        int totalRowCount = testData.getRowNumbers();
        if (rowStart > totalRowCount) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_START_AT_ROW_IDX, testDataLink.getTestDataId(), totalRowCount, entityId, rowStart));
        }
        if (rowEnd > totalRowCount) {
            throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_ENDS_AT_ROW_IDX, testDataLink.getTestDataId(), totalRowCount, entityId, rowEnd));
        }
        int rowCount = rowEnd - rowStart + 1;
        int[] rowIndexes = new int[rowCount];
        int index = 0;
        while (index < rowCount) {
            rowIndexes[index] = index + rowStart;
            ++index;
        }
        return rowIndexes;
    }

    private static int[] resolveRowIndexesForSpecific(String entityId, TestCaseTestDataLink testDataLink, TestData testData) throws IOException {
        String value;
        String string = value = testDataLink.getIterationEntity() != null ? testDataLink.getIterationEntity().getValue() : null;
        if (value == null) {
            value = "";
        }
        String[] rowIndexesString = value.replace(" ", "").split(",");
        int totalRowCount = testData.getRowNumbers();
        ArrayList<Integer> rowIndexArray = new ArrayList<Integer>();
        String[] stringArray = rowIndexesString;
        int n = rowIndexesString.length;
        int n2 = 0;
        while (n2 < n) {
            String rowIndexString = stringArray[n2];
            if (!StringUtils.isEmpty((CharSequence)rowIndexString)) {
                if (rowIndexString.contains("-")) {
                    String[] rowIndexStartEndString = rowIndexString.split("-");
                    int rowStart = Integer.parseInt(rowIndexStartEndString[0]);
                    int rowEnd = Integer.parseInt(rowIndexStartEndString[1]);
                    if (rowStart > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_START_AT_ROW_IDX, testDataLink.getTestDataId(), Integer.toString(totalRowCount), entityId, Integer.toString(rowStart)));
                    }
                    if (rowEnd > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TD_X_HAS_ONLY_Y_ROWS_BUT_TC_Z_ENDS_AT_ROW_IDX, testDataLink.getTestDataId(), Integer.toString(totalRowCount), entityId, Integer.toString(rowEnd)));
                    }
                    int rowIndex = rowStart;
                    while (rowIndex <= rowEnd) {
                        rowIndexArray.add(rowIndex);
                        ++rowIndex;
                    }
                } else {
                    int rowIndex = Integer.parseInt(rowIndexString);
                    if (rowIndex < 1 || rowIndex > totalRowCount) {
                        throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_IDX_X_INVALID_TC_Y_TD_Z, rowIndexString, entityId, testDataLink.getTestDataId()));
                    }
                    rowIndexArray.add(rowIndex);
                }
            }
            ++n2;
        }
        return ArrayUtils.toPrimitive((Integer[])rowIndexArray.toArray(new Integer[0]));
    }

    private static int resolveRowNumber(DataBindingInfo bindingInfo, int iterationIdx) {
        if (bindingInfo.rowIndexes.length == 0) {
            return 1;
        }
        if (bindingInfo.link.getCombinationType() == TestDataCombinationType.ONE) {
            return bindingInfo.rowIndexes[iterationIdx % bindingInfo.rowIndexes.length];
        }
        int divisor = Math.max(bindingInfo.multiplier, 1);
        int index = iterationIdx / divisor % bindingInfo.rowIndexes.length;
        return bindingInfo.rowIndexes[index];
    }

    private static boolean isIntegerFormat(String integerAsString) {
        return StringUtils.isNotEmpty((CharSequence)integerAsString) && StringUtils.isNumeric((CharSequence)integerAsString);
    }

    private static String getErrorSyntaxMessageWithReason(String variableName, String variableValue, String reason) {
        String displayedVariableValue = variableValue;
        if (variableValue == null) {
            displayedVariableValue = "null";
        } else if (variableValue.isEmpty()) {
            displayedVariableValue = "<empty string>";
        }
        return "Wrong syntax at [Variable name: " + variableName + ", Variable value: " + displayedVariableValue + "]. Reason: " + reason;
    }

    private static final class DataBindingContext {
        private final Map<String, DataBindingInfo> bindingsById;
        private final int iterationCount;

        private DataBindingContext(Map<String, DataBindingInfo> bindingsById, int iterationCount) {
            this.bindingsById = bindingsById;
            this.iterationCount = iterationCount;
        }
    }

    private static final class DataBindingInfo {
        private final TestCaseTestDataLink link;
        private final TestData testData;
        private int[] rowIndexes;
        private int multiplier = 1;

        private DataBindingInfo(TestCaseTestDataLink link, TestData testData, int[] rowIndexes) {
            this.link = link;
            this.testData = testData;
            this.rowIndexes = rowIndexes;
        }
    }
}

