/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.ExistingDriverConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.RunConfigurationProperties;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.services.planner.TestCaseBindingBuilder;
import com.katalon.execution.services.templates.GenerateTestCaseScriptRequest;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.SystemFileEntity;
import com.kms.katalon.entity.testcase.RecordPlaybackTestCaseEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testcase.WSVerificationTestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;

public class TestCaseExecutionPlanner {
    private static final String NORMAL_TEST_CASE_CLASS_NAME = "com.katalon.execution.services.templates.TestCaseScriptTemplate";
    private static final String CUCUMBER_FEATURE_FILE_CLASS_NAME = "com.katalon.execution.services.templates.FeatureFileScriptTemplate";
    private static final String RECORD_PLAYBACK_CLASS_NAME = "com.katalon.execution.services.templates.RecordPlaybackScriptTemplate";
    private static final String GENERATED_TEST_CASE_SCRIPT_METHOD_NAME = "generateTestCaseScriptFile";
    private static final String TEMP_TEST_CASE_FILE_NAME = "TempTestCase";
    private final TestExecutionRequest testExecutionRequest;
    private BaseTestCaseExecution testCaseExecution;

    public TestCaseExecutionPlanner(TestExecutionRequest testExecutionRequest, BaseTestCaseExecution testCaseExecution) {
        this.testExecutionRequest = testExecutionRequest;
        this.testCaseExecution = testCaseExecution;
    }

    public void planTestCaseExecutions() throws ExecutionException {
        TestCaseEntity testCaseEntity = this.testCaseExecution.getTestCase();
        BaseTestCaseExecution baseTestCaseExecution = this.testCaseExecution;
        if (baseTestCaseExecution instanceof TestCaseBindingExecution) {
            List<TestCaseBinding> testCaseBindings;
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)baseTestCaseExecution;
            try {
                testCaseBindings = TestCaseBindingBuilder.buildForTestCase(testCaseEntity);
            }
            catch (Exception e) {
                throw new ExecutionException("Failed to build test case bindings", (Throwable)e);
            }
            for (TestCaseBinding testCaseBinding : testCaseBindings) {
                testCaseBindingExecution.addIterationWithBinding(testCaseEntity, testCaseBinding);
            }
        }
    }

    public File generateTestCaseScriptFile(IFolder scriptFolder) throws IOException, CoreException, ReflectiveOperationException, ExecutionException {
        ExistingDriverConfiguration existingDriverConfig;
        File scriptFile = this.createScriptFile(scriptFolder);
        GroovyObject template = this.getTemplateInstance(NORMAL_TEST_CASE_CLASS_NAME);
        ExecutionSettings executionSettings = this.testCaseExecution.getExecutionSettings();
        RunConfigurationProperties runConfigProps = executionSettings.getRunConfiguration();
        GenerateTestCaseScriptRequest generateRequest = new GenerateTestCaseScriptRequest();
        generateRequest.setTestCaseId(runConfigProps.getEntityId());
        generateRequest.setExecutionSettingsFilePath(this.getExecutionSettingsFilePath());
        generateRequest.setTestCaseBinding(this.createTestCaseBinding());
        generateRequest.setQuitDriversAfterRun(runConfigProps.getExecution().getGeneral().getTerminateDriverAfterTestCase());
        DriverConfiguration driverConfiguration = this.testExecutionRequest.getDriverConfiguration();
        if (driverConfiguration instanceof ExistingDriverConfiguration && (existingDriverConfig = (ExistingDriverConfiguration)driverConfiguration).getRawScript() != null) {
            generateRequest.setRawScript(existingDriverConfig.getRawScript());
        } else {
            generateRequest.setRawScript(null);
        }
        BaseTestCaseExecution baseTestCaseExecution = this.testCaseExecution;
        if (baseTestCaseExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)baseTestCaseExecution;
            File bindingFile = this.createTestCaseBindingFile(testCaseBindingExecution);
            generateRequest.setTestCaseBindingFilePath(bindingFile.getAbsolutePath());
        }
        template.invokeMethod(GENERATED_TEST_CASE_SCRIPT_METHOD_NAME, (Object)new Object[]{scriptFile, generateRequest});
        scriptFolder.refreshLocal(1, null);
        return scriptFile;
    }

    public File generateCucumberScriptFile(IFolder scriptFolder) throws IOException, CoreException, ReflectiveOperationException, ExecutionException {
        File scriptFile = this.createScriptFile(scriptFolder);
        GroovyObject template = this.getTemplateInstance(CUCUMBER_FEATURE_FILE_CLASS_NAME);
        ExecutionSettings executionSettings = this.testCaseExecution.getExecutionSettings();
        RunConfigurationProperties runConfigProps = executionSettings.getRunConfiguration();
        GenerateTestCaseScriptRequest generateRequest = new GenerateTestCaseScriptRequest();
        generateRequest.setFeatureFile((SystemFileEntity)this.testExecutionRequest.getEntity());
        generateRequest.setExecutionSettingsFilePath(this.getExecutionSettingsFilePath());
        generateRequest.setQuitDriversAfterRun(runConfigProps.getExecution().getGeneral().getTerminateDriverAfterTestCase());
        template.invokeMethod(GENERATED_TEST_CASE_SCRIPT_METHOD_NAME, (Object)new Object[]{scriptFile, generateRequest});
        scriptFolder.refreshLocal(1, null);
        return scriptFile;
    }

    public File generateRecordPlaybackScriptFile(IFolder scriptFolder, RecordPlaybackTestCaseEntity testCase) throws IOException, CoreException, ReflectiveOperationException, ExecutionException {
        File scriptFile = this.createScriptFile(scriptFolder);
        GroovyObject template = this.getTemplateInstance(RECORD_PLAYBACK_CLASS_NAME);
        GenerateTestCaseScriptRequest generateRequest = new GenerateTestCaseScriptRequest();
        generateRequest.setWsVerificationScript(testCase.getScript());
        generateRequest.setExecutionSettingsFilePath(this.getExecutionSettingsFilePath());
        generateRequest.setTestCaseBinding(this.createTestCaseBinding());
        template.invokeMethod(GENERATED_TEST_CASE_SCRIPT_METHOD_NAME, (Object)new Object[]{scriptFile, generateRequest});
        scriptFolder.refreshLocal(1, null);
        return scriptFile;
    }

    private GroovyObject getTemplateInstance(String templateClassName) throws ReflectiveOperationException {
        return (GroovyObject)Class.forName(templateClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private String getExecutionSettingsFilePath() {
        ExecutionSettings executionSettings = this.testCaseExecution.getExecutionSettings();
        return executionSettings.getSettingsFilePath().toAbsolutePath().toString();
    }

    private File createScriptFile(IFolder scriptFolder) throws IOException {
        String fileName = TEMP_TEST_CASE_FILE_NAME + System.currentTimeMillis() + ".groovy";
        Path filePath = scriptFolder.getRawLocation().toFile().toPath().resolve(fileName);
        File scriptFile = Files.createFile(filePath, new FileAttribute[0]).toFile();
        return scriptFile;
    }

    private File createTestCaseBindingFile(TestCaseBindingExecution testCaseBindingExecution) throws IOException {
        ExecutionSettings executionSettings = testCaseBindingExecution.getExecutionSettings();
        Path executionDir = executionSettings.getExecutionDirPath();
        if (executionDir == null) {
            throw new IllegalStateException("Execution directory path is not defined for test case binding execution");
        }
        Path bindingFilePath = executionDir.resolve("testCaseBinding");
        Files.createDirectories(bindingFilePath.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(bindingFilePath);
        Files.createFile(bindingFilePath, new FileAttribute[0]);
        File bindingFile = bindingFilePath.toFile();
        List testCaseBindings = testCaseBindingExecution.getTestCaseBindings();
        if (testCaseBindings != null && !testCaseBindings.isEmpty()) {
            ArrayList<String> bindingLines = new ArrayList<String>();
            for (TestCaseBinding binding : testCaseBindings) {
                if (binding == null) continue;
                bindingLines.add(JsonUtil.toJson((Object)binding, (boolean)false));
            }
            if (!bindingLines.isEmpty()) {
                FileUtils.writeLines((File)bindingFile, (String)"UTF-8", bindingLines);
            }
        }
        return bindingFile;
    }

    private String createTestCaseBinding() throws ExecutionException {
        TestCaseEntity testCase = this.testCaseExecution.getTestCase();
        StringBuilder bindingBuilder = new StringBuilder();
        StringBuilder syntaxErrorCollector = new StringBuilder();
        String testCaseId = testCase.getRelativePathForUI().replace(File.separator, "/");
        bindingBuilder.append("new TestCaseBinding('" + testCaseId + "',");
        StringBuilder variableBinding = new StringBuilder();
        if (testCase instanceof WSVerificationTestCaseEntity) {
            variableBinding.append("[");
            List variables = testCase.getVariables();
            if (variables.size() > 0) {
                int i = 0;
                while (i < variables.size()) {
                    if (i >= 1) {
                        variableBinding.append(", ");
                    }
                    VariableEntity variable = (VariableEntity)variables.get(i);
                    variableBinding.append(String.format("'%s': %s", variable.getName(), variable.getDefaultValue()));
                    ++i;
                }
            } else {
                variableBinding.append(":");
            }
            variableBinding.append("]");
        } else {
            variableBinding.append("[:]");
        }
        bindingBuilder.append((CharSequence)variableBinding).append(")");
        if (syntaxErrorCollector.toString().isEmpty()) {
            return bindingBuilder.toString();
        }
        throw new ExecutionException(syntaxErrorCollector.toString());
    }
}

