/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.capability.exception.UnsupportedDriverTypeException;
import com.katalon.capability.manager.ICapabilityManager;
import com.katalon.capability.manager.ICustomCapabilityManager;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.katalon.capability.model.ICapabilitySetting;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.ExecutionEventConfiguration;
import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionPlan;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.ExecutionManager;
import com.katalon.execution.services.kre.KRELogPrinter;
import com.katalon.execution.services.planner.TestSuiteExecutionPlanner;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.controller.FilterController;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.dal.exception.DALException;
import com.kms.katalon.entity.IExecutableEntity;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.groovy.util.GroovyUtil;
import com.kms.katalon.license.ConsoleLicenseService;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteCollectionExecutionPlanner {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteCollectionExecutionPlanner.class);
    private final ExecutionManager manager;
    private final ICapabilityManager capabilityManager;
    private final ICustomCapabilityManager customCapabilityManager;
    private final TestSuiteCollectionExecution tscExecution;
    private final TestExecutionRequest testExecutionRequest;

    public TestSuiteCollectionExecutionPlanner(ExecutionManager manager, ICapabilityManager capabilityManager, ICustomCapabilityManager customCapabilityManager, TestSuiteCollectionExecution tscExecution, TestExecutionRequest testExecutionRequest) {
        this.manager = manager;
        this.capabilityManager = capabilityManager;
        this.customCapabilityManager = customCapabilityManager;
        this.tscExecution = tscExecution;
        this.testExecutionRequest = testExecutionRequest;
    }

    public void planTestSuiteExecutions() throws ExecutionException {
        KREOverridingConfiguration kreOverridingConfiguration = this.testExecutionRequest != null ? this.testExecutionRequest.getKreOverridingConfiguration() : null;
        String testSuiteColQuery = kreOverridingConfiguration != null ? kreOverridingConfiguration.getTestSuiteColQuery() : "";
        ExecutionProfileEntity overridingProfile = kreOverridingConfiguration != null ? kreOverridingConfiguration.getExecutionProfile() : null;
        ICapabilitySetting overridingCapability = kreOverridingConfiguration != null ? kreOverridingConfiguration.getCapability() : null;
        String executionUUID = this.tscExecution.getExecutionUUID();
        TestSuiteCollectionEntity tscEntity = this.tscExecution.getTestSuiteCollection();
        String executionSessionId = this.tscExecution.getExecutionSessionId();
        ProjectEntity project = tscEntity.getProject();
        Path projectFolderPath = Path.of(project.getFolderLocation(), new String[0]);
        ReportController reportController = ReportController.getInstance();
        ArrayList<ExecutionSettings> executionSettingsList = new ArrayList<ExecutionSettings>();
        try {
            ReportCollectionEntity reportCollection = reportController.newReportCollection(project, tscEntity, executionSessionId, executionSessionId);
            List<TestSuiteRunConfiguration> filteredByQueryTsRunConfigs = this.filterByQuery(tscEntity.getTestSuiteRunConfigurations(), testSuiteColQuery);
            List<TestSuiteRunConfiguration> filteredByQueryAndLicenseTsRunConfigs = this.filterByKREValidLicense(filteredByQueryTsRunConfigs);
            List<TestSuiteRunConfiguration> tsRunConfigsWithInvalidLicense = filteredByQueryTsRunConfigs.stream().filter(ts -> !filteredByQueryAndLicenseTsRunConfigs.contains(ts)).collect(Collectors.toList());
            if (this.testExecutionRequest.getRunningMode().isConsole() && !tsRunConfigsWithInvalidLicense.isEmpty()) {
                KRELogPrinter.printTestSuiteConfigsWithInvalidLicense(tscEntity.getName(), tsRunConfigsWithInvalidLicense, overridingCapability);
            }
            logger.info("Planning {} test suite executions for test suite collection: {}", (Object)filteredByQueryAndLicenseTsRunConfigs.size(), (Object)tscEntity.getName());
            for (TestSuiteRunConfiguration tsRunConfig : filteredByQueryAndLicenseTsRunConfigs) {
                TestExecutionRequest executionRequestForSingleTestSuite = this.buildTestExecutionRequestForSingleTestSuite(project, executionSessionId, tsRunConfig, overridingProfile, overridingCapability, kreOverridingConfiguration);
                ExecutionSettings tsExecutionSettings = this.manager.initializeSettings(executionRequestForSingleTestSuite);
                executionSettingsList.add(tsExecutionSettings);
                String reportEntityId = projectFolderPath.relativize(tsExecutionSettings.getExecutionDirPath()).toString().replace(File.separator, "/");
                reportCollection.getReportItemDescriptions().add(ReportItemDescription.from((String)reportEntityId, (RunConfigurationDescription)tsRunConfig.getConfiguration()));
                this.manager.writeExecutionSettingsToFile(tsExecutionSettings);
            }
            try {
                ReportController.getInstance().updateReportCollection(reportCollection);
            }
            catch (DALException e) {
                logger.error("Failed to update report collection with new report item", (Throwable)e);
            }
            TestExecutionPlan plan = new TestExecutionPlan();
            plan.setExecution((EntityExecution)this.tscExecution);
            int index = 0;
            for (ExecutionSettings executionSettings : executionSettingsList) {
                TestSuiteExecution testSuiteExecution = new TestSuiteExecution(executionSettings, Optional.of(index));
                TestSuiteExecutionAttempt firstAttempt = new TestSuiteExecutionAttempt(executionSettings, executionUUID);
                TestSuiteExecutionPlanner testSuitePlanner = new TestSuiteExecutionPlanner(firstAttempt);
                testSuitePlanner.planTestCaseExecutions();
                firstAttempt.onPlanChanged();
                testSuiteExecution.addNewAttempt(firstAttempt);
                testSuiteExecution.onPlanChanged();
                IFolder scriptFolder = GroovyUtil.getCustomKeywordLibFolder((ProjectEntity)project);
                try {
                    File scriptFile = testSuitePlanner.generateScriptFile(scriptFolder);
                    IFile iScriptFile = GroovyUtil.getTempScriptIFile((File)scriptFile, (ProjectEntity)project);
                    executionSettings.setScriptFile(iScriptFile);
                }
                catch (Exception e) {
                    throw new ExecutionException("Failed to generate script file for test suite execution", (Throwable)e);
                }
                this.tscExecution.addTestSuiteExecution(testSuiteExecution);
                ++index;
            }
            this.tscExecution.onPlanChanged();
            if (this.testExecutionRequest.getRunningMode().isConsole()) {
                KRELogPrinter.printRetrySettings(this.tscExecution);
            }
        }
        catch (ExecutionException | DALException e) {
            logger.error("Failed to plan test suite collection execution", e);
            executionSettingsList.clear();
            if (e instanceof ExecutionException) {
                ExecutionException ee = (ExecutionException)e;
                throw ee;
            }
            throw new ExecutionException("Failed to plan test suite collection execution", e);
        }
    }

    private List<TestSuiteRunConfiguration> filterByQuery(List<TestSuiteRunConfiguration> originalList, String testSuiteColQuery) {
        if (StringUtils.isBlank((CharSequence)testSuiteColQuery)) {
            return originalList.stream().filter(ts -> ts.isRunEnabled()).collect(Collectors.toList());
        }
        if (FilterController.getInstance().isIndexsFilter(testSuiteColQuery)) {
            List filteredByIndex = FilterController.getInstance().filterByIndex(originalList, testSuiteColQuery);
            return originalList.stream().filter(ts -> ts.isRunEnabled()).filter(ts -> filteredByIndex.contains(ts)).collect(Collectors.toList());
        }
        return originalList.stream().filter(ts -> ts.isRunEnabled()).filter(ts -> FilterController.getInstance().isMatched((FileEntity)ts.getTestSuiteEntity(), testSuiteColQuery)).collect(Collectors.toList());
    }

    private List<TestSuiteRunConfiguration> filterByKREValidLicense(List<TestSuiteRunConfiguration> originalList) {
        if (!this.testExecutionRequest.getRunningMode().isConsole()) {
            return originalList;
        }
        ConsoleLicenseService licenseService = ConsoleLicenseService.getInstance();
        return originalList.stream().filter(ts -> licenseService.isValidRunConfig(ts.getConfiguration().getRunConfigurationId())).collect(Collectors.toList());
    }

    private TestExecutionRequest buildTestExecutionRequestForSingleTestSuite(ProjectEntity project, String parentExecutionSessionId, TestSuiteRunConfiguration tsRunConfig, ExecutionProfileEntity overridingProfile, ICapabilitySetting overridingCapability, KREOverridingConfiguration kreOverridingConfiguration) throws ExecutionException {
        DriverConfiguration driverConfig;
        String contributorId;
        ExecutionProfileEntity executionProfile;
        TestSuiteEntity testSuiteEntity = tsRunConfig.getTestSuiteEntity();
        String tsDriverName = tsRunConfig.getConfiguration().getRunConfigurationId();
        if (overridingProfile != null) {
            executionProfile = overridingProfile;
        } else {
            String executionProfileName = tsRunConfig.getConfiguration().getProfileName();
            try {
                executionProfile = GlobalVariableController.getInstance().getExecutionProfile(executionProfileName, project);
            }
            catch (ControllerException e) {
                throw new ExecutionException("Cannot get execution profile: " + executionProfileName + " for project: " + project.getName(), (Throwable)e);
            }
        }
        ICapabilitySetting capabilitySetting = null;
        String finalDriverName = "";
        boolean isCustomCapability = false;
        IRunConfigurationContributor runConfigContributor = RunConfigurationCollector.getInstance().getRunContributor(tsDriverName);
        if (overridingCapability != null) {
            capabilitySetting = overridingCapability;
            finalDriverName = capabilitySetting.getDisplayName();
            isCustomCapability = capabilitySetting instanceof CustomCapabilitySetting;
        } else if (runConfigContributor instanceof CustomRunConfigurationContributor) {
            CustomCapabilitySetting customCapabilitySetting = this.findCustomCapability(tsDriverName);
            if (customCapabilitySetting == null) {
                throw new ExecutionException("Cannot find custom capability with name: " + tsDriverName);
            }
            capabilitySetting = customCapabilitySetting;
            finalDriverName = capabilitySetting.getDisplayName();
            isCustomCapability = true;
        } else {
            Pair<ICapabilitySetting, String> pair;
            try {
                pair = this.manager.resolveDriverSetting(tsDriverName);
            }
            catch (UnsupportedDriverTypeException e) {
                throw new ExecutionException("Cannot resolve driver setting for driver: " + tsDriverName, (Throwable)e);
            }
            capabilitySetting = (ICapabilitySetting)pair.getLeft();
            finalDriverName = (String)pair.getRight();
        }
        String string = contributorId = isCustomCapability ? tsDriverName : finalDriverName;
        if (runConfigContributor == null || !runConfigContributor.getId().equals(contributorId)) {
            runConfigContributor = RunConfigurationCollector.getInstance().getRunContributor(contributorId);
        }
        if (runConfigContributor == null) {
            throw new ExecutionException("No run configuration contributor found for driver: " + contributorId);
        }
        try {
            IRunConfiguration legacyConfig = runConfigContributor.getRunConfiguration(project.getFolderLocation(), tsRunConfig.getConfiguration());
            driverConfig = this.manager.createDriverConfigurationFromLegacyConfig(legacyConfig);
        }
        catch (Exception e) {
            throw new ExecutionException("Cannot build run configuration for driver: " + contributorId + " in test suite: " + testSuiteEntity.getName(), (Throwable)e);
        }
        TestExecutionRequest request = TestExecutionRequest.builder().entity((IExecutableEntity)testSuiteEntity).capability(capabilitySetting).launchMode(this.testExecutionRequest.getLaunchMode()).runningMode(this.testExecutionRequest.getRunningMode()).executionProfile(executionProfile).driverConfiguration(driverConfig).parentExecutionSessionId(Optional.of(parentExecutionSessionId)).kreOverridingConfiguration(kreOverridingConfiguration).eventConfiguration(ExecutionEventConfiguration.executionConfig((RunningMode)this.testExecutionRequest.getRunningMode())).build();
        return request;
    }

    private CustomCapabilitySetting findCustomCapability(String capabilityName) {
        if (this.customCapabilityManager == null) {
            return null;
        }
        return this.customCapabilityManager.getAllCustomCapabilities().stream().filter(cap -> cap.getName().equals(capabilityName)).findFirst().orElse(null);
    }
}

