/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.factory.IReportIntegrationProviderFactory;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.reporting.TestReportEmailSending;
import com.katalon.execution.model.steps.reporting.TestReportGeneration;
import com.katalon.execution.model.steps.reporting.TestReportIntegration;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.services.IReportIntegrationProvider;
import com.katalon.execution.services.planner.EmailConfigBuilder;
import com.katalon.execution.services.planner.TestSuiteReportPlanner;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.setting.ReportSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureManager;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteCollectionReportPlanner {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteCollectionReportPlanner.class);
    private final IFeatureManager featureManager;
    private final IReportIntegrationProviderFactory reportIntegrationProviderFactory;
    private final TestExecutionRequest testExecutionRequest;
    private final TestSuiteCollectionExecution tscExecution;

    public TestSuiteCollectionReportPlanner(TestExecutionRequest testExecutionRequest, IFeatureManager featureManager, IReportIntegrationProviderFactory reportIntegrationProviderFactory, TestSuiteCollectionExecution tscExecution) {
        this.testExecutionRequest = testExecutionRequest;
        this.featureManager = featureManager;
        this.reportIntegrationProviderFactory = reportIntegrationProviderFactory;
        this.tscExecution = tscExecution;
    }

    public TestReportingPhase createPlan() throws ExecutionException {
        TestReportingPhase reportingPhase = new TestReportingPhase();
        for (TestSuiteExecution tsExecution : this.tscExecution.getTestSuiteExecutions()) {
            TestSuiteReportPlanner tsReportPlanner = new TestSuiteReportPlanner(this.testExecutionRequest, this.reportIntegrationProviderFactory, tsExecution);
            TestReportingPhase tsReportingPhase = tsReportPlanner.createPlan();
            for (TestExecutionStep child : tsReportingPhase.getChildren()) {
                reportingPhase.addChild(child);
            }
        }
        this.planReportGenerationSteps(reportingPhase);
        this.planReportIntegrationSteps(reportingPhase);
        this.planEmailSendingStep(reportingPhase);
        return reportingPhase;
    }

    private void planReportGenerationSteps(TestReportingPhase reportingPhase) throws ExecutionException {
        ReportSettings reportSettings;
        ReportSettingStore reportSettingStore = ReportSettingStore.getStore();
        try {
            reportSettings = reportSettingStore.getSettings();
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to load report settings", (Throwable)e);
        }
        if (this.featureManager.canUse(ProductFeature.EXPORT_JUNIT_REPORT)) {
            reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.tscExecution, TestReportGeneration.ReportFormat.JUNIT, reportSettings));
        }
        if (this.featureManager.canUse(ProductFeature.AUTO_EXPORT_TEST_SUITE_COLLECTION_HTML) && this.safeCheckReportFormatEnabled(() -> reportSettingStore.useGenerateHTML())) {
            reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.tscExecution, TestReportGeneration.ReportFormat.HTML_TSC, reportSettings));
        }
    }

    private void planReportIntegrationSteps(TestReportingPhase reportingPhase) {
        KREOverridingConfiguration kreOverridingConfiguration = this.testExecutionRequest.getKreOverridingConfiguration();
        Map additionalInfo = kreOverridingConfiguration != null ? kreOverridingConfiguration.getAdditionalInfo() : null;
        Set integrationEntrySet = ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet();
        for (Map.Entry integrationEntry : integrationEntrySet) {
            IReportIntegrationProvider provider = this.reportIntegrationProviderFactory.getProvider((String)integrationEntry.getKey(), (ReportIntegrationContribution)integrationEntry.getValue());
            provider.fetchRemoteSettings();
            IReportIntegrationProvider.Result scheduleResult = provider.shouldScheduleForTestSuiteCollection(this.tscExecution);
            if (!scheduleResult.willDo()) continue;
            reportingPhase.addChild((TestExecutionStep)new TestReportIntegration((EntityExecution)this.tscExecution, provider, additionalInfo));
        }
    }

    private void planEmailSendingStep(TestReportingPhase reportingPhase) throws ExecutionException {
        EmailConfig emailConfig = new EmailConfigBuilder().build(this.testExecutionRequest);
        if (emailConfig == null || !this.featureManager.canUse(ProductFeature.TEST_SUITE_COLLECTION_EXECUTION_EMAIL) || !emailConfig.isSendTestSuiteCollectionReportEnabled()) {
            return;
        }
        reportingPhase.addChild((TestExecutionStep)new TestReportEmailSending.TestSuiteCollectionReportEmailSending((EntityExecution)this.tscExecution, emailConfig));
    }

    private boolean safeCheckReportFormatEnabled(Callable<Boolean> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            logger.error("Error when checking report format enabled", (Throwable)e);
            return false;
        }
    }

    public TestExecutionRequest getTestExecutionRequest() {
        return this.testExecutionRequest;
    }
}

