/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.RunConfigurationProperties;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.planner.TestCaseBindingBuilder;
import com.katalon.execution.services.templates.GenerateTestSuiteScriptRequest;
import com.katalon.platform.api.exception.ResourceException;
import com.katalon.platform.api.extension.DynamicQueryingTestSuiteDescription;
import com.kms.katalon.controller.FilterController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.testcase.TestCaseBinding;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.platform.DynamicQueryingTestSuiteExtensionProvider;
import com.kms.katalon.execution.platform.ExecutionPlatformServiceProvider;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteExecutionPlanner {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteExecutionPlanner.class);
    private static final String TEMPLATE_CLASS_NAME = "com.katalon.execution.services.templates.TestSuiteScriptTemplate";
    private static final String GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME = "generateTestSuiteScriptFile";
    private final TestSuiteExecutionAttempt testSuiteExecutionAttempt;
    private final TestExecutionRequest testExecutionRequest;

    public TestSuiteExecutionPlanner(TestSuiteExecutionAttempt testSuiteExecutionAttempt, TestExecutionRequest testExecutionRequest) {
        this.testSuiteExecutionAttempt = testSuiteExecutionAttempt;
        this.testExecutionRequest = testExecutionRequest;
    }

    public TestSuiteExecutionPlanner(TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        this.testSuiteExecutionAttempt = testSuiteExecutionAttempt;
        this.testExecutionRequest = null;
    }

    public void planTestCaseExecutions() throws com.katalon.execution.exception.ExecutionException {
        TestSuiteEntity testSuiteEntity = this.testSuiteExecutionAttempt.getTestSuite();
        KREOverridingConfiguration kreOverridingConfiguration = this.testExecutionRequest != null ? this.testExecutionRequest.getKreOverridingConfiguration() : null;
        String testSuiteQuery = kreOverridingConfiguration != null ? kreOverridingConfiguration.getTestSuiteQuery() : "";
        testSuiteQuery = (String)StringUtils.defaultIfEmpty((CharSequence)testSuiteQuery, (CharSequence)"");
        if (testSuiteEntity instanceof FilteringTestSuiteEntity) {
            FilteringTestSuiteEntity filteringTestSuite = (FilteringTestSuiteEntity)testSuiteEntity;
            List<TestCaseEntity> filteredTestCases = null;
            try {
                filteredTestCases = this.loadTestCasesOfDynamicTestSuite(filteringTestSuite, testSuiteQuery);
            }
            catch (Exception e) {
                throw new com.katalon.execution.exception.ExecutionException("Failed to load test cases of dynamic test suite: " + String.valueOf(testSuiteEntity), (Throwable)e);
            }
            for (TestCaseEntity testCase : filteredTestCases) {
                if (!this.isDataBindingEnabled(testCase)) {
                    this.testSuiteExecutionAttempt.addTestCase(testCase);
                    continue;
                }
                try {
                    List<TestCaseBinding> testCaseBindings = TestCaseBindingBuilder.buildForTestCase(testCase);
                    this.testSuiteExecutionAttempt.addTestCaseBinding(testCase, testCaseBindings, TestSuiteExecutionAttempt.BindingLevel.TEST_CASE_LEVEL);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to prepare data binding execution for test case: " + testCase.getIdForDisplay(), e);
                }
            }
            return;
        }
        List allTestCaseLinks = TestSuiteController.getInstance().getTestSuiteTestCaseRun(testSuiteEntity);
        for (TestSuiteTestCaseLink testCaseLink : allTestCaseLinks) {
            TestCaseEntity testCase = null;
            try {
                testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLink.getTestCaseId());
            }
            catch (Exception e) {
                logger.error("Failed to get test case with id: " + testCaseLink.getTestCaseId(), (Throwable)e);
            }
            if (testCase == null) {
                throw new IllegalArgumentException(MessageFormat.format(StringConstants.UTIL_EXC_TEST_CASE_X_NOT_FOUND, testCaseLink.getTestCaseId()));
            }
            if (StringUtils.isNotBlank((CharSequence)testSuiteQuery) && !FilterController.getInstance().isMatched((FileEntity)testCase, testSuiteQuery)) continue;
            try {
                if (testCaseLink.isUsingDataBindingAtTestSuiteLevel()) {
                    List testDataLinks = TestSuiteController.getInstance().getTestDataLinkUsedInTestCase(testCaseLink);
                    if (testDataLinks.isEmpty()) {
                        this.testSuiteExecutionAttempt.addTestCase(testCase);
                        continue;
                    }
                    List<TestCaseBinding> testCaseBindings = TestCaseBindingBuilder.buildForTestCaseInTestSuite(testCaseLink, testSuiteEntity, testDataLinks);
                    this.testSuiteExecutionAttempt.addTestCaseBinding(testCase, testCaseBindings, TestSuiteExecutionAttempt.BindingLevel.TEST_SUITE_LEVEL);
                    continue;
                }
                if (!this.isDataBindingEnabled(testCase)) {
                    this.testSuiteExecutionAttempt.addTestCase(testCase);
                    continue;
                }
                List<TestCaseBinding> testCaseBindings = TestCaseBindingBuilder.buildForTestCase(testCase);
                this.testSuiteExecutionAttempt.addTestCaseBinding(testCase, testCaseBindings, TestSuiteExecutionAttempt.BindingLevel.TEST_CASE_LEVEL);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to prepare data binding execution for test case: " + testCase.getIdForDisplay(), e);
            }
        }
    }

    public void planTestCaseExecutionsForRetry(TestSuiteExecutionAttempt previousAttempt, Predicate<BaseTestCaseExecution> shouldRetry) throws com.katalon.execution.exception.ExecutionException {
        for (BaseTestCaseExecution bastTestCaseExecution : previousAttempt.getTestCaseExecutions()) {
            if (!shouldRetry.test(bastTestCaseExecution)) continue;
            if (bastTestCaseExecution instanceof TestCaseExecution) {
                TestCaseExecution testCaseExecution = (TestCaseExecution)bastTestCaseExecution;
                this.testSuiteExecutionAttempt.addTestCase(testCaseExecution.getTestCase());
                continue;
            }
            if (!(bastTestCaseExecution instanceof TestCaseBindingExecution)) continue;
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)bastTestCaseExecution;
            Set retriedTestCaseExecutionIds = testCaseBindingExecution.getIterations().stream().filter(shouldRetry::test).map(iteration -> iteration.getId()).collect(Collectors.toSet());
            List<TestCaseBinding> retriedBindings = testCaseBindingExecution.getTestCaseBindings().stream().filter(binding -> retriedTestCaseExecutionIds.contains(binding.getTestCaseExecutionId())).map(binding -> {
                TestCaseBinding clonedBinding = new TestCaseBinding(binding.getTestCaseName(), binding.getTestCaseId(), binding.getBindedValues());
                clonedBinding.setIterationVariableName(binding.getIterationVariableName());
                clonedBinding.setTestCaseExecutionId(UUID.randomUUID());
                return clonedBinding;
            }).toList();
            this.testSuiteExecutionAttempt.addTestCaseBinding(testCaseBindingExecution.getTestCase(), retriedBindings, previousAttempt.getBindingLevel());
        }
    }

    private boolean isDataBindingEnabled(TestCaseEntity testCaseEntity) {
        if (testCaseEntity == null) {
            return false;
        }
        return !TestCaseController.getInstance().isNotUsingDataBinding(testCaseEntity);
    }

    private List<TestCaseEntity> loadTestCasesOfDynamicTestSuite(FilteringTestSuiteEntity testSuite, String testSuiteQuery) throws ResourceException, ExecutionException {
        DynamicQueryingTestSuiteExtensionProvider dynamicQueryingTestSuiteProvider = (DynamicQueryingTestSuiteExtensionProvider)ExecutionPlatformServiceProvider.getInstance().getPlatformService(DynamicQueryingTestSuiteExtensionProvider.class);
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        DynamicQueryingTestSuiteDescription selectedQueryingDescription = dynamicQueryingTestSuiteProvider.getSelectedDynamicQueryingDescription(project, testSuite);
        String finalTestSuiteQuery = (String)StringUtils.defaultIfEmpty((CharSequence)testSuiteQuery, (CharSequence)testSuite.getFilteringText());
        List filteredTestCases = dynamicQueryingTestSuiteProvider.getFilteredTestCases(project, testSuite, selectedQueryingDescription, finalTestSuiteQuery);
        return filteredTestCases;
    }

    public File generateScriptFile(IFolder scriptFolder) throws IOException, CoreException, ReflectiveOperationException {
        String fileName = this.testSuiteExecutionAttempt.buildScriptFileName();
        Path filePath = scriptFolder.getRawLocation().toFile().toPath().resolve(fileName);
        this.deleteFileIfExists(filePath);
        File scriptFile = Files.createFile(filePath, new FileAttribute[0]).toFile();
        GroovyObject template = (GroovyObject)Class.forName(TEMPLATE_CLASS_NAME).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ExecutionSettings executionSettings = this.testSuiteExecutionAttempt.getExecutionSettings();
        RunConfigurationProperties runConfigProps = executionSettings.getRunConfiguration();
        TestSuiteRerunSettings testSuiteRerunSettings = executionSettings.getTestSuiteRerunSettings();
        File dataBindingFile = this.createTestCaseBindingFile();
        GenerateTestSuiteScriptRequest generateRequest = new GenerateTestSuiteScriptRequest();
        generateRequest.setTestSuiteId(runConfigProps.getEntityId());
        generateRequest.setExecutionSettingsFilePath(executionSettings.getSettingsFilePath().toAbsolutePath().toString());
        generateRequest.setTestCaseBindingFilePath(dataBindingFile.getAbsolutePath().toString());
        HashMap<String, Object> testSuiteAttributes = new HashMap<String, Object>();
        testSuiteAttributes.put("id", generateRequest.getTestSuiteId());
        testSuiteAttributes.put("name", runConfigProps.getEntityName());
        testSuiteAttributes.put("description", runConfigProps.getEntityDescription());
        testSuiteAttributes.put("rerunTestFailImmediately", testSuiteRerunSettings.shouldRerunTestFailImmediately());
        testSuiteAttributes.put("retryCount", testSuiteRerunSettings.getMaxRetryCount());
        generateRequest.setTestSuiteAttributes(testSuiteAttributes);
        template.invokeMethod(GENERATED_TEST_SUITE_SCRIPT_METHOD_NAME, (Object)new Object[]{scriptFile, generateRequest});
        scriptFolder.refreshLocal(1, null);
        return scriptFile;
    }

    private File createTestCaseBindingFile() throws IOException {
        Path filePath = this.testSuiteExecutionAttempt.getExecutionSettings().getExecutionDirPath().resolve("testCaseBinding");
        File bindingFile = Files.createFile(filePath, new FileAttribute[0]).toFile();
        for (TestCaseBinding binding : this.testSuiteExecutionAttempt.getTestCaseBindings()) {
            String bindingJson = JsonUtil.toJson((Object)binding, (boolean)false);
            FileUtils.writeLines((File)bindingFile, List.of(bindingJson), (boolean)true);
        }
        return bindingFile;
    }

    private void deleteFileIfExists(Path path) {
        try {
            Files.deleteIfExists(path);
        }
        catch (Exception e) {
            logger.warn("Failed to delete file: " + path.toString(), (Throwable)e);
        }
    }
}

