/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.planner;

import com.katalon.execution.dto.request.KREOverridingConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.factory.IReportIntegrationProviderFactory;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.reporting.TestReportCopy;
import com.katalon.execution.model.steps.reporting.TestReportEmailSending;
import com.katalon.execution.model.steps.reporting.TestReportGeneration;
import com.katalon.execution.model.steps.reporting.TestReportIntegration;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.services.IReportIntegrationProvider;
import com.katalon.execution.services.planner.EmailConfigBuilder;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.ReportLocationSetting;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.setting.ReportSettingStore;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteReportPlanner {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteReportPlanner.class);
    private final IReportIntegrationProviderFactory reportIntegrationProviderFactory;
    private final TestExecutionRequest testExecutionRequest;
    private final TestSuiteExecution testSuiteExecution;

    public TestSuiteReportPlanner(TestExecutionRequest testExecutionRequest, IReportIntegrationProviderFactory reportIntegrationProviderFactory, TestSuiteExecution testSuiteExecution) {
        this.testExecutionRequest = testExecutionRequest;
        this.reportIntegrationProviderFactory = reportIntegrationProviderFactory;
        this.testSuiteExecution = testSuiteExecution;
    }

    public TestReportingPhase createPlan() throws ExecutionException {
        TestReportingPhase reportingPhase = new TestReportingPhase();
        this.planReportGenerationSteps(reportingPhase);
        this.planReportIntegrationSteps(reportingPhase);
        this.planEmailSendingStep(reportingPhase);
        return reportingPhase;
    }

    private void planReportGenerationSteps(TestReportingPhase reportingPhase) throws ExecutionException {
        ReportLocationSetting reportLocationSetting;
        KREOverridingConfiguration kreOverridingConfiguration;
        ReportSettings reportSettings;
        ReportSettingStore reportSettingStore = ReportSettingStore.getStore();
        try {
            reportSettings = reportSettingStore.getSettings();
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to load report settings", (Throwable)e);
        }
        reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.testSuiteExecution, TestReportGeneration.ReportFormat.JUNIT, reportSettings));
        if (this.safeCheckReportFormatEnabled(() -> reportSettingStore.useGenerateHTML())) {
            reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.testSuiteExecution, TestReportGeneration.ReportFormat.HTML_TEST_SUITE, reportSettings));
        }
        if (this.safeCheckReportFormatEnabled(() -> reportSettingStore.useGenerateCSV())) {
            reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.testSuiteExecution, TestReportGeneration.ReportFormat.CSV, reportSettings));
        }
        if (this.safeCheckReportFormatEnabled(() -> reportSettingStore.useGeneratePDF())) {
            reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.testSuiteExecution, TestReportGeneration.ReportFormat.PDF, reportSettings));
        }
        if (this.safeCheckReportFormatEnabled(() -> reportSettingStore.useGenerateConsoleLog())) {
            reportingPhase.addChild((TestExecutionStep)new TestReportGeneration((EntityExecution)this.testSuiteExecution, TestReportGeneration.ReportFormat.CONSOLE_LOG, reportSettings));
        }
        if ((kreOverridingConfiguration = this.testExecutionRequest.getKreOverridingConfiguration()) != null && kreOverridingConfiguration.getReportLocationSetting() != null && (reportLocationSetting = kreOverridingConfiguration.getReportLocationSetting()) != null && reportLocationSetting.isReportFolderPathSet()) {
            reportingPhase.addChild((TestExecutionStep)new TestReportCopy((EntityExecution)this.testSuiteExecution, reportLocationSetting));
        }
    }

    private void planReportIntegrationSteps(TestReportingPhase reportingPhase) {
        KREOverridingConfiguration kreOverridingConfiguration = this.testExecutionRequest.getKreOverridingConfiguration();
        Map additionalInfo = kreOverridingConfiguration != null ? kreOverridingConfiguration.getAdditionalInfo() : null;
        Set integrationEntrySet = ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet();
        for (Map.Entry integrationEntry : integrationEntrySet) {
            IReportIntegrationProvider provider = this.reportIntegrationProviderFactory.getProvider((String)integrationEntry.getKey(), (ReportIntegrationContribution)integrationEntry.getValue());
            provider.fetchRemoteSettings();
            IReportIntegrationProvider.Result scheduleResult = provider.shouldScheduleForTestSuite(this.testSuiteExecution);
            if (!scheduleResult.willDo()) continue;
            reportingPhase.addChild((TestExecutionStep)new TestReportIntegration((EntityExecution)this.testSuiteExecution, provider, additionalInfo));
        }
    }

    private void planEmailSendingStep(TestReportingPhase reportingPhase) throws ExecutionException {
        EmailConfig emailConfig = new EmailConfigBuilder().build(this.testExecutionRequest);
        if (emailConfig == null || !emailConfig.canSend() || !emailConfig.isSendTestSuiteReportEnabled()) {
            return;
        }
        if (this.testSuiteExecution.isPartOfCollection() && emailConfig.isSendTestSuiteCollectionReportEnabled() && emailConfig.isSkipInvidiualTestSuiteReport()) {
            logger.info("Skipping email sending for test suite '{}' because it is part of a test suite collection", (Object)this.testSuiteExecution.getName());
            return;
        }
        reportingPhase.addChild((TestExecutionStep)new TestReportEmailSending.TestSuiteReportEmailSending((EntityExecution)this.testSuiteExecution, emailConfig));
    }

    private boolean safeCheckReportFormatEnabled(Callable<Boolean> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            logger.error("Error when checking report format enabled", (Throwable)e);
            return false;
        }
    }
}

