/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.reporting;

import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.report.IReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteCollectionReportDataSource;
import com.katalon.execution.model.report.LegacyTestSuiteReportDataSource;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.services.IReportIntegrationProvider;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import java.util.Map;

public abstract class ReportIntegrationProvider
implements IReportIntegrationProvider {
    protected final ReportIntegrationContribution contribution;

    protected ReportIntegrationProvider(ReportIntegrationContribution contribution) {
        this.contribution = contribution;
    }

    public void uploadExecutionResult(IReportDataSource dataSource) throws Exception {
        if (dataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)dataSource;
            this.contribution.uploadTestSuiteResult(legacyDataSource.getTestSuiteLogRecord());
            return;
        }
        if (dataSource instanceof LegacyTestSuiteCollectionReportDataSource) {
            LegacyTestSuiteCollectionReportDataSource legacyCollectionDataSource = (LegacyTestSuiteCollectionReportDataSource)dataSource;
            this.contribution.uploadTestSuiteCollectionResult(legacyCollectionDataSource.getTestSuiteCollectionLogRecord());
            return;
        }
        throw new UnsupportedOperationException("Unsupported data source type: " + dataSource.getClass().getName());
    }

    public String buildFriendlyErrorMessage(Exception e) {
        return this.contribution.extractIntegrationExceptionMessage((Throwable)e);
    }

    public IReportIntegrationProvider.Result shouldGenerateReportForTestSuite(TestSuiteExecution testSuiteExecution) {
        if (this.contribution.shouldUploadReportWhenIncomplete()) {
            return IReportIntegrationProvider.Result.ok();
        }
        if (testSuiteExecution.getExecutionJobStatus() != ExecutionJobStatus.COMPLETED) {
            return IReportIntegrationProvider.Result.skipped();
        }
        return IReportIntegrationProvider.Result.ok();
    }

    public IReportIntegrationProvider.Result shouldGenerateReportForTestSuiteCollection(TestSuiteCollectionExecution tscExecution) {
        return IReportIntegrationProvider.Result.ok();
    }

    public void enrichDataSourceBeforeUpload(IReportDataSource dataSource, Map<String, String> additionalInfo) {
        if (dataSource instanceof LegacyTestSuiteReportDataSource) {
            LegacyTestSuiteReportDataSource legacyDataSource = (LegacyTestSuiteReportDataSource)dataSource;
            legacyDataSource.getTestSuiteLogRecord().addBuildData(additionalInfo);
        }
    }
}

