/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.settings;

import com.katalon.capability.constant.DriverType;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.SerializableMap;
import com.katalon.execution.services.settings.MobileDriverPropertiesBuilder;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.execution.mobile.device.IosDeviceInfo;
import java.io.IOException;
import java.util.Map;

public class IosDriverPropertiesBuilder
extends MobileDriverPropertiesBuilder {
    @Override
    public DriversProperties.DriverSystemProperties buildSystemProperties(TestExecutionRequest request) throws ExecutionException {
        DriversProperties.DriverSystemProperties props = super.buildSystemProperties(request);
        props.setMobileDriverType(MobileDriverType.IOS_DRIVER);
        try {
            props.setIosDeviceConsolePath(IosDeviceInfo.getDeviceConsoleFolder().getAbsolutePath());
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to get iOS device console path.", (Throwable)e);
        }
        return props;
    }

    @Override
    public DriversProperties.DriverPreferencesProperties buildPreferencesProperties(TestExecutionRequest request) {
        DriversProperties.DriverPreferencesProperties props = new DriversProperties.DriverPreferencesProperties();
        props.setCustomProps(new SerializableMap(request.getCapability().getValue(DriverType.IOS_DRIVER)));
        return props;
    }

    @Override
    public Map<String, String> buildEnvironmentVariables(TestExecutionRequest request) throws ExecutionException {
        try {
            return IosDeviceInfo.getIosAdditionalEnvironmentVariables();
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException("Failed to build iOS driver environment variables.", (Throwable)e);
        }
    }

    @Override
    public Map<String, String> buildAdditionalInfo(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }
}

