/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.settings;

import com.katalon.capability.constant.DriverType;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.KobitonConfig;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.SerializableMap;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.integration.kobiton.entity.KobitonDevice;
import java.util.HashMap;
import java.util.Map;

public class KobitonDriverPropertiesBuilder
implements IDriverPropertiesBuilder {
    @Override
    public String buildDetailedDriverName(TestExecutionRequest request) throws ExecutionException {
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof KobitonConfig) {
            KobitonConfig kobitonConfig = (KobitonConfig)driverConfiguration;
            KobitonDevice device = kobitonConfig.getKobitonDevice();
            return request.getCapability().getDisplayName() + " - " + device.getDisplayString();
        }
        return request.getCapability().getDisplayName();
    }

    @Override
    public DriversProperties.DriverSystemProperties buildSystemProperties(TestExecutionRequest request) {
        DriversProperties.RemoteDriverSystemProperties props = new DriversProperties.RemoteDriverSystemProperties();
        props.setBrowserType(DriverType.KOBITON_WEB_DRIVER);
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof KobitonConfig) {
            KobitonConfig kobitonConfig = (KobitonConfig)driverConfiguration;
            props.setRemoteWebDriverUrl(kobitonConfig.getRemoteWebDriverUrl());
            props.setIsRemoteWebDriverUrlEncrypted(Boolean.valueOf(kobitonConfig.isRemoteWebDriverUrlEncrypted()));
            props.setRemoteWebDriverType(kobitonConfig.getRemoteWebDriverType());
            props.setRemoteMobileDriverType(kobitonConfig.getRemoteMobileDriverType());
            KobitonDevice device = kobitonConfig.getKobitonDevice();
            props.setDeviceName(device.getCapabilities().getDisplayDeviceName());
            props.setDeviceOS(device.getCapabilities().getPlatformName());
            props.setDeviceOSVersion(device.getCapabilities().getPlatformVersion());
            if (device.getCapabilities().getPlatformName().equals("iOS")) {
                props.setMobileDriverType(MobileDriverType.IOS_DRIVER);
            } else if (device.getCapabilities().getPlatformName().equals("Android")) {
                props.setMobileDriverType(MobileDriverType.ANDROID_DRIVER);
            }
        }
        return props;
    }

    @Override
    public DriversProperties.DriverPreferencesProperties buildPreferencesProperties(TestExecutionRequest request) {
        DriversProperties.DriverPreferencesProperties props = new DriversProperties.DriverPreferencesProperties();
        HashMap caps = new HashMap();
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof KobitonConfig) {
            KobitonConfig kobitonConfig = (KobitonConfig)driverConfiguration;
            caps.putAll(kobitonConfig.getKobitonDevice().toDesireCapabilitiesMap());
        }
        caps.putAll(request.getCapability().getValue(DriverType.KOBITON_WEB_DRIVER));
        props.setCustomProps(new SerializableMap(caps));
        return props;
    }

    @Override
    public Map<String, String> buildEnvironmentVariables(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }

    @Override
    public Map<String, String> buildAdditionalInfo(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }
}

