/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.settings;

import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.LocalMobileDeviceConfig;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.util.MobileExecutionUtil;

public abstract class MobileDriverPropertiesBuilder
implements IDriverPropertiesBuilder {
    @Override
    public String buildDetailedDriverName(TestExecutionRequest request) throws ExecutionException {
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof LocalMobileDeviceConfig) {
            LocalMobileDeviceConfig localMobileDeviceConfig = (LocalMobileDeviceConfig)driverConfiguration;
            MobileDeviceInfo deviceInfo = localMobileDeviceConfig.getMobileDeviceInfo();
            return request.getCapability().getDisplayName() + " - " + deviceInfo.getDeviceId();
        }
        return request.getCapability().getDisplayName();
    }

    @Override
    public DriversProperties.DriverSystemProperties buildSystemProperties(TestExecutionRequest request) throws ExecutionException {
        DriversProperties.DriverSystemProperties props = new DriversProperties.DriverSystemProperties();
        props.setAppiumDirectory(MobileExecutionUtil.findAppiumDir());
        props.setAppiumLogFile(MobileExecutionUtil.getAppiumLogFileName());
        props.setAppiumLogLevel(MobileExecutionUtil.getAppiumLogLevel());
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof LocalMobileDeviceConfig) {
            LocalMobileDeviceConfig localMobileDeviceConfig = (LocalMobileDeviceConfig)driverConfiguration;
            MobileDeviceInfo deviceInfo = localMobileDeviceConfig.getMobileDeviceInfo();
            props.setDeviceId(deviceInfo.getDeviceId());
            props.setDeviceManufacturer(deviceInfo.getDeviceManufacturer());
            props.setDeviceModel(deviceInfo.getDeviceModel());
            props.setDeviceOSVersion(deviceInfo.getDeviceOSVersion());
            props.setDeviceOS(deviceInfo.getDeviceOS());
            props.setDeviceName(deviceInfo.getDeviceName());
        }
        return props;
    }
}

