/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.settings;

import com.katalon.capability.constant.DriverType;
import com.katalon.capability.constant.RemoteDriverType;
import com.katalon.capability.model.CustomCapabilitySetting;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.RemoteDriverConfig;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.SerializableMap;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RemoteWebDriverPropertiesBuilder
implements IDriverPropertiesBuilder {
    @Override
    public String buildDetailedDriverName(TestExecutionRequest request) throws ExecutionException {
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof RemoteDriverConfig) {
            RemoteDriverConfig remoteDriverConfig = (RemoteDriverConfig)driverConfiguration;
            String remoteServerUrl = remoteDriverConfig.getRemoteWebDriverUrl();
            return request.getCapability().getDisplayName() + " - " + (String)StringUtils.defaultIfEmpty((CharSequence)remoteServerUrl, (CharSequence)"<empty server URL>");
        }
        return request.getCapability().getDisplayName();
    }

    @Override
    public DriversProperties.DriverSystemProperties buildSystemProperties(TestExecutionRequest request) {
        DriversProperties.RemoteDriverSystemProperties props = new DriversProperties.RemoteDriverSystemProperties();
        props.setBrowserType(DriverType.REMOTE_WEB_DRIVER);
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof RemoteDriverConfig) {
            RemoteDriverConfig remoteDriverConfig = (RemoteDriverConfig)driverConfiguration;
            props.setRemoteWebDriverUrl(remoteDriverConfig.getRemoteWebDriverUrl());
            props.setIsRemoteWebDriverUrlEncrypted(Boolean.valueOf(remoteDriverConfig.isRemoteWebDriverUrlEncrypted()));
            props.setRemoteWebDriverType(remoteDriverConfig.getRemoteWebDriverType());
            props.setRemoteMobileDriverType(remoteDriverConfig.getRemoteMobileDriverType());
        }
        if (request.getCapability() instanceof CustomCapabilitySetting) {
            Map capsValues = request.getCapability().getValue(DriverType.REMOTE_WEB_DRIVER);
            props.setRemoteWebDriverUrl(capsValues.get("remoteWebDriverUrl").toString());
            props.setRemoteWebDriverType(RemoteDriverType.fromDisplayName((String)((String)capsValues.get("remoteWebDriverType"))));
            props.setRemoteMobileDriverType(MobileDriverType.fromStringValue((String)((String)capsValues.get("remoteMobileDriver"))));
        }
        return props;
    }

    @Override
    public DriversProperties.DriverPreferencesProperties buildPreferencesProperties(TestExecutionRequest request) {
        DriversProperties.DriverPreferencesProperties props = new DriversProperties.DriverPreferencesProperties();
        HashMap caps = new HashMap();
        caps.putAll(request.getCapability().getValue(DriverType.REMOTE_WEB_DRIVER));
        if (request.getCapability() instanceof CustomCapabilitySetting) {
            caps.remove("remoteWebDriverUrl");
            caps.remove("remoteWebDriverType");
            caps.remove("remoteMobileDriver");
        }
        if (request.getDriverConfiguration() instanceof RemoteDriverConfig) {
            caps.remove("remoteWebDriverUrl");
            caps.remove("remoteWebDriverType");
        }
        props.setCustomProps(new SerializableMap(caps));
        return props;
    }

    @Override
    public Map<String, String> buildEnvironmentVariables(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }

    @Override
    public Map<String, String> buildAdditionalInfo(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }
}

