/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.settings;

import com.katalon.capability.constant.DriverType;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.TestCloudConfig;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.SerializableMap;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.util.TestCloudPropertyUtil;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileBrowserName;
import com.kms.katalon.testcloud.core.model.TestCloudPlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.service.ITestCloudEntity;
import com.kms.katalon.tracking.model.TestCloudRunConfigurationType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TestCloudDriverPropertiesBuilder
implements IDriverPropertiesBuilder {
    public static String TEST_CLOUD_RUN_CONFIGURATION_KEY = "testCloudRunConfiguration";
    public static String IS_USING_TEST_CLOUD_TUNNEL_KEY = "isUsingTestCloudTunnel";

    @Override
    public String buildDetailedDriverName(TestExecutionRequest request) throws ExecutionException {
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof TestCloudConfig) {
            TestCloudConfig testCloudConfig = (TestCloudConfig)driverConfiguration;
            TestCloudSessionType testCloudSessionType = testCloudConfig.getTestCloudSessionType();
            if (TestCloudSessionType.MOBILE_BROWSER.equals((Object)testCloudSessionType)) {
                TestCloudDevice entity = (TestCloudDevice)testCloudConfig.getTestCloudEntity();
                TestCloudMobileBrowserName browserName = TestCloudMobileBrowserName.UNKNOWN;
                TestCloudPlatformName platformName = entity.getPlatformName();
                if (platformName.equals((Object)TestCloudPlatformName.ANDROID)) {
                    browserName = TestCloudMobileBrowserName.CHROME;
                } else if (platformName.equals((Object)TestCloudPlatformName.IOS)) {
                    browserName = TestCloudMobileBrowserName.SAFARI;
                }
                return GlobalStringConstants.TESTCLOUD_NAME + " - " + this.getMobileDisplayName(entity, testCloudSessionType) + ", " + browserName.toString();
            }
            if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)testCloudSessionType)) {
                return GlobalStringConstants.TESTCLOUD_NAME + " - " + this.getMobileDisplayName((TestCloudDevice)testCloudConfig.getTestCloudEntity(), testCloudSessionType);
            }
            return GlobalStringConstants.TESTCLOUD_NAME + " - " + this.getDesktopDisplayName((TestCloudDesktopBrowser)testCloudConfig.getTestCloudEntity());
        }
        return request.getCapability().getDisplayName();
    }

    @Override
    public DriversProperties.DriverSystemProperties buildSystemProperties(TestExecutionRequest request) {
        DriversProperties.TestCloudDriverSystemProperties props = new DriversProperties.TestCloudDriverSystemProperties();
        props.setBrowserType(DriverType.TESTCLOUD_DRIVER);
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof TestCloudConfig) {
            TestCloudConfig testCloudConfig = (TestCloudConfig)driverConfiguration;
            props.setRemoteWebDriverUrl(testCloudConfig.getRemoteWebDriverUrl());
            props.setIsRemoteWebDriverUrlEncrypted(Boolean.valueOf(testCloudConfig.isRemoteWebDriverUrlEncrypted()));
            props.setRemoteWebDriverType(testCloudConfig.getRemoteWebDriverType());
            props.setRemoteMobileDriverType(testCloudConfig.getRemoteMobileDriverType());
            props.setTestCloudRemoteOs(testCloudConfig.getTestCloudRemoteOs());
            props.setTestCloudReadTimeout(testCloudConfig.getReadTimeout());
        }
        return props;
    }

    @Override
    public DriversProperties.DriverPreferencesProperties buildPreferencesProperties(TestExecutionRequest request) {
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof TestCloudConfig) {
            TestCloudConfig testCloudConfig = (TestCloudConfig)driverConfiguration;
            ITestCloudEntity iTestCloudEntity = testCloudConfig.getTestCloudEntity();
            if (iTestCloudEntity instanceof TestCloudDesktopBrowser) {
                TestCloudDesktopBrowser desktopBrowser = (TestCloudDesktopBrowser)iTestCloudEntity;
                DriversProperties.TestCloudDesktopBrowserPreferencesProperties props = new DriversProperties.TestCloudDesktopBrowserPreferencesProperties();
                props.setBrowserName(desktopBrowser.getBrowserName());
                props.setBrowserVersion(desktopBrowser.getBrowserVersion());
                props.setPlatformName(desktopBrowser.getOs());
                props.setKatalonOptions(new SerializableMap(testCloudConfig.getKatalonOptions()));
                HashMap otherProps = new HashMap(request.getCapability().getValue(DriverType.TESTCLOUD_DRIVER));
                otherProps.remove("katalon:options");
                otherProps.remove("browserName");
                otherProps.remove("browserVersion");
                otherProps.remove("platformName");
                props.setCustomProps(new SerializableMap(otherProps));
                return props;
            }
            ITestCloudEntity iTestCloudEntity2 = testCloudConfig.getTestCloudEntity();
            if (iTestCloudEntity2 instanceof TestCloudDevice) {
                TestCloudDevice mobileDevice = (TestCloudDevice)iTestCloudEntity2;
                DriversProperties.TestCloudMobileDevicePreferencesProperties props = new DriversProperties.TestCloudMobileDevicePreferencesProperties();
                if (testCloudConfig.getTestCloudSessionType().equals((Object)TestCloudSessionType.MOBILE_BROWSER)) {
                    String browserName = mobileDevice.getPlatformName().equals((Object)TestCloudPlatformName.ANDROID) ? "chrome" : "safari";
                    props.setBrowserName(browserName);
                    props.setBrowserVersion("latest");
                }
                props.setPlatformName(mobileDevice.getOs());
                props.setDeviceName(mobileDevice.getName());
                props.setPlatformVersion(mobileDevice.getOsVersion());
                if (mobileDevice.getCapability() != null) {
                    props.setDeviceUdid(mobileDevice.getCapability().getUdid());
                }
                props.setTestCloudOverrideMobileApplication(testCloudConfig.getTestCloudOverrideMobileApplication());
                props.setKatalonOptions(new SerializableMap(testCloudConfig.getKatalonOptions()));
                props.setKatalonOptions(new SerializableMap(testCloudConfig.getKatalonOptions()));
                HashMap otherProps = new HashMap(request.getCapability().getValue(DriverType.TESTCLOUD_DRIVER));
                otherProps.remove("katalon:options");
                otherProps.remove("browserName");
                otherProps.remove("browserVersion");
                otherProps.remove("platformName");
                otherProps.remove("appium:deviceName");
                otherProps.remove("appium:platformVersion");
                otherProps.remove("appium:udid");
                otherProps.remove("testCloudOverrideMobileApplication");
                props.setCustomProps(new SerializableMap(otherProps));
                return props;
            }
        }
        throw new IllegalArgumentException("Invalid TestCloud configuration");
    }

    @Override
    public Map<String, String> buildEnvironmentVariables(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }

    @Override
    public Map<String, String> buildAdditionalInfo(TestExecutionRequest request) throws ExecutionException {
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        DriverConfiguration driverConfiguration = request.getDriverConfiguration();
        if (driverConfiguration instanceof TestCloudConfig) {
            TestCloudConfig testCloudConfig = (TestCloudConfig)driverConfiguration;
            additionalInfo.put(IS_USING_TEST_CLOUD_TUNNEL_KEY, Boolean.toString(testCloudConfig.getTestCloudEntity().isUsingTunnel()));
            additionalInfo.put(TEST_CLOUD_RUN_CONFIGURATION_KEY, this.getTestCloudRunConfiguration(testCloudConfig));
        }
        return additionalInfo;
    }

    private String getTestCloudRunConfiguration(TestCloudConfig testCloudConfig) {
        TestCloudSessionType testCloudSessionType = testCloudConfig.getTestCloudSessionType();
        if (TestCloudSessionType.DESKTOP_BROWSER.equals((Object)testCloudSessionType)) {
            return TestCloudRunConfigurationType.DESKTOP.toString();
        }
        if (TestCloudSessionType.MOBILE_BROWSER.equals((Object)testCloudSessionType)) {
            return TestCloudRunConfigurationType.MOBILE_BROWSER.toString();
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)testCloudSessionType)) {
            return TestCloudRunConfigurationType.MOBILE_NATIVE.toString();
        }
        return "";
    }

    private String getMobileDisplayName(TestCloudDevice testCloudEntity, TestCloudSessionType sessionType) {
        if (testCloudEntity.getDisplayName() == null) {
            testCloudEntity.setDisplayName(testCloudEntity.getName());
        }
        if (TestCloudSessionType.MOBILE_NATIVE.equals((Object)sessionType)) {
            return testCloudEntity.getDisplayName() + ", version=" + testCloudEntity.getOsVersion();
        }
        return testCloudEntity.getDisplayName() + ", version=" + testCloudEntity.getOsVersion() + ", Tunnel=" + testCloudEntity.isUsingTunnel();
    }

    private String getDesktopDisplayName(TestCloudDesktopBrowser testCloudEntity) {
        if (Objects.isNull(testCloudEntity)) {
            return "";
        }
        String browserFullVersion = TestCloudPropertyUtil.getInstance().buildBrowserFullVersion(testCloudEntity.getBrowserVersion(), testCloudEntity.getBrowserVersionType());
        return testCloudEntity.getOsDisplayName() + ", " + testCloudEntity.getBrowserName().substring(0, 1).toUpperCase() + testCloudEntity.getBrowserName().substring(1) + ", version=" + browserFullVersion + ", Tunnel=" + testCloudEntity.isUsingTunnel();
    }
}

