/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.settings;

import com.katalon.capability.constant.DriverType;
import com.katalon.execution.dto.request.DriverConfiguration;
import com.katalon.execution.dto.request.TestExecutionRequest;
import com.katalon.execution.dto.request.WindowsDriverConfig;
import com.katalon.execution.exception.ExecutionException;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.SerializableMap;
import com.katalon.execution.services.settings.IDriverPropertiesBuilder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsDriverPropertiesBuilder
implements IDriverPropertiesBuilder {
    private static final Logger logger = LoggerFactory.getLogger(WindowsDriverPropertiesBuilder.class);

    @Override
    public String buildDetailedDriverName(TestExecutionRequest request) throws ExecutionException {
        return request.getCapability().getDisplayName();
    }

    @Override
    public DriversProperties.DriverSystemProperties buildSystemProperties(TestExecutionRequest request) {
        DriversProperties.DriverSystemProperties props = new DriversProperties.DriverSystemProperties();
        props.setBrowserType(DriverType.WINDOWS_DRIVER);
        return props;
    }

    @Override
    public DriversProperties.DriverPreferencesProperties buildPreferencesProperties(TestExecutionRequest request) {
        String userDefinedUrl;
        DriversProperties.WindowsPreferencesProperties props = new DriversProperties.WindowsPreferencesProperties();
        HashMap userDefinedProps = new HashMap(request.getCapability().getValue(DriverType.WINDOWS_DRIVER));
        String string = userDefinedUrl = userDefinedProps.containsKey("desktopDriverUrl") ? String.valueOf(userDefinedProps.get("desktopDriverUrl")) : null;
        if (userDefinedUrl != null && !userDefinedUrl.isEmpty()) {
            logger.info("Using user-defined Windows Driver URL: {}", (Object)userDefinedUrl);
            props.setDesktopDriverUrl(userDefinedUrl);
        } else {
            DriverConfiguration driverConfiguration = request.getDriverConfiguration();
            if (driverConfiguration instanceof WindowsDriverConfig) {
                WindowsDriverConfig windowsDriverConfig = (WindowsDriverConfig)driverConfiguration;
                logger.info("Using Windows Driver URL from driver configuration: {}", (Object)windowsDriverConfig.getDesktopDriverUrl());
                props.setDesktopDriverUrl(windowsDriverConfig.getDesktopDriverUrl());
            }
        }
        userDefinedProps.remove("desktopDriverUrl");
        props.setCustomProps(new SerializableMap(userDefinedProps));
        return props;
    }

    @Override
    public Map<String, String> buildEnvironmentVariables(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }

    @Override
    public Map<String, String> buildAdditionalInfo(TestExecutionRequest request) throws ExecutionException {
        return Map.of();
    }
}

