/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.tracking;

import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.tracking.ExecutionTrackingsImpl;
import com.katalon.execution.services.tracking.IExecutionTrackings;
import com.katalon.execution.services.tracking.TrackingInfoBuilder;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.tracking.model.FeatureFileTrackingInfo;
import com.kms.katalon.tracking.model.TestCaseTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteCollectionTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTrackingService {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionTrackingService.class);
    private final IExecutionTrackings executionTrackings;
    private TrackingInfoBuilder trackingInfoBuilder = new TrackingInfoBuilder();

    public ExecutionTrackingService(IExecutionTrackings executionTrackings) {
        this.executionTrackings = executionTrackings;
    }

    public ExecutionTrackingService() {
        this(new ExecutionTrackingsImpl());
    }

    public void safelySendTrackingInfo(EntityExecution entityExecution, TestReportingPhase reportingPhase) {
        if (!this.executionTrackings.canSubmitUsageTrackingData()) {
            logger.info("Skipping sending execution tracking info as user has disabled usage tracking");
            return;
        }
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            this.safelySendTrackingInfoForTestCase(testCaseExecution);
            return;
        }
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            this.safelySendTrackingInfoForTestSuite(testSuiteExecution, reportingPhase);
            return;
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            this.safelySendTrackingInfoForTestSuiteCollection(tscExecution, reportingPhase);
            return;
        }
        logger.warn("Unsupported entity execution type for tracking: " + entityExecution.getClass().getName());
    }

    private void safelySendTrackingInfoForTestCase(TestCaseExecution testCaseExecution) {
        try {
            if (testCaseExecution.getOriginalCucumberFeatureFileEntity().isPresent()) {
                FeatureFileTrackingInfo trackingInfo = this.trackingInfoBuilder.buildFeatureFileTrackingInfo(testCaseExecution);
                this.executionTrackings.trackExecuteFeatureFile(trackingInfo);
                return;
            }
            TestCaseTrackingInfo trackingInfo = this.trackingInfoBuilder.buildTestCaseTrackingInfo((BaseTestCaseExecution)testCaseExecution);
            this.executionTrackings.trackExecuteTestCase(trackingInfo);
        }
        catch (Exception exception) {}
    }

    private void safelySendTrackingInfoForTestSuite(TestSuiteExecution testSuiteExecution, TestReportingPhase reportingPhase) {
        try {
            for (TestSuiteExecutionAttempt attempt : testSuiteExecution.getAttempts()) {
                TestSuiteTrackingInfo trackingInfo = this.trackingInfoBuilder.buildTestSuiteTrackingInfo(attempt, reportingPhase);
                RunningMode runingMode = testSuiteExecution.getExecutionSettings().getRunConfiguration().getRunningMode();
                if (runingMode.isConsole()) {
                    this.executionTrackings.trackExecuteTestSuiteInConsoleMode(trackingInfo);
                    continue;
                }
                this.executionTrackings.trackExecuteTestSuiteInGuiMode(trackingInfo);
            }
        }
        catch (Exception exception) {}
    }

    private void safelySendTrackingInfoForTestSuiteCollection(TestSuiteCollectionExecution tscExecution, TestReportingPhase reportingPhase) {
        try {
            boolean isParallel;
            for (TestSuiteExecution testSuiteExecution : tscExecution.getTestSuiteExecutions()) {
                this.safelySendTrackingInfoForTestSuite(testSuiteExecution, reportingPhase);
            }
            TestSuiteCollectionTrackingInfo trackingInfo = this.trackingInfoBuilder.buildTSCTrackingInfo(tscExecution, reportingPhase);
            TestSuiteExecution firstTestSuiteExecution = tscExecution.getTestSuiteExecutions().stream().findFirst().orElse(null);
            RunningMode runingMode = firstTestSuiteExecution.getExecutionSettings().getRunConfiguration().getRunningMode();
            boolean bl = isParallel = tscExecution.getTestSuiteCollection().getMaxConcurrentInstances() > 1;
            if (runingMode.isConsole()) {
                if (isParallel) {
                    this.executionTrackings.trackExecuteParallelTestSuiteCollectionInConsoleMode(trackingInfo);
                } else {
                    this.executionTrackings.trackExecuteSequentialTestSuiteCollectionInConsoleMode(trackingInfo);
                }
            } else if (isParallel) {
                this.executionTrackings.trackExecuteParallelTestSuiteCollectionInGuiMode(trackingInfo);
            } else {
                this.executionTrackings.trackExecuteSequentialTestSuiteCollectionInGuiMode(trackingInfo);
            }
        }
        catch (Exception exception) {}
    }
}

