/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.tracking;

import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestStepLogRecord;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import java.util.List;

public class TestStepsCounter {
    public int countNumTestSteps(TestSuiteExecutionAttempt attempt) {
        return this.recursiveCountNumTestSteps(attempt.getLogRecords());
    }

    private int recursiveCountNumTestSteps(List<LogRecord> records) {
        if (records == null || records.isEmpty()) {
            return 0;
        }
        int numTestSteps = 0;
        for (LogRecord record : records) {
            numTestSteps += this.recursiveCountNumTestSteps(record);
        }
        return numTestSteps;
    }

    private int recursiveCountNumTestSteps(LogRecord record) {
        if (record == null) {
            return 0;
        }
        if (record instanceof TestCaseLogRecord) {
            return this.recursiveCountNumTestSteps(record.getChildRecords());
        }
        if (record instanceof TestStepLogRecord) {
            TestStepLogRecord testStepLogRecord = (TestStepLogRecord)record;
            if (testStepLogRecord.getIndex() <= 0) {
                int numChildSteps = this.recursiveCountNumTestSteps(testStepLogRecord.getChildRecords());
                return numChildSteps;
            }
            if (testStepLogRecord.getChildRecords().isEmpty()) {
                return 1;
            }
            int numChildSteps = this.recursiveCountNumTestSteps(record.getChildRecords());
            return numChildSteps == 0 ? 1 : numChildSteps;
        }
        return 0;
    }
}

