/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.services.tracking;

import com.katalon.execution.constant.ExecutionDriverType;
import com.katalon.execution.model.ExecutionJobStatus;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.settings.DriversProperties;
import com.katalon.execution.model.settings.ExecutionProperties;
import com.katalon.execution.model.settings.ExecutionSettings;
import com.katalon.execution.model.settings.PlatformsProperties;
import com.katalon.execution.model.settings.TestSuiteRerunSettings;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.TestResultStatistics;
import com.katalon.execution.model.steps.reporting.TestReportEmailSending;
import com.katalon.execution.model.steps.reporting.TestReportGeneration;
import com.katalon.execution.model.steps.testcase.BaseTestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.katalon.execution.services.settings.TestCloudDriverPropertiesBuilder;
import com.katalon.execution.services.tracking.TestStepsCounter;
import com.kms.katalon.application.utils.ApplicationContext;
import com.kms.katalon.core.appium.util.AppiumVersionUtil;
import com.kms.katalon.core.keyword.internal.KeywordExecutionContext;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.BrokenTestObjects;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.common.internal.SelfHealingController;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.RecordOption;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.collector.SelfHealingExecutionReport;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.session.core.model.Organization;
import com.kms.katalon.session.core.model.Project;
import com.kms.katalon.testops.core.model.AnalyticsIntegrationSetting;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.testops.services.TestOpsController;
import com.kms.katalon.tracking.model.FeatureFileTrackingInfo;
import com.kms.katalon.tracking.model.TestCaseTrackingInfo;
import com.kms.katalon.tracking.model.TestEntityTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteCollectionTrackingInfo;
import com.kms.katalon.tracking.model.TestSuiteTrackingInfo;
import com.kms.katalon.tracking.service.CicdInfoService;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackingInfoBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TrackingInfoBuilder.class);
    private TestStepsCounter testStepsCounter = new TestStepsCounter();

    public TestCaseTrackingInfo buildTestCaseTrackingInfo(BaseTestCaseExecution baseTestCaseExecution) {
        TestCaseEntity testCaseEntity = baseTestCaseExecution.getTestCase();
        ExecutionSettings executionSettings = baseTestCaseExecution.getExecutionSettings();
        ExecutionProperties executionProps = executionSettings.getRunConfiguration().getExecution();
        TestCaseTrackingInfo trackingInfo = new TestCaseTrackingInfo();
        this.populateTestResultStats((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        this.populateSelfhealingInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        this.populateKeywordUsage((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        this.populateAppiumInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        this.populateApplitoolsUsage((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        this.populateRemoteDomainInfo((TestEntityTrackingInfo)trackingInfo, executionSettings);
        this.populateTestOriginInfo(trackingInfo, baseTestCaseExecution);
        trackingInfo.setLaunchMode(executionSettings.getLaunchMode().name());
        trackingInfo.setDriverType(executionSettings.getRunConfiguration().getCapabilityName());
        trackingInfo.setDuration((long)baseTestCaseExecution.getDurationInMilliseconds().orElse(0).intValue());
        DriversProperties driversProps = executionSettings.getRunConfiguration().getExecution().getDrivers();
        boolean isRunFromExistingDriver = driversProps != null && driversProps.getSystemProps().containsKey((Object)ExecutionDriverType.EXISTING);
        trackingInfo.setExecuteFromHere(isRunFromExistingDriver);
        trackingInfo.setUseDataBinding(baseTestCaseExecution instanceof TestCaseBindingExecution);
        this.populateTestCloudInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        this.populateTestOpsTestCloudProjectInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)baseTestCaseExecution);
        trackingInfo.setAIAPITestCase(testCaseEntity.isAPITestGenerationTestCase());
        trackingInfo.setSmartWaitEnabled(executionProps.getGlobalSmartWaitEnabled().booleanValue());
        trackingInfo.setTestCaseGuid(testCaseEntity.getTestCaseGuid());
        trackingInfo.setFlowType("new");
        return trackingInfo;
    }

    public FeatureFileTrackingInfo buildFeatureFileTrackingInfo(TestCaseExecution testCaseExecution) {
        ExecutionSettings executionSettings = testCaseExecution.getExecutionSettings();
        FeatureFileTrackingInfo trackingInfo = new FeatureFileTrackingInfo();
        this.populateTestResultStats((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testCaseExecution);
        this.populateSelfhealingInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testCaseExecution);
        this.populateKeywordUsage((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testCaseExecution);
        trackingInfo.setLaunchMode(executionSettings.getLaunchMode().name());
        trackingInfo.setDriverType(executionSettings.getRunConfiguration().getCapabilityName());
        trackingInfo.setDuration((long)testCaseExecution.getDurationInMilliseconds().orElse(0).intValue());
        return trackingInfo;
    }

    public TestSuiteTrackingInfo buildTestSuiteTrackingInfo(TestSuiteExecutionAttempt testSuiteExecutionAttempt, TestReportingPhase testReportingPhase) {
        TestSuiteExecution testSuiteExecution;
        EntityExecution entityExecution;
        ExecutionSettings executionSettings = testSuiteExecutionAttempt.getExecutionSettings();
        TestSuiteRerunSettings testSuiteRerunSettings = executionSettings.getTestSuiteRerunSettings();
        TestSuiteEntity testSuite = testSuiteExecutionAttempt.getTestSuite();
        TestSuiteTrackingInfo trackingInfo = new TestSuiteTrackingInfo();
        this.populateOrganizationInfo((TestEntityTrackingInfo)trackingInfo);
        this.populateExecutionProps((TestEntityTrackingInfo)trackingInfo, executionSettings.getRunConfiguration().getExecution());
        this.populateTestResultStats((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testSuiteExecutionAttempt);
        this.populateSelfhealingInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testSuiteExecutionAttempt);
        this.populateAppiumInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testSuiteExecutionAttempt);
        this.populateApplitoolsUsage((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testSuiteExecutionAttempt);
        this.populateTestOpsTestCloudProjectInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testSuiteExecutionAttempt);
        this.populateRemoteDomainInfo((TestEntityTrackingInfo)trackingInfo, executionSettings);
        this.populateNumberOfTestSteps(trackingInfo, testSuiteExecutionAttempt);
        this.populateKeywordUsage((TestEntityTrackingInfo)trackingInfo, (EntityExecution)testSuiteExecutionAttempt);
        this.populateDataBindingUsageInfo(trackingInfo, testSuiteExecutionAttempt);
        Map<String, Map<String, Integer>> originMap = this.buildTestCaseOriginMap(testSuiteExecutionAttempt);
        trackingInfo.setOrigin(originMap);
        trackingInfo.setAnonymous(false);
        trackingInfo.setDriverType(executionSettings.getRunConfiguration().getCapabilityName());
        trackingInfo.setFlowType("new");
        trackingInfo.setDuration((long)testSuiteExecutionAttempt.getDurationInMilliseconds().orElse(0).intValue());
        trackingInfo.setRetryStrategy(testSuiteRerunSettings.getRetryStrategy().name());
        trackingInfo.setNumberOfRetry(testSuiteRerunSettings.getMaxRetryCount());
        EntityExecution entityExecution2 = testSuiteExecutionAttempt.getParentEntityExecution();
        if (entityExecution2 instanceof TestSuiteExecution && (entityExecution = (testSuiteExecution = (TestSuiteExecution)entityExecution2).getParentEntityExecution()) instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            trackingInfo.setTestSuiteCollectionId(tscExecution.getTestSuiteCollectionId());
            trackingInfo.setInCollection(true);
        }
        trackingInfo.setAdditionalProps(this.buildIntegratedContributionsTrackingData((EntityExecution)testSuiteExecutionAttempt));
        trackingInfo.setUsedMaxFailedTestParam(FailedTestThreshold.getInstance().isThresholdAvailable());
        trackingInfo.setDynamicTestSuite(testSuite instanceof FilteringTestSuiteEntity);
        trackingInfo.setTestcloudRecorderTestCaseCount(this.countNumTestCaseRecordedByTestCloud((EntityExecution)testSuiteExecutionAttempt));
        trackingInfo.setNumberOfAIAPITestCase(this.countAIAPITestCase((EntityExecution)testSuiteExecutionAttempt));
        trackingInfo.setCicdIntegration(CicdInfoService.getCicdName());
        EmailConfig oneEmailConfig = testReportingPhase.getChildren().stream().filter(step -> step.getExecutionJobStatus() == ExecutionJobStatus.COMPLETED && step instanceof TestReportEmailSending).map(step -> ((TestReportEmailSending)step).getEmailConfig()).findFirst().orElse(null);
        if (oneEmailConfig != null) {
            trackingInfo.setAIHtmlReport(oneEmailConfig.isAnalyzeFailedReasonByAI());
        }
        trackingInfo.setNumberOfEmailsSent(this.countEmailsSent(testReportingPhase));
        this.populateReportGenerationTypes((TestEntityTrackingInfo)trackingInfo, testReportingPhase);
        HashMap testCaseInfo = new HashMap();
        if (testSuiteExecutionAttempt.getTestCaseExecutions() != null && !testSuiteExecutionAttempt.getTestCaseExecutions().isEmpty()) {
            for (BaseTestCaseExecution testCaseExecution : testSuiteExecutionAttempt.getTestCaseExecutions()) {
                HashMap<String, String> singleTestCaseInfo = new HashMap<String, String>();
                TestCaseEntity testCase = testCaseExecution.getTestCase();
                if (testCase == null) {
                    logger.warn("Skipping test case tracking: null test case entity found in execution");
                    continue;
                }
                singleTestCaseInfo.put("test_case_id", testCase.getTestCaseGuid());
                singleTestCaseInfo.put("source", testCase.getOrigin());
                singleTestCaseInfo.put("status", testCaseExecution.getTestResult().map(Enum::name).orElse(null));
                testCaseInfo.put(testCase.getTestCaseGuid(), singleTestCaseInfo);
            }
        }
        trackingInfo.setTestCaseInfo(testCaseInfo);
        return trackingInfo;
    }

    private void populateDataBindingUsageInfo(TestSuiteTrackingInfo trackingInfo, TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        boolean isBindingAtTestCaseLevel = testSuiteExecutionAttempt.getBindingLevel() == TestSuiteExecutionAttempt.BindingLevel.TEST_CASE_LEVEL;
        trackingInfo.setUseDataBinding(isBindingAtTestCaseLevel);
        boolean isBindingAtTestSuiteLevelWithNonDefaultVar = false;
        TestSuiteEntity testSuiteEntity = testSuiteExecutionAttempt.getTestSuite();
        for (BaseTestCaseExecution testCaseExecution : testSuiteExecutionAttempt.getTestCaseExecutions()) {
            VariableLink nonDefaultVarLink;
            TestSuiteTestCaseLink testCaseLink = testSuiteEntity.getTestSuiteTestCaseLinks().stream().filter(link -> link.getTestCaseId().equals(testCaseExecution.getTestCaseId())).findFirst().orElse(null);
            if (testCaseLink == null || !testCaseLink.isUsingDataBindingAtTestSuiteLevel() || (nonDefaultVarLink = (VariableLink)testCaseLink.getVariableLinks().stream().filter(variableLink -> variableLink.getType() != VariableLink.VariableType.DEFAULT).findFirst().orElse(null)) == null) continue;
            isBindingAtTestSuiteLevelWithNonDefaultVar = true;
            break;
        }
        trackingInfo.setSuiteTestCaseDataBinding(isBindingAtTestSuiteLevelWithNonDefaultVar);
    }

    public TestSuiteCollectionTrackingInfo buildTSCTrackingInfo(TestSuiteCollectionExecution tscExecution, TestReportingPhase reportingPhase) {
        TestSuiteCollectionTrackingInfo trackingInfo = new TestSuiteCollectionTrackingInfo();
        this.populateTestResultStats((TestEntityTrackingInfo)trackingInfo, (EntityExecution)tscExecution);
        this.populateSelfhealingInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)tscExecution);
        this.populateAppiumInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)tscExecution);
        this.populateTestOpsTestCloudProjectInfo((TestEntityTrackingInfo)trackingInfo, (EntityExecution)tscExecution);
        trackingInfo.setDuration((long)tscExecution.getDurationInMilliseconds().orElse(0).intValue());
        this.populateOrganizationInfo((TestEntityTrackingInfo)trackingInfo);
        TestSuiteExecution firstTestSuiteExecution = tscExecution.getTestSuiteExecutions().stream().findFirst().orElse(null);
        if (firstTestSuiteExecution != null) {
            this.populateExecutionProps((TestEntityTrackingInfo)trackingInfo, firstTestSuiteExecution.getExecutionSettings().getRunConfiguration().getExecution());
        }
        trackingInfo.setMaxConcurrentInstances(tscExecution.getTestSuiteCollection().getMaxConcurrentInstances());
        trackingInfo.setAdditionalProps(this.buildIntegratedContributionsTrackingData((EntityExecution)tscExecution));
        trackingInfo.setTestSuiteCollectionId(tscExecution.getTestSuiteCollectionId());
        trackingInfo.setTestcloudRecorderTestCaseCount(this.countNumTestCaseRecordedByTestCloud((EntityExecution)tscExecution));
        trackingInfo.setNumberOfAIAPITestCase(this.countAIAPITestCase((EntityExecution)tscExecution));
        this.populateReportGenerationTypes((TestEntityTrackingInfo)trackingInfo, reportingPhase);
        trackingInfo.setNumberOfEmailsSent(this.countEmailsSent(reportingPhase));
        return trackingInfo;
    }

    private String buildDisplayTestResult(Optional<ExecutionTestResult> testResult) {
        if (testResult.isEmpty()) {
            return "Unknown";
        }
        return testResult.get().name();
    }

    private void populateOrganizationInfo(TestEntityTrackingInfo trackingInfo) {
        ApplicationContext context = ApplicationContext.getInstance();
        if (context == null) {
            return;
        }
        Organization organization = context.getOrganization();
        if (organization == null) {
            return;
        }
        if (trackingInfo instanceof TestSuiteTrackingInfo) {
            TestSuiteTrackingInfo tsTrackingInfo = (TestSuiteTrackingInfo)trackingInfo;
            tsTrackingInfo.setOrgId(organization.getId());
            return;
        }
        if (trackingInfo instanceof TestSuiteCollectionTrackingInfo) {
            TestSuiteCollectionTrackingInfo tscTrackingInfo = (TestSuiteCollectionTrackingInfo)trackingInfo;
            tscTrackingInfo.setOrgId(organization.getId());
            return;
        }
        logger.warn("Tracking info type does not support organization info population: " + trackingInfo.getClass().getName());
    }

    private void populateExecutionProps(TestEntityTrackingInfo trackingInfo, ExecutionProperties executionProps) {
        boolean isScreenshotEnabled = executionProps.getGeneral().getReport().getTakeScreenshotSettings().isEnable();
        boolean isVideoEnabled = executionProps.getGeneral().getReport().getVideoRecorderSettings().isEnable();
        String videoRecordingLevel = executionProps.getGeneral().getReport().getVideoRecorderSettings().isUseBrowserRecorder() ? "browser" : "screen";
        boolean isHideHostnameEnabled = executionProps.getHideHostname();
        boolean isSmartWaitEnabled = executionProps.getGlobalSmartWaitEnabled();
        if (trackingInfo instanceof TestSuiteTrackingInfo) {
            TestSuiteTrackingInfo tsTrackingInfo = (TestSuiteTrackingInfo)trackingInfo;
            tsTrackingInfo.setEnableScreenshot(isScreenshotEnabled);
            tsTrackingInfo.setEnableVideo(isVideoEnabled);
            tsTrackingInfo.setEnableHideHostname(isHideHostnameEnabled);
            tsTrackingInfo.setVideoRecordingLevel(videoRecordingLevel);
            tsTrackingInfo.setSmartWaitEnabled(isSmartWaitEnabled);
            tsTrackingInfo.setFlowType("new");
            return;
        }
    }

    private Map<String, Object> buildIntegratedContributionsTrackingData(EntityExecution entityExecution) {
        TestSuiteExecution testSuiteExecution;
        if (entityExecution instanceof TestSuiteExecution && (testSuiteExecution = (TestSuiteExecution)entityExecution).isPartOfCollection()) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map contributions = ReportIntegrationFactory.getInstance().getIntegrationContributorMap();
        for (Map.Entry element : contributions.entrySet()) {
            ReportIntegrationContribution contribution = (ReportIntegrationContribution)element.getValue();
            if (contribution == null || !contribution.isNeededTrackingData()) continue;
            result.putAll(contribution.getTrackingProperties());
        }
        return result;
    }

    private SelfHealingExecutionReport collectSelfHealingReport(EntityExecution entityExecution) {
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            return this.collectSelfHealingReport(testCaseExecution.getExecutionSettings());
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            return this.collectSelfHealingReport(testSuiteExecutionAttempt.getExecutionSettings());
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            TestSuiteExecution firstTestSuiteExecution = tscExecution.getTestSuiteExecutions().stream().findFirst().orElse(null);
            if (firstTestSuiteExecution == null) {
                logger.warn("No Test Suite Execution found in Test Suite Collection Execution.");
                return null;
            }
            File firstTestSuiteExecutionPath = firstTestSuiteExecution.getExecutionSettings().getExecutionDirPath().toFile();
            File tscReportFolder = firstTestSuiteExecutionPath.getParentFile().getParentFile();
            PlatformsProperties platformsProps = firstTestSuiteExecution.getExecutionSettings().getRunConfiguration().getExecution().getPlatforms();
            boolean isEnabled = platformsProps.getWeb().isEnableSelfHealing() || platformsProps.getMobile().isEnableSelfHealing();
            return this.collectSelfHealingReport(tscReportFolder, isEnabled);
        }
        logger.warn("Self-healing report collection is not supported for entity execution type: " + entityExecution.getClass().getName());
        return null;
    }

    private SelfHealingExecutionReport collectSelfHealingReport(ExecutionSettings executionSettings) {
        File reportFolder = executionSettings.getExecutionDirPath().toFile();
        PlatformsProperties platformsProps = executionSettings.getRunConfiguration().getExecution().getPlatforms();
        boolean isEnabled = platformsProps.getWeb().isEnableSelfHealing() || platformsProps.getMobile().isEnableSelfHealing();
        return this.collectSelfHealingReport(reportFolder, isEnabled);
    }

    private SelfHealingExecutionReport collectSelfHealingReport(File reportFolder, boolean isSelfHealingEnabled) {
        ArrayList selfHealingDataFiles = new ArrayList();
        if (reportFolder == null || !reportFolder.exists() || !reportFolder.isDirectory()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (Stream<Path> stream = Files.walk(Paths.get(reportFolder.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                stream.filter(path -> Files.isRegularFile(path, new LinkOption[0])).forEach(selfHealingDataFile -> {
                    String fileName = selfHealingDataFile.getFileName().toString();
                    if (StringUtils.equals((CharSequence)fileName, (CharSequence)"broken-test-objects-v2.json")) {
                        selfHealingDataFiles.add(selfHealingDataFile.toFile());
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception error) {
            logger.warn("Error while collecting self-healing data files", (Throwable)error);
        }
        boolean isTriggered = selfHealingDataFiles != null && !selfHealingDataFiles.isEmpty();
        HashSet brokenTestObjects = new HashSet();
        selfHealingDataFiles.stream().forEach(dataFile -> {
            Set<BrokenTestObject> pratialBrokenTestObjects = this.collectBrokenTestObjects(dataFile.getParentFile());
            if (pratialBrokenTestObjects != null) {
                brokenTestObjects.addAll(pratialBrokenTestObjects);
            }
        });
        return new SelfHealingExecutionReport(isSelfHealingEnabled, isTriggered, brokenTestObjects);
    }

    private Set<BrokenTestObject> collectBrokenTestObjects(File reportFolder) {
        BrokenTestObjects brokenTestObjectsWrapper;
        String selfHealingDataFilePath = SelfHealingController.getSelfHealingDataFilePath((String)reportFolder.getAbsolutePath());
        boolean isTriggered = new File(selfHealingDataFilePath).exists();
        Set brokenTestObjects = null;
        if (isTriggered && (brokenTestObjectsWrapper = SelfHealingController.readExistingBrokenTestObjects((String)selfHealingDataFilePath)) != null) {
            brokenTestObjects = brokenTestObjectsWrapper.getBrokenTestObjects();
        }
        return brokenTestObjects;
    }

    private void populateTestResultStats(TestEntityTrackingInfo trackingInfo, EntityExecution entityExecution) {
        Optional testResult = entityExecution.getTestResult();
        trackingInfo.setResult(this.buildDisplayTestResult(testResult));
        if (trackingInfo instanceof TestSuiteCollectionTrackingInfo) {
            TestSuiteCollectionTrackingInfo tscTrackingInfo = (TestSuiteCollectionTrackingInfo)trackingInfo;
            TestResultStatistics testResultStats = entityExecution.getDescendantTestCaseStats();
            EnumMap testResultCount = testResultStats.getTestResultCount();
            tscTrackingInfo.setTotalTestCases(testResultStats.getTotalCount());
            tscTrackingInfo.setPassedTestCases(testResultCount.getOrDefault(ExecutionTestResult.PASSED, 0).intValue());
            tscTrackingInfo.setFailedTestCases(testResultCount.getOrDefault(ExecutionTestResult.FAILED, 0).intValue());
            tscTrackingInfo.setErrorTestCases(testResultCount.getOrDefault(ExecutionTestResult.ERROR, 0).intValue());
            tscTrackingInfo.setSkippedTestCases(testResultCount.getOrDefault(ExecutionTestResult.SKIPPED, 0).intValue());
            tscTrackingInfo.setIncompleteTestCases(testResultCount.getOrDefault(ExecutionTestResult.INCOMPLETE, 0).intValue());
        } else if (trackingInfo instanceof TestSuiteTrackingInfo) {
            TestSuiteTrackingInfo tsTrackingInfo = (TestSuiteTrackingInfo)trackingInfo;
            TestResultStatistics testResultStats = entityExecution.getDescendantTestCaseStats();
            EnumMap testResultCount = testResultStats.getTestResultCount();
            tsTrackingInfo.setTotalTestCases(testResultStats.getTotalCount());
            tsTrackingInfo.setPassedTestCases(testResultCount.getOrDefault(ExecutionTestResult.PASSED, 0).intValue());
            tsTrackingInfo.setFailedTestCases(testResultCount.getOrDefault(ExecutionTestResult.FAILED, 0).intValue());
            tsTrackingInfo.setErrorTestCases(testResultCount.getOrDefault(ExecutionTestResult.ERROR, 0).intValue());
            tsTrackingInfo.setSkippedTestCases(testResultCount.getOrDefault(ExecutionTestResult.SKIPPED, 0).intValue());
            tsTrackingInfo.setIncompleteTestCases(testResultCount.getOrDefault(ExecutionTestResult.INCOMPLETE, 0).intValue());
        }
    }

    private void populateSelfhealingInfo(TestEntityTrackingInfo trackingInfo, EntityExecution entityExecution) {
        SelfHealingExecutionReport selfHealingReport = this.collectSelfHealingReport(entityExecution);
        if (selfHealingReport == null) {
            return;
        }
        trackingInfo.setEnableSelfHealing(selfHealingReport.isEnabled());
        trackingInfo.setTriggerSelfHealing(selfHealingReport.isTriggered());
        trackingInfo.setHealingInfo(selfHealingReport.getHealingInfo());
    }

    private void populateAppiumInfo(TestEntityTrackingInfo trackInfo, EntityExecution entityExecution) {
        ArrayList<ExecutionSettings> executionSettingsList = new ArrayList<ExecutionSettings>();
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            executionSettingsList.add(testCaseExecution.getExecutionSettings());
        } else if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            executionSettingsList.add(testSuiteExecution.getExecutionSettings());
        } else if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            for (TestSuiteExecution tsExecution : tscExecution.getTestSuiteExecutions()) {
                executionSettingsList.add(tsExecution.getExecutionSettings());
            }
        }
        String appiumDirectory = executionSettingsList.stream().map(executionSettings -> executionSettings.getRunConfiguration().getExecution().getDrivers().getSystemProps().values().stream().filter(prop -> prop.getAppiumDirectory() != null).findFirst().map(DriversProperties.DriverSystemProperties::getAppiumDirectory).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
        if (appiumDirectory == null) {
            return;
        }
        trackInfo.setAppiumVersion(AppiumVersionUtil.readVersionFromFile((String)appiumDirectory));
    }

    private TestCaseLogRecord findTestCaseLogRecord(BaseTestCaseExecution baseTestCaseExecution) {
        TestCaseExecutionAttempt attempt = null;
        if (baseTestCaseExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution testCaseBindingExecution = (TestCaseBindingExecution)baseTestCaseExecution;
            attempt = testCaseBindingExecution.getFirstIteration().getFirstAttempt();
        } else if (baseTestCaseExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)baseTestCaseExecution;
            attempt = testCaseExecution.getFirstAttempt();
        } else if (baseTestCaseExecution instanceof TestCaseExecutionAttempt) {
            TestCaseExecutionAttempt testCaseExecutionAttempt;
            attempt = testCaseExecutionAttempt = (TestCaseExecutionAttempt)baseTestCaseExecution;
        }
        if (attempt == null) {
            logger.warn("No attempt found for the given TestCaseExecution.");
            return null;
        }
        return attempt.getTestCaseLogRecord();
    }

    private boolean isApplitoolsUsed(LogRecord logRecord) {
        if (logRecord == null || logRecord.getProperties() == null) {
            return false;
        }
        try {
            String applitoolUsage = (String)logRecord.getProperties().get("applitools");
            return Boolean.parseBoolean(applitoolUsage);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void populateApplitoolsUsage(TestEntityTrackingInfo trackInfo, EntityExecution entityExecution) {
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            TestCaseLogRecord testCaseLogRecord = this.findTestCaseLogRecord((BaseTestCaseExecution)testCaseExecution);
            boolean isUsed = this.isApplitoolsUsed((LogRecord)testCaseLogRecord);
            if (trackInfo instanceof TestCaseTrackingInfo) {
                TestCaseTrackingInfo testCaseTrackingInfo = (TestCaseTrackingInfo)trackInfo;
                testCaseTrackingInfo.setUsingApplitools(isUsed);
            }
            return;
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            boolean isUsed = testSuiteExecutionAttempt.getLogRecords().stream().anyMatch(logRecord -> this.isApplitoolsUsed((LogRecord)logRecord));
            if (trackInfo instanceof TestSuiteTrackingInfo) {
                TestSuiteTrackingInfo testSuiteTrackingInfo = (TestSuiteTrackingInfo)trackInfo;
                testSuiteTrackingInfo.setUsingApplitools(isUsed);
            }
            return;
        }
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            boolean isUsed = testSuiteExecution.getAttempts().stream().anyMatch(attempt -> attempt.getLogRecords().stream().anyMatch(logRecord -> this.isApplitoolsUsed((LogRecord)logRecord)));
            if (trackInfo instanceof TestSuiteTrackingInfo) {
                TestSuiteTrackingInfo testSuiteTrackingInfo = (TestSuiteTrackingInfo)trackInfo;
                testSuiteTrackingInfo.setUsingApplitools(isUsed);
            }
            return;
        }
        logger.warn("Applitools usage population is not supported for entity execution type: " + entityExecution.getClass().getName());
    }

    private Map<String, Boolean> safelyExtractKeywordUsagesPerPlatform(TestCaseLogRecord logRecord) {
        if (logRecord == null || logRecord.getProperties() == null) {
            return Map.of();
        }
        try {
            String rawKeywordsUsage = (String)logRecord.getProperties().get("keywordsUsage");
            return (Map)JsonUtil.fromJson((String)rawKeywordsUsage, Map.class);
        }
        catch (Exception error) {
            logger.warn("Error while extracting keyword usages per platform", (Throwable)error);
            return Map.of();
        }
    }

    private Map<String, Number> safelyExtractExecutedKeywordsCount(TestCaseLogRecord logRecord) {
        if (logRecord == null || logRecord.getProperties() == null) {
            return Map.of();
        }
        try {
            String rawExecutedKeywords = (String)logRecord.getProperties().get("executedKeywords");
            return (Map)JsonUtil.fromJson((String)rawExecutedKeywords, Map.class);
        }
        catch (Exception error) {
            logger.warn("Error while extracting executed keywords count", (Throwable)error);
            return Map.of();
        }
    }

    private void populateKeywordUsage(TestEntityTrackingInfo trackInfo, EntityExecution entityExecution) {
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            TestCaseLogRecord testCaseLogRecord = this.findTestCaseLogRecord((BaseTestCaseExecution)testCaseExecution);
            Map<String, Boolean> usage = this.safelyExtractKeywordUsagesPerPlatform(testCaseLogRecord);
            if (usage == null || usage.isEmpty()) {
                logger.warn("No keyword usage data found in the log record.");
                return;
            }
            if (trackInfo instanceof TestCaseTrackingInfo) {
                TestCaseTrackingInfo testCaseTrackingInfo = (TestCaseTrackingInfo)trackInfo;
                testCaseTrackingInfo.setKeywordsUsage(usage);
            }
            return;
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            HashMap keywordsUsagePerPlatform = new HashMap();
            HashMap testCaseCountPerPlatform = new HashMap();
            HashMap<String, Integer> keywordCountPerPlatform = new HashMap<String, Integer>();
            KeywordExecutionContext.getPlatformName().forEach((key, platformName) -> testCaseCountPerPlatform.put(platformName, 0));
            TestSuiteLogRecord testSuiteLogRecord = testSuiteExecutionAttempt.getTestSuiteLogRecord();
            List<TestCaseLogRecord> testCaseLogRecords = testSuiteLogRecord == null ? List.of() : testSuiteLogRecord.getChildRecords().stream().filter(record -> record instanceof TestCaseLogRecord).map(record -> (TestCaseLogRecord)record).toList();
            for (TestCaseLogRecord testCaseLogRecord : testCaseLogRecords) {
                Map<String, Number> executedKeywords;
                Map<String, Boolean> usage = this.safelyExtractKeywordUsagesPerPlatform(testCaseLogRecord);
                if (usage != null && !usage.isEmpty()) {
                    usage.forEach(keywordsUsagePerPlatform::putIfAbsent);
                    usage.forEach((platform, hasUsed) -> {
                        if (Boolean.TRUE.equals(hasUsed)) {
                            testCaseCountPerPlatform.computeIfPresent(platform, (key, count) -> count + 1);
                        }
                    });
                }
                if ((executedKeywords = this.safelyExtractExecutedKeywordsCount(testCaseLogRecord)) == null) continue;
                for (Map.Entry<String, Number> entry : executedKeywords.entrySet()) {
                    String keywordName = entry.getKey();
                    int count = entry.getValue().intValue();
                    keywordCountPerPlatform.putIfAbsent(keywordName, 0);
                    keywordCountPerPlatform.computeIfPresent(keywordName, (key, existingCount) -> existingCount + count);
                }
            }
            if (trackInfo instanceof TestSuiteTrackingInfo) {
                TestSuiteTrackingInfo testSuiteTrackingInfo = (TestSuiteTrackingInfo)trackInfo;
                testSuiteTrackingInfo.setKeywordsUsage(keywordsUsagePerPlatform);
                testSuiteTrackingInfo.setExecutedTestCaseKeywordTypes(testCaseCountPerPlatform);
                testSuiteTrackingInfo.setExecutedKeywordNames(keywordCountPerPlatform);
            }
            return;
        }
        logger.warn("Keyword usage population is not supported for entity execution type: " + entityExecution.getClass().getName());
    }

    private ExecutionSettings getExecutionSettingsFromEntityExecution(EntityExecution entityExecution) {
        TestSuiteCollectionExecution tscExecution;
        TestSuiteExecution firstTestSuiteExecution;
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            return testCaseExecution.getExecutionSettings();
        }
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            return testSuiteExecution.getExecutionSettings();
        }
        if (entityExecution instanceof TestSuiteCollectionExecution && (firstTestSuiteExecution = (TestSuiteExecution)(tscExecution = (TestSuiteCollectionExecution)entityExecution).getTestSuiteExecutions().stream().findFirst().orElse(null)) != null) {
            return firstTestSuiteExecution.getExecutionSettings();
        }
        return null;
    }

    private void populateTestCloudInfo(TestEntityTrackingInfo trackInfo, EntityExecution entityExecution) {
        if (entityExecution instanceof BaseTestCaseExecution) {
            BaseTestCaseExecution testCaseExecution = (BaseTestCaseExecution)entityExecution;
            if (trackInfo instanceof TestCaseTrackingInfo) {
                TestCaseTrackingInfo testCaseTrackingInfo = (TestCaseTrackingInfo)trackInfo;
                testCaseTrackingInfo.setRecordedWithTestCloud(this.isRecordedByTestCloud(testCaseExecution.getTestCase()));
            }
        }
        ExecutionSettings executionSettings = this.getExecutionSettingsFromEntityExecution(entityExecution);
        Map additionalInfo = executionSettings.getAdditionalInfo();
        String testCloudRunConfiguration = null;
        boolean isUsingTunnel = false;
        if (additionalInfo != null) {
            testCloudRunConfiguration = (String)additionalInfo.get(TestCloudDriverPropertiesBuilder.TEST_CLOUD_RUN_CONFIGURATION_KEY);
            isUsingTunnel = Boolean.valueOf((String)additionalInfo.get(TestCloudDriverPropertiesBuilder.IS_USING_TEST_CLOUD_TUNNEL_KEY));
        }
        if (trackInfo instanceof TestCaseTrackingInfo) {
            TestCaseTrackingInfo testCaseTrackingInfo = (TestCaseTrackingInfo)trackInfo;
            testCaseTrackingInfo.setTestCloudRunConfiguration(testCloudRunConfiguration);
        } else if (trackInfo instanceof TestSuiteTrackingInfo) {
            TestSuiteTrackingInfo testSuiteTrackingInfo = (TestSuiteTrackingInfo)trackInfo;
            testSuiteTrackingInfo.setTestCloudRunConfiguration(testCloudRunConfiguration);
            if (isUsingTunnel) {
                testSuiteTrackingInfo.setIsTestCloudTunnelEnabled((Object)isUsingTunnel);
                return;
            }
        }
    }

    private boolean isRecordedByTestCloud(TestCaseEntity testCase) {
        return RecordOption.TESTCLOUD_NATIVE_MOBILE.equals((Object)testCase.getRecordOption());
    }

    private int countNumTestCaseRecordedByTestCloud(EntityExecution entityExecution) {
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            return this.isRecordedByTestCloud(testCaseExecution.getTestCase()) ? 1 : 0;
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            return (int)testSuiteExecutionAttempt.getTestCaseExecutions().stream().filter(tcExecution -> this.isRecordedByTestCloud(tcExecution.getTestCase())).count();
        }
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            TestSuiteExecutionAttempt firstAttempt = testSuiteExecution.getAttempts().stream().findFirst().orElse(null);
            if (firstAttempt == null) {
                return 0;
            }
            return this.countNumTestCaseRecordedByTestCloud((EntityExecution)firstAttempt);
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            return (int)tscExecution.getTestSuiteExecutions().stream().mapToLong(tsExecution -> this.countNumTestCaseRecordedByTestCloud((EntityExecution)tsExecution)).sum();
        }
        logger.warn("Counting test cases recorded by TestCloud is not supported for entity execution type: " + entityExecution.getClass().getName());
        return 0;
    }

    private int countAIAPITestCase(EntityExecution entityExecution) {
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution testCaseExecution = (TestCaseExecution)entityExecution;
            return testCaseExecution.getTestCase().isAPITestGenerationTestCase() ? 1 : 0;
        }
        if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt testSuiteExecutionAttempt = (TestSuiteExecutionAttempt)entityExecution;
            return (int)testSuiteExecutionAttempt.getTestCaseExecutions().stream().filter(tcExecution -> tcExecution.getTestCase().isAPITestGenerationTestCase()).count();
        }
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution testSuiteExecution = (TestSuiteExecution)entityExecution;
            TestSuiteExecutionAttempt firstAttempt = testSuiteExecution.getAttempts().stream().findFirst().orElse(null);
            if (firstAttempt == null) {
                return 0;
            }
            return this.countAIAPITestCase((EntityExecution)firstAttempt);
        }
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tscExecution = (TestSuiteCollectionExecution)entityExecution;
            return (int)tscExecution.getTestSuiteExecutions().stream().mapToLong(tsExecution -> this.countAIAPITestCase((EntityExecution)tsExecution)).sum();
        }
        logger.warn("Counting AI-API test cases is not supported for entity execution type: " + entityExecution.getClass().getName());
        return 0;
    }

    private void populateTestOpsTestCloudProjectInfo(TestEntityTrackingInfo trackInfo, EntityExecution entityExecution) {
        String analyticsProjectId = "";
        String analyticsAccountId = "";
        ITestOpsController testOpsController = null;
        try {
            testOpsController = TestOpsController.getInstance();
        }
        catch (Exception e) {
            logger.warn("Failed to populate TestOps TestCloud project info.", (Object)e.getMessage());
            return;
        }
        if (testOpsController == null) {
            return;
        }
        AnalyticsIntegrationSetting integratedSetting = null;
        try {
            integratedSetting = testOpsController.getRequestOptions().getIntegratedSetting();
        }
        catch (Exception e) {
            logger.warn("Failed to populate TestOps TestCloud project info.", (Object)e.getMessage());
            return;
        }
        if (integratedSetting == null) {
            return;
        }
        Project project = integratedSetting.getProject();
        analyticsProjectId = project != null ? project.getId().toString() : "";
        analyticsAccountId = project != null ? project.getAccountId().toString() : "";
        trackInfo.setTestOpsProjectId(analyticsProjectId);
        trackInfo.setTestOpsAccountId(analyticsAccountId);
        trackInfo.setTestCloudProjectId(analyticsProjectId);
        trackInfo.setTestCloudAccountId(analyticsAccountId);
    }

    private void populateReportGenerationTypes(TestEntityTrackingInfo trackingInfo, TestReportingPhase reportingPhase) {
        List<String> reportNamesForTracking = reportingPhase.getChildren().stream().filter(step -> step.getExecutionJobStatus() == ExecutionJobStatus.COMPLETED && step instanceof TestReportGeneration).map(step -> ((TestReportGeneration)step).getFormat().getTrackingName()).toList();
        String reportNamesString = StringUtils.join(reportNamesForTracking, (String)", ");
        if (trackingInfo instanceof TestSuiteCollectionTrackingInfo) {
            TestSuiteCollectionTrackingInfo tscTrackingInfo = (TestSuiteCollectionTrackingInfo)trackingInfo;
            tscTrackingInfo.setReportGenerationTypes(reportNamesString);
        } else if (trackingInfo instanceof TestSuiteTrackingInfo) {
            TestSuiteTrackingInfo tsTrackingInfo = (TestSuiteTrackingInfo)trackingInfo;
            tsTrackingInfo.setReportGenerationTypes(reportNamesString);
        }
    }

    private int countEmailsSent(TestReportingPhase reportingPhase) {
        if (reportingPhase == null) {
            return 0;
        }
        List<EmailConfig> sentMailConfigs = reportingPhase.getChildren().stream().filter(step -> step.getExecutionJobStatus() == ExecutionJobStatus.COMPLETED && step instanceof TestReportEmailSending).map(step -> ((TestReportEmailSending)step).getEmailConfig()).toList();
        int numberOfEmailsSent = 0;
        for (EmailConfig emailConfig : sentMailConfigs) {
            numberOfEmailsSent += MailUtil.getNumberOfEmailsSent((boolean)true, (EmailConfig)emailConfig);
        }
        return numberOfEmailsSent;
    }

    private void populateRemoteDomainInfo(TestEntityTrackingInfo trackingInfo, ExecutionSettings executionSettings) {
        DriversProperties.RemoteDriverSystemProperties remoteDriverProp;
        String remoteWebDriverUrl;
        DriversProperties driversProps = executionSettings.getRunConfiguration().getExecution().getDrivers();
        DriversProperties.DriverSystemProperties driverProps = driversProps != null ? (DriversProperties.DriverSystemProperties)driversProps.getSystemProps().get((Object)ExecutionDriverType.REMOTE) : null;
        String remoteDomain = "";
        if (driverProps instanceof DriversProperties.RemoteDriverSystemProperties && StringUtils.isNotBlank((CharSequence)(remoteWebDriverUrl = (remoteDriverProp = (DriversProperties.RemoteDriverSystemProperties)driverProps).getRemoteWebDriverUrl()))) {
            try {
                URI uri = new URI(remoteWebDriverUrl);
                remoteDomain = uri.getHost();
            }
            catch (URISyntaxException e) {
                logger.warn("Failed to parse remote WebDriver URL: " + remoteWebDriverUrl, (Throwable)e);
            }
        }
        if (StringUtils.isBlank((CharSequence)remoteDomain)) {
            return;
        }
        if (trackingInfo instanceof TestCaseTrackingInfo) {
            TestCaseTrackingInfo testCaseTrackingInfo = (TestCaseTrackingInfo)trackingInfo;
            testCaseTrackingInfo.setRemoteDomain(remoteDomain);
            return;
        }
        if (trackingInfo instanceof TestSuiteTrackingInfo) {
            TestSuiteTrackingInfo testSuiteTrackingInfo = (TestSuiteTrackingInfo)trackingInfo;
            testSuiteTrackingInfo.setRemoteDomain(remoteDomain);
            return;
        }
        logger.warn("Remote domain population is not supported for entity execution type: " + trackingInfo.getClass().getName());
    }

    private void populateTestOriginInfo(TestCaseTrackingInfo trackingInfo, BaseTestCaseExecution baseTestCaseExecution) {
        String origin = baseTestCaseExecution.getTestCase().getOrigin();
        trackingInfo.setOrigin(origin);
    }

    private void incrementCountMapValue(Map<String, Integer> countMap, String key) {
        countMap.put(key, countMap.getOrDefault(key, 0) + 1);
    }

    private void updateCountMapForTestResult(Map<String, Integer> countMap, ExecutionTestResult testResult) {
        if (testResult == ExecutionTestResult.PASSED) {
            this.incrementCountMapValue(countMap, "passed_test_cases");
        } else if (testResult == ExecutionTestResult.FAILED) {
            this.incrementCountMapValue(countMap, "failed_test_cases");
        } else if (testResult == ExecutionTestResult.ERROR) {
            this.incrementCountMapValue(countMap, "error_test_cases");
        } else if (testResult == ExecutionTestResult.INCOMPLETE) {
            this.incrementCountMapValue(countMap, "incomplete_test_cases");
        } else if (testResult == ExecutionTestResult.SKIPPED) {
            this.incrementCountMapValue(countMap, "skipped_test_cases");
        }
    }

    private Map<String, Map<String, Integer>> buildTestCaseOriginMap(TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        HashMap<String, Map<String, Integer>> originMap = new HashMap<String, Map<String, Integer>>();
        List testCaseExecutions = testSuiteExecutionAttempt.getTestCaseExecutions();
        for (BaseTestCaseExecution testCaseExecution : testCaseExecutions) {
            String origin = testCaseExecution.getTestCase().getOrigin();
            if (StringUtils.isBlank((CharSequence)origin)) continue;
            Map countMap = originMap.computeIfAbsent(origin, k -> new HashMap());
            this.incrementCountMapValue(countMap, "total_test_cases");
            Optional optionalTestResult = testCaseExecution.getTestResult();
            if (!optionalTestResult.isPresent()) continue;
            this.updateCountMapForTestResult(countMap, (ExecutionTestResult)optionalTestResult.get());
        }
        return originMap;
    }

    private void populateNumberOfTestSteps(TestSuiteTrackingInfo trackingInfo, TestSuiteExecutionAttempt testSuiteExecutionAttempt) {
        int totalTestSteps = this.testStepsCounter.countNumTestSteps(testSuiteExecutionAttempt);
        trackingInfo.setNumTestSteps(totalTestSteps);
    }
}

