/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.temporary;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.katalon.execution.dto.result.JobDTO;
import com.katalon.execution.dto.result.TestCaseExecutionResult;
import com.katalon.execution.dto.result.TestEntityExecutionResult;
import com.katalon.execution.dto.result.TestStepExecutionResult;
import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.logrecord.MessageLogRecord;
import com.katalon.execution.model.logrecord.TestCaseLogRecord;
import com.katalon.execution.model.logrecord.TestStepLogRecord;
import com.katalon.execution.model.logrecord.TestSuiteLogRecord;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.TestExecutionPlan;
import com.katalon.execution.model.steps.TestExecutionStep;
import com.katalon.execution.model.steps.TestReportingPhase;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.entity.report.ReportCollectionEntity;
import com.kms.katalon.entity.report.ReportItemDescription;
import com.kms.katalon.execution.entity.EmailConfig;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.framework.Bundle;

public class Debugger {
    public static void printMessage(EntityExecution entityExecution, String message) {
        System.out.println("---- DEBUGGER: " + Debugger.shortId(entityExecution.getIdString()) + ": " + message);
    }

    public static void printIFileContent(IFile file) {
        try {
            String content = new String(file.getContents().readAllBytes());
            System.out.println("---- DEBUGGER: Content of file: " + String.valueOf(file.getFullPath()) + ") ----");
            System.out.println(content);
            System.out.println("---- End -----");
        }
        catch (Exception e) {
            System.out.println("Failed to read IFile content: " + e.getMessage());
        }
    }

    public static void printEntityExecution(EntityExecution entityExecution, String header) {
        System.out.println("==== " + header + " ====");
        Debugger.printEntityExecution(entityExecution);
        System.out.println("==== End of " + header + " ====\n");
    }

    public static void printEntityExecution(EntityExecution entityExecution) {
        BiFunction<EntityExecution, String, Void> printFunc = (ee, indent) -> {
            String shortName = ee.getClass().getSimpleName() + "(" + Debugger.shortId(ee.getIdString()) + ")";
            List<Object> childRecordStatusValues = List.of();
            if (ee instanceof TestSuiteExecution) {
                TestSuiteExecution tse = (TestSuiteExecution)ee;
                shortName = shortName + " (" + tse.getAttempts().size() + " attempt(s))";
            } else if (ee instanceof TestSuiteExecutionAttempt) {
                TestSuiteExecutionAttempt tsea = (TestSuiteExecutionAttempt)ee;
                shortName = shortName + " (Attempt " + tsea.getAttemptIndex() + ")";
            } else if (ee instanceof TestCaseExecutionAttempt) {
                TestCaseExecutionAttempt tcea = (TestCaseExecutionAttempt)ee;
                shortName = shortName + " (Attempt " + tcea.getAttemptIndex() + ")";
                shortName = shortName + " - " + tcea.getLogRecords().size() + " log record(s)";
                childRecordStatusValues = tcea.getLogRecords().stream().map(LogRecord::getTestStatus).toList();
            }
            String description = Debugger.getSummary(ee) + " - " + ee.getExecutedTestCaseCount() + "/" + ee.getTestCaseCount() + " - " + String.valueOf(ee.getDescendantTestCaseStats());
            System.out.println(indent + shortName + " - " + description);
            if (childRecordStatusValues.size() > 0) {
                String childSummary = String.join((CharSequence)", ", childRecordStatusValues.stream().map(TestStatus::getStatusValue).map(Enum::name).toList());
                System.out.println(indent + indent + childSummary);
            }
            return null;
        };
        Debugger.printTree(entityExecution, "", printFunc);
    }

    public static void printLogRecords(LogRecord logRecord, String indent, String header) {
        System.out.println("==== " + header + " ====\n");
        Debugger.printLogRecords(logRecord, indent);
        System.out.println("==== End of " + header + " ====\n");
    }

    private static void printLogRecords(LogRecord logRecord, String indent) {
        if (logRecord instanceof MessageLogRecord) {
            return;
        }
        String summary = logRecord.getClass().getSimpleName() + "(" + Debugger.shortId(logRecord.getId()) + ")";
        Map runData = null;
        if (logRecord instanceof TestSuiteLogRecord) {
            TestSuiteLogRecord testSuiteLogRecord = (TestSuiteLogRecord)logRecord;
            summary = summary + " - " + testSuiteLogRecord.getName();
            runData = testSuiteLogRecord.getRunData();
        } else if (logRecord instanceof TestCaseLogRecord) {
            TestCaseLogRecord testCaseLogRecord = (TestCaseLogRecord)logRecord;
            summary = summary + " - " + testCaseLogRecord.getName();
            runData = testCaseLogRecord.getRunData();
        } else if (logRecord instanceof TestStepLogRecord) {
            TestStepLogRecord testStepLogRecord = (TestStepLogRecord)logRecord;
            summary = summary + " - " + Debugger.shortMessage(testStepLogRecord.getName());
            summary = summary + " - " + Debugger.shortMessage(testStepLogRecord.getMessage());
            if (testStepLogRecord.isTestListenerStep()) {
                summary = summary + " [Test Listener Step]";
            }
        } else if (logRecord instanceof MessageLogRecord) {
            MessageLogRecord messageLogRecord = (MessageLogRecord)logRecord;
            summary = summary + " - " + Debugger.shortMessage(messageLogRecord.getMessage());
        }
        System.out.println(indent + summary);
        if (runData != null && !runData.isEmpty()) {
            System.out.println(indent + "  | Run data: " + Debugger.shortMessage(Debugger.jsonString(runData.keySet())));
        }
        if (logRecord.getProperties() != null && !logRecord.getProperties().isEmpty()) {
            System.out.println(indent + "  | Props: " + Debugger.shortMessage(Debugger.jsonString(logRecord.getProperties().keySet())));
        }
        String nextIndent = indent + "  ";
        for (LogRecord childRecord : logRecord.getChildRecords()) {
            Debugger.printLogRecords(childRecord, nextIndent);
        }
    }

    public static void printLogRecordsOfExecution(EntityExecution entityExecution, String header) {
        System.out.println("==== " + header + " ====\n");
        if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution tcExecution = (TestCaseExecution)entityExecution;
            Debugger.printLogRecords((LogRecord)tcExecution.getFirstAttempt().getTestCaseLogRecord(), "", "TestCaseLogRecord");
        }
        if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution tsExecution = (TestSuiteExecution)entityExecution;
            Debugger.printLogRecords((LogRecord)tsExecution.getFirstAttempt().getTestSuiteLogRecord(), "", "TestSuiteLogRecord");
        }
        System.out.println("==== End of " + header + " ====\n");
    }

    public static void printLinkTestStepToTestCaseAttempt(String testStepId, String testCaseAttemptId) {
        System.out.println("Link TestStep(" + Debugger.shortId(testStepId) + ") to TestCaseAttempt(" + Debugger.shortId(testCaseAttemptId) + ")");
    }

    public static void printResultDTOs(List<TestEntityExecutionResult> entityResults, String header) {
        boolean shouldSkipTestSteps = true;
        List<TestEntityExecutionResult> filteredResults = !shouldSkipTestSteps ? entityResults : entityResults.stream().filter(r -> r.type != TestEntityExecutionResult.TestExecutionType.TEST_STEP && r.type != TestEntityExecutionResult.TestExecutionType.TEST_CASE_LISTENER && r.type != TestEntityExecutionResult.TestExecutionType.TEST_STEP_OF_TEST_SUITE).toList();
        if (filteredResults.isEmpty()) {
            return;
        }
        System.out.println("==== " + header + " ====");
        Debugger.printResultDTOs(filteredResults);
        System.out.println("==== End of " + header + " ====\n");
    }

    private static void printResultDTOs(List<TestEntityExecutionResult> entityResults) {
        boolean shouldPrintDetails = false;
        for (TestEntityExecutionResult result : entityResults) {
            TestStepExecutionResult tsr;
            System.out.println(String.valueOf(result.type) + "(" + Debugger.shortId(result.id) + "): parent = " + Debugger.shortId(result.parentId) + ", anchorChild = " + Debugger.shortId(result.anchorChildId) + ", name = " + result.name + ", " + String.valueOf(result.executionJobStatus) + " / " + String.valueOf(result.executionTestResult) + ", endTime = " + result.endTime);
            if (!shouldPrintDetails) continue;
            if (result.failedReason != null && !result.failedReason.isEmpty()) {
                System.out.println("  - Failed reason: " + Debugger.shortMessage(result.failedReason));
            }
            if (result instanceof TestCaseExecutionResult) {
                TestCaseExecutionResult tcr = (TestCaseExecutionResult)result;
                if (tcr.executionInfo != null && !tcr.executionInfo.isEmpty()) {
                    System.out.println("  - Execution info: " + Debugger.jsonString(tcr.executionInfo));
                }
                if (tcr.dataBinding != null && !tcr.dataBinding.isEmpty()) {
                    System.out.println("  - Data binding: " + Debugger.jsonString(tcr.dataBinding));
                }
                if (tcr.variables != null && !tcr.variables.isEmpty()) {
                    System.out.println("  - Variables: " + Debugger.jsonString(tcr.variables));
                }
            }
            if (!(result instanceof TestStepExecutionResult) || (tsr = (TestStepExecutionResult)result).getSelfHealingInfo() == null || !tsr.getSelfHealingInfo().applied) continue;
            System.out.println("  - Self-healing applied:");
            if (tsr.getSelfHealingInfo().report == null) continue;
            for (String reportLine : tsr.getSelfHealingInfo().report) {
                System.out.println("    * " + reportLine);
            }
        }
    }

    public static void printInsertParentRequestDTO(TestEntityExecutionResult result) {
        System.out.println("-------- Insert " + String.valueOf(result.type) + "(" + Debugger.shortId(result.id) + ") as parent of childId: " + Debugger.shortId(result.anchorChildId));
    }

    public static void printPlan(TestExecutionPlan testExecutionPlan) {
        BiFunction<EntityExecution, String, Void> printFunc = (ee, indent) -> {
            String shortName = ee.getClass().getSimpleName() + "(" + Debugger.shortId(ee.getIdString()) + ")";
            System.out.println(indent + shortName);
            return null;
        };
        System.out.println("---- Plan ----");
        Debugger.printTree(testExecutionPlan.getExecution(), "", printFunc);
        TestReportingPhase reportingPhase = testExecutionPlan.getReporting();
        if (reportingPhase != null) {
            for (TestExecutionStep step : reportingPhase.getChildren()) {
                System.out.println(step);
            }
        }
        System.out.println("---- End -----");
    }

    public static void printReportingPhase(TestReportingPhase testReportingPhase) {
        if (testReportingPhase != null) {
            System.out.println(String.valueOf(testReportingPhase) + ": status = " + String.valueOf(testReportingPhase.getExecutionJobStatus()));
            for (TestExecutionStep step : testReportingPhase.getChildren()) {
                System.out.println("    " + String.valueOf(step) + ": status = " + String.valueOf(step.getExecutionJobStatus()));
            }
        }
    }

    public static void printJobDTO(JobDTO jobDTO, String header) {
        System.out.println("==== " + header + " ====");
        Debugger.printPOJO(jobDTO);
        System.out.println("==== End of " + header + " ====\n");
    }

    public static void printEmailConfig(EmailConfig emailConfig, Map<String, Object> variables) {
        System.out.println("Email Config:");
        System.out.println("  Subject: " + emailConfig.getSubject());
        System.out.println("  Username: " + emailConfig.getUsername());
        System.out.println("  From Address: " + emailConfig.getFrom());
        System.out.println("  To: " + String.join((CharSequence)", ", emailConfig.getTos()));
        System.out.println("  Recipients: " + String.join((CharSequence)", ", emailConfig.getRecipients()));
        if (variables == null || variables.isEmpty()) {
            return;
        }
        System.out.println("  Variables:");
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            System.out.println("    " + entry.getKey() + ": " + String.valueOf(entry.getValue()));
        }
    }

    public static void printReportCollectionEntity(ReportCollectionEntity reportCollectionEntity) {
        System.out.println("Report Collection Entity:");
        System.out.println("  Location: " + reportCollectionEntity.getLocation());
        System.out.println("  Display Name: " + reportCollectionEntity.getDisplayName());
        System.out.println("  Test Suite Collection ID: " + reportCollectionEntity.getTestSuiteCollectionId());
        System.out.println("  Report Items:");
        for (ReportItemDescription item : reportCollectionEntity.getReportItemDescriptions()) {
            System.out.println("    Report Location: " + item.getReportLocation());
            System.out.println("    Run Config: " + String.valueOf(item.getRunConfigDescription()));
            System.out.println("    Test Case Amount: " + item.getTestCaseAmount());
        }
    }

    public static void printPOJO(Object object, String header) {
        System.out.println("==== " + header + " ====");
        System.out.println(Debugger.jsonString(object));
        System.out.println("==== End of " + header + " ====\n");
    }

    public static void printPOJO(Object object) {
        System.out.println(Debugger.jsonString(object));
    }

    public static String jsonString(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            return "Failed to convert POJO to JSON string: " + e.getMessage();
        }
    }

    public static void spyE4Events(IEventBroker eventBroker) {
        String allTopic = "*";
        eventBroker.subscribe(allTopic, event -> {
            if (event.getTopic().contains("requestEnablementUpdate")) {
                System.out.println(">>> E4 event: " + event.getTopic() + " ----");
                Object data = event.getProperty("org.eclipse.e4.data");
                Debugger.printPOJO(data);
            }
        });
    }

    public static void scheduleDebugConfigCheck() {
        new Thread(() -> {
            try {
                Bundle debugBundle = Platform.getBundle((String)"org.eclipse.debug.core");
                int maxWait = 10;
                while (debugBundle.getState() != 32 && maxWait > 0) {
                    Thread.sleep(1000L);
                    --maxWait;
                }
                if (debugBundle.getState() == 32) {
                    Debugger.printRegisteredLaunchConfigurationTypes();
                }
            }
            catch (InterruptedException interruptedException) {}
        }).start();
    }

    private static void printRegisteredLaunchConfigurationTypes() {
        ILaunchConfigurationType[] types = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
        System.out.println("=== BEGIN: Debug Plugin Active ===");
        System.out.println("=== Registered Launch Configuration Types ===");
        ILaunchConfigurationType[] iLaunchConfigurationTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationType type = iLaunchConfigurationTypeArray[n2];
            System.out.println("Type: " + type.getIdentifier());
            ++n2;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.debug.core.launchConfigurationTypes");
        System.out.println("=== Extension Registry Launch Configs ===");
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n3 = elements.length;
        int n4 = 0;
        while (n4 < n3) {
            IConfigurationElement element = iConfigurationElementArray[n4];
            System.out.println("Found: " + element.getAttribute("id"));
            ++n4;
        }
        System.out.println("=== END: Debug Plugin Active ===");
    }

    public static void printAggregatedTestResult(LogRecord logRecord, String header) {
        if (logRecord instanceof TestCaseLogRecord) {
            System.out.println("==== " + header + " ====");
            TestStatus status = logRecord.getTestStatus();
            List<TestStatus> childStatuses = logRecord.getChildRecords().stream().map(LogRecord::getTestStatus).toList();
            System.out.println("Children: " + String.join((CharSequence)", ", childStatuses.stream().map(TestStatus::getStatusValue).map(Enum::name).toList()));
            System.out.println("End time: " + logRecord.getEndTime());
            System.out.println("Aggregated: " + status.getStatusValue().name());
            System.out.println("==== End of " + header + " ====\n");
        }
    }

    private static String shortId(String id) {
        if (id == null) {
            return "N/A";
        }
        if (id.length() <= 8) {
            return id;
        }
        return id.substring(0, 8);
    }

    private static String shortMessage(String message) {
        if (message == null) {
            return "";
        }
        if (message.length() <= 80) {
            return message;
        }
        return message.substring(0, 77).replace("\n", "") + "...";
    }

    private static void printTree(EntityExecution entityExecution, String indent, BiFunction<EntityExecution, String, Void> printFunc) {
        printFunc.apply(entityExecution, indent);
        String nextIndent = indent + "  ";
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tsce = (TestSuiteCollectionExecution)entityExecution;
            tsce.getTestSuiteExecutions().forEach(child -> Debugger.printTree((EntityExecution)child, nextIndent, printFunc));
        } else if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution tse = (TestSuiteExecution)entityExecution;
            tse.getAttempts().forEach(child -> Debugger.printTree((EntityExecution)child, nextIndent, printFunc));
        } else if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt tsea = (TestSuiteExecutionAttempt)entityExecution;
            tsea.getTestCaseExecutions().forEach(child -> Debugger.printTree((EntityExecution)child, nextIndent, printFunc));
        } else if (entityExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution tce = (TestCaseBindingExecution)entityExecution;
            tce.getIterations().forEach(child -> Debugger.printTree((EntityExecution)child, nextIndent, printFunc));
        } else if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution tce = (TestCaseExecution)entityExecution;
            tce.getAttempts().forEach(child -> Debugger.printTree((EntityExecution)child, nextIndent, printFunc));
        }
    }

    private static String getSummary(EntityExecution entityExecution) {
        String failedReason;
        Object summary = entityExecution.getExecutionJobStatus().toString();
        if (entityExecution.getEndDate() != null) {
            summary = (String)summary + " (" + String.valueOf(entityExecution.getDurationInMilliseconds().orElse(0)) + " ms)";
        }
        if (entityExecution.getJobFailedReason().isPresent()) {
            failedReason = (String)entityExecution.getJobFailedReason().get();
            summary = (String)summary + " (" + failedReason + ")";
        }
        summary = (String)summary + " / ";
        summary = (String)summary + (entityExecution.getTestResult().isPresent() ? ((ExecutionTestResult)entityExecution.getTestResult().get()).name() : "N/A");
        if (entityExecution.getTestFailedReason().isPresent()) {
            failedReason = (String)entityExecution.getTestFailedReason().get();
            summary = (String)summary + " (" + Debugger.shortMessage(failedReason) + ")";
        }
        return summary;
    }
}

