/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.util;

import com.katalon.execution.model.ExecutionTestResult;
import com.katalon.execution.model.logrecord.LogRecord;
import com.katalon.execution.model.steps.EntityExecution;
import com.katalon.execution.model.steps.testcase.TestCaseBindingExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecution;
import com.katalon.execution.model.steps.testcase.TestCaseExecutionAttempt;
import com.katalon.execution.model.steps.testsuite.TestSuiteCollectionExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecution;
import com.katalon.execution.model.steps.testsuite.TestSuiteExecutionAttempt;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityExecutionTraverser {
    private static final Logger logger = LoggerFactory.getLogger(EntityExecutionTraverser.class);

    public static void traverse(EntityExecution entityExecution, Predicate<EntityExecution> predicate, Function<EntityExecution, Void> function) {
        if (!predicate.test(entityExecution)) {
            return;
        }
        function.apply(entityExecution);
        if (entityExecution instanceof TestSuiteCollectionExecution) {
            TestSuiteCollectionExecution tsce = (TestSuiteCollectionExecution)entityExecution;
            tsce.getTestSuiteExecutions().forEach(child -> EntityExecutionTraverser.traverse((EntityExecution)child, predicate, function));
        } else if (entityExecution instanceof TestSuiteExecution) {
            TestSuiteExecution tse = (TestSuiteExecution)entityExecution;
            tse.getAttempts().forEach(child -> EntityExecutionTraverser.traverse((EntityExecution)child, predicate, function));
        } else if (entityExecution instanceof TestSuiteExecutionAttempt) {
            TestSuiteExecutionAttempt tsea = (TestSuiteExecutionAttempt)entityExecution;
            tsea.getTestCaseExecutions().forEach(child -> EntityExecutionTraverser.traverse((EntityExecution)child, predicate, function));
        } else if (entityExecution instanceof TestCaseBindingExecution) {
            TestCaseBindingExecution tce = (TestCaseBindingExecution)entityExecution;
            tce.getIterations().forEach(child -> EntityExecutionTraverser.traverse((EntityExecution)child, predicate, function));
        } else if (entityExecution instanceof TestCaseExecution) {
            TestCaseExecution tce = (TestCaseExecution)entityExecution;
            tce.getAttempts().forEach(child -> EntityExecutionTraverser.traverse((EntityExecution)child, predicate, function));
        }
    }

    public static void traverse(LogRecord logRecord, Predicate<LogRecord> predicate, Function<LogRecord, Void> function) {
        if (!predicate.test(logRecord)) {
            return;
        }
        function.apply(logRecord);
        logRecord.getChildRecords().forEach(child -> EntityExecutionTraverser.traverse(child, predicate, function));
    }

    public static List<EntityExecution> collectUnfinishedExecutions(EntityExecution entityExecution) {
        ArrayList<EntityExecution> changedExecution = new ArrayList<EntityExecution>();
        Predicate<EntityExecution> incomplete = e -> e.getExecutionJobStatus().isUnhappyFinal() && e.getTestResult().isPresent() && e.getTestResult().get() != ExecutionTestResult.NOT_RUN;
        Function<EntityExecution, Void> collect = e -> {
            changedExecution.add((EntityExecution)e);
            return null;
        };
        EntityExecutionTraverser.traverse(entityExecution, incomplete, collect);
        EntityExecution currentExecution = entityExecution;
        while (currentExecution.getParentEntityExecution() != null) {
            if (incomplete.test(currentExecution.getParentEntityExecution())) {
                collect.apply(currentExecution.getParentEntityExecution());
            }
            currentExecution = currentExecution.getParentEntityExecution();
        }
        return changedExecution;
    }

    public static List<LogRecord> collectUnfinishedLogRecords(List<EntityExecution> entityExecutions) {
        ArrayList<LogRecord> changedLogRecords = new ArrayList<LogRecord>();
        Predicate<LogRecord> incomplete = lr -> !lr.getTestStatusValue().isFinal();
        Function<LogRecord, Void> collect = lr -> {
            changedLogRecords.add((LogRecord)lr);
            return null;
        };
        for (EntityExecution entityExecution : entityExecutions) {
            if (entityExecution instanceof TestCaseExecutionAttempt) {
                TestCaseExecutionAttempt tcea = (TestCaseExecutionAttempt)entityExecution;
                tcea.getLogRecords().forEach(logRecord -> EntityExecutionTraverser.traverse(logRecord, incomplete, collect));
                continue;
            }
            if (!(entityExecution instanceof TestSuiteExecutionAttempt)) continue;
            TestSuiteExecutionAttempt tsea = (TestSuiteExecutionAttempt)entityExecution;
            tsea.getLogRecords().forEach(logRecord -> EntityExecutionTraverser.traverse(logRecord, incomplete, collect));
        }
        return changedLogRecords;
    }
}

