/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.execution.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlowStepTracker {
    private static final Logger logger = LoggerFactory.getLogger(SlowStepTracker.class);
    private final Map<String, Long> stepStartTimes = new HashMap<String, Long>();
    private final long SLOW_STEP_THRESHOLD_MS = 100L;

    public void trackStart(String stepName) {
        this.stepStartTimes.put(stepName, System.currentTimeMillis());
    }

    public void trackEnd(String stepName) {
        long duration;
        Long startTime = this.stepStartTimes.remove(stepName);
        if (startTime != null && (duration = System.currentTimeMillis() - startTime) > 100L) {
            logger.warn("Slow step detected: {} took {} ms", (Object)stepName, (Object)duration);
        }
    }
}

