/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import groovy.lang.Binding;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.codehaus.groovy.eclipse.debug.JDIComparator;
import org.codehaus.groovy.eclipse.debug.JDIMetaClass;
import org.codehaus.groovy.eclipse.debug.JDITargetDelegate;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.LambdaUtils;

public class JDIBinding
extends Binding {
    private final JDITargetDelegate delegate;

    JDIBinding(JDITargetDelegate delegate, IJavaStackFrame stackFrame, IJavaValue thisObject) throws DebugException {
        super(JDIBinding.variables(delegate, stackFrame, thisObject));
        this.delegate = delegate;
        this.setMetaClass(new JDIMetaClass(this.getThis(), delegate));
    }

    private static Map<String, Object> variables(JDITargetDelegate delegate, IJavaStackFrame stackFrame, IJavaValue thisObject) throws DebugException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (stackFrame != null) {
            IJavaVariable[] iJavaVariableArray = stackFrame.getLocalVariables();
            int n = iJavaVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaVariable variable = iJavaVariableArray[n2];
                map.put(variable.getName(), variable);
                ++n2;
            }
            for (IJavaVariable variable : LambdaUtils.getLambdaFrameVariables((IStackFrame)stackFrame)) {
                String variableName = variable.getName();
                if (!variableName.startsWith("val$")) continue;
                map.put(variableName.substring(4), variable);
            }
            map.put("this", stackFrame.isStatic() ? stackFrame.getReferenceType().getClassObject() : stackFrame.getThis());
        } else if (thisObject != null) {
            map.put("this", thisObject);
        }
        map.put("__comparator", new JDIComparator(delegate));
        return map;
    }

    IJavaObject getThis() {
        return (IJavaObject)super.getVariable("this");
    }

    public Map getVariables() {
        return super.getVariables().keySet().stream().filter(name -> !"this".equals(name)).collect(Collectors.toMap(name -> name, this::getVariable));
    }

    public Object getVariable(String variableName) {
        Object o = super.getVariable(variableName);
        if (o instanceof IVariable) {
            try {
                IJavaValue value = (IJavaValue)((IVariable)o).getValue();
                return this.delegate.createProxyFor(value);
            }
            catch (DebugException e) {
                throw new RuntimeException(e);
            }
        }
        return o;
    }

    public void removeVariable(String variableName) {
    }

    public void setVariable(String variableName, Object newValue) {
        if ("this".equals(variableName) || "__comparator".equals(variableName)) {
            throw new IllegalArgumentException(variableName);
        }
        try {
            IJavaObject jdiValue = this.delegate.toJDIObject(newValue);
            if (this.hasVariable(variableName)) {
                IVariable variable = (IVariable)super.getVariable(variableName);
                if (((IJavaVariable)variable).getSignature().length() == 1) {
                    jdiValue = this.delegate.toJDIValue(jdiValue);
                }
                variable.setValue((IValue)jdiValue);
            } else {
                this.getMetaClass().setProperty((Object)this.getThis(), variableName, (Object)jdiValue);
            }
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }
}

