/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import org.codehaus.groovy.eclipse.debug.JDITargetDelegate;
import org.codehaus.groovy.syntax.Token;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaValue;

public class JDIComparator {
    private final JDITargetDelegate delegate;
    private final IJavaClassType scriptBytecodeAdapter;

    public JDIComparator(JDITargetDelegate delegate) throws DebugException {
        this.delegate = delegate;
        this.scriptBytecodeAdapter = (IJavaClassType)delegate.getType("org.codehaus.groovy.runtime.ScriptBytecodeAdapter");
    }

    public Integer compareTo(Object o1, Object o2) throws DebugException {
        IJavaObject v1 = this.delegate.toJDIObject(o1);
        IJavaObject v2 = this.delegate.toJDIObject(o2);
        IJavaValue result = this.scriptBytecodeAdapter.sendMessage("compareTo", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Integer;", new IJavaValue[]{v1, v2}, this.delegate.getThread());
        return this.delegate.convertToInteger(result);
    }

    private boolean invoke(String methodName, Object o1, Object o2) throws DebugException {
        IJavaObject v1 = this.delegate.toJDIObject(o1);
        IJavaObject v2 = this.delegate.toJDIObject(o2);
        IJavaPrimitiveValue result = (IJavaPrimitiveValue)this.scriptBytecodeAdapter.sendMessage(methodName, "(Ljava/lang/Object;Ljava/lang/Object;)Z", new IJavaValue[]{v1, v2}, this.delegate.getThread());
        return result.getBooleanValue();
    }

    public boolean isCase(Object o1, Object o2) throws DebugException {
        return this.invoke("isCase", o1, o2);
    }

    public boolean isEqual(Object o1, Object o2) throws DebugException {
        return this.invoke("compareEqual", o1, o2);
    }

    public boolean isGreaterThan(Object o1, Object o2) throws DebugException {
        return this.invoke("compareGreaterThan", o1, o2);
    }

    public boolean isGreaterThanOrEqual(Object o1, Object o2) throws DebugException {
        return this.invoke("compareGreaterThanEqual", o1, o2);
    }

    public boolean isIdentical(Object o1, Object o2) throws DebugException {
        return this.invoke("compareIdentical", o1, o2);
    }

    public boolean isLessThan(Object o1, Object o2) throws DebugException {
        return this.invoke("compareLessThan", o1, o2);
    }

    public boolean isLessThanOrEqual(Object o1, Object o2) throws DebugException {
        return this.invoke("compareLessThanEqual", o1, o2);
    }

    public boolean isNotCase(Object o1, Object o2) throws DebugException {
        return this.invoke("isNotCase", o1, o2);
    }

    public boolean isNotEqual(Object o1, Object o2) throws DebugException {
        return this.invoke("compareNotEqual", o1, o2);
    }

    public boolean isNotIdentical(Object o1, Object o2) throws DebugException {
        return this.invoke("compareNotIdentical", o1, o2);
    }

    static String methodNameFor(Token operation) {
        switch (operation.getType()) {
            case 128: {
                return "compareTo";
            }
            case 124: {
                return "isLessThan";
            }
            case 126: {
                return "isGreaterThan";
            }
            case 125: {
                return "isLessThanOrEqual";
            }
            case 127: {
                return "isGreaterThanOrEqual";
            }
            case 544: 
            case 573: {
                return "isCase";
            }
            case 129: 
            case 130: {
                return "isNotCase";
            }
            case 123: {
                return "isEqual";
            }
            case 120: {
                return "isNotEqual";
            }
            case 121: {
                return "isIdentical";
            }
            case 122: {
                return "isNotIdentical";
            }
        }
        return null;
    }
}

