/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyIndentationService;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.ui.text.java.JavaAutoIndentStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

class GroovyAutoIndentStrategy
implements IAutoEditStrategy {
    private final GroovyIndentationService indentService;
    private final JavaAutoIndentStrategy javaStrategy;
    private final boolean closeBraces;

    GroovyAutoIndentStrategy(JavaAutoIndentStrategy javaStrategy) {
        this.javaStrategy = javaStrategy;
        ReflectionUtils.executePrivateMethod(JavaAutoIndentStrategy.class, (String)"clearCachedValues", (Object)javaStrategy);
        this.closeBraces = (Boolean)ReflectionUtils.getPrivateField(JavaAutoIndentStrategy.class, (String)"fCloseBrace", (Object)javaStrategy);
        this.indentService = GroovyIndentationService.get((IJavaProject)((IJavaProject)ReflectionUtils.getPrivateField(JavaAutoIndentStrategy.class, (String)"fProject", (Object)javaStrategy)));
    }

    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.doit) {
            try {
                if (c.length == 0 && this.isNewline(d, c.text)) {
                    this.autoEditAfterNewline(d, c);
                } else if (c.text.length() > 2) {
                    this.smartPaste(d, c);
                } else if ("{".equals(c.text) || "}".equals(c.text)) {
                    this.javaStrategy.customizeDocumentCommand(d, c);
                }
            }
            finally {
                this.indentService.disposePrefs();
            }
        }
    }

    private void smartPaste(IDocument d, DocumentCommand c) {
        try {
            if (this.indentService.getPrefs().isSmartPaste() && this.indentService.isInEmptyLine(d, c.offset)) {
                int pasteLine = d.getLineOfOffset(c.offset);
                IRegion pasteLineRegion = d.getLineInformation(pasteLine);
                Document workCopy = new Document(d.get(0, pasteLineRegion.getOffset()));
                workCopy.replace(pasteLineRegion.getOffset(), 0, c.text);
                int startLine = workCopy.getLineOfOffset(pasteLineRegion.getOffset());
                int endLine = workCopy.getLineOfOffset(pasteLineRegion.getOffset() + c.text.length());
                int indentDiff = 0;
                boolean isMultiLineComment = false;
                boolean isMultiLineString = false;
                int line = startLine;
                while (line <= endLine) {
                    IRegion lineRegion = workCopy.getLineInformation(line);
                    String text = workCopy.get(lineRegion.getOffset(), lineRegion.getLength());
                    if (line - startLine < 2) {
                        oldIndentLevel = this.indentService.getLineIndentLevel((IDocument)workCopy, line);
                        newIndentLevel = this.indentService.computeIndentForLine((IDocument)workCopy, line);
                        if (isMultiLineComment) {
                            this.indentService.fixIndentation(workCopy, line, ++newIndentLevel);
                        } else if (!isMultiLineString) {
                            this.indentService.fixIndentation(workCopy, line, newIndentLevel);
                        }
                        indentDiff = newIndentLevel - oldIndentLevel;
                    } else {
                        oldIndentLevel = this.indentService.getLineIndentLevel((IDocument)workCopy, line);
                        newIndentLevel = oldIndentLevel + indentDiff;
                        if (isMultiLineComment) {
                            this.indentService.fixIndentation(workCopy, line, newIndentLevel);
                        } else if (!isMultiLineString) {
                            this.indentService.fixIndentation(workCopy, line, newIndentLevel);
                        }
                    }
                    if (text.indexOf("/*") != -1) {
                        isMultiLineComment = true;
                    }
                    if (text.indexOf("*/") != -1 && isMultiLineComment) {
                        isMultiLineComment = false;
                    } else if (!(text.indexOf("\"\"\"") == -1 && text.indexOf("'''") == -1 || isMultiLineComment)) {
                        isMultiLineString = !isMultiLineString;
                    }
                    ++line;
                }
                int workStart = workCopy.getLineOffset(startLine);
                int workEnd = workCopy.getLineOffset(endLine) + workCopy.getLineLength(endLine);
                c.text = workCopy.get(workStart, workEnd - workStart);
                c.offset = pasteLineRegion.getOffset();
                c.length = pasteLineRegion.getLength();
                c.caretOffset = c.offset + c.text.length();
                c.shiftsCaret = false;
            }
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Something went wrong in GroovyAutoIndentStrategy.smartPaste", e);
        }
    }

    private boolean isNewline(IDocument d, String s) {
        String[] delimiters = d.getLegalLineDelimiters();
        if (delimiters != null) {
            String[] stringArray = delimiters;
            int n = delimiters.length;
            int n2 = 0;
            while (n2 < n) {
                String nl = stringArray[n2];
                if (nl.equals(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private void autoEditAfterNewline(IDocument d, DocumentCommand c) {
        try {
            int lengthToCurly;
            int orgIndentLevel = this.indentService.getIndentLevel(d, c.offset);
            int indentLevel = this.indentService.computeIndentAfterNewline(d, c.offset);
            String indentation = this.indentService.createIndentation(indentLevel);
            c.text = String.valueOf(c.text) + indentation;
            if (this.closeBraces && this.shouldInsertBrace(d, c.offset, (lengthToCurly = this.indentService.lengthToNextCurly(d, c.offset)) > 0)) {
                c.length = lengthToCurly;
                int newCaret = c.offset + c.text.length();
                c.text = String.valueOf(c.text) + this.indentService.newline(d) + this.indentService.createIndentation(orgIndentLevel) + "}";
                c.caretOffset = newCaret;
                c.shiftsCaret = false;
            }
        }
        catch (Exception e) {
            GroovyPlugin.getDefault().logError("Something went wrong in GroovyAutoIndentStrategy.autoEditAfterNewline", e);
        }
    }

    private boolean shouldInsertBrace(IDocument d, int enterPos, boolean nextTokenIsCloseBrace) throws BadLocationException {
        if (this.indentService.moreOpenThanCloseBefore(d, enterPos) && (nextTokenIsCloseBrace || this.indentService.isEndOfLine(d, enterPos))) {
            String line;
            int lineNum = d.getLineOfOffset(enterPos);
            int indentLevel = this.indentService.getLineIndentLevel(d, lineNum);
            do {
                line = GroovyIndentationService.getLine((IDocument)d, (int)(++lineNum));
            } while ((line = line.trim()).isEmpty() && lineNum < d.getNumberOfLines());
            int nextIndentLevel = this.indentService.getLineIndentLevel(d, lineNum);
            if (nextIndentLevel > indentLevel) {
                return false;
            }
            if (nextIndentLevel < indentLevel) {
                return true;
            }
            return !line.startsWith("}");
        }
        return false;
    }
}

