/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.editor;

import org.codehaus.groovy.eclipse.preferences.PreferenceConstants;
import org.eclipse.jdt.internal.ui.text.JavaColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;

public class GroovyColorManager
extends JavaColorManager {
    private IPropertyChangeListener propertyChangeListener = event -> {
        if (event.getNewValue() != event.getOldValue() && this.fKeyTable.containsKey(event.getProperty())) {
            this.unbindColor(event.getProperty());
        }
    };

    public GroovyColorManager() {
        this.initialize();
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        super.dispose();
        PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    public void initialize() {
        IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
        this.bindColor("groovy.editor.highlight.gjdk.color", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"groovy.editor.highlight.gjdk.color"));
        this.bindColor("groovy.editor.highlight.javatypes.color", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"groovy.editor.highlight.javatypes.color"));
        this.bindColor("groovy.editor.highlight.javakeywords.color", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"groovy.editor.highlight.javakeywords.color"));
        this.bindColor("groovy.editor.highlight.assert.color", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"groovy.editor.highlight.assert.color"));
        this.bindColor("groovy.editor.highlight.return.color", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"groovy.editor.highlight.return.color"));
        this.bindColor("java_string", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"java_string"));
        this.bindColor("semanticHighlighting.annotation.color", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"semanticHighlighting.annotation.color"));
        this.bindColor("java_bracket", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"java_bracket"));
        this.bindColor("java_operator", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"java_operator"));
        this.bindColor("java_default", PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)"java_default"));
    }

    public void uninitialize() {
        this.unbindColor("groovy.editor.highlight.gjdk.color");
        this.unbindColor("groovy.editor.highlight.javatypes.color");
        this.unbindColor("groovy.editor.highlight.javakeywords.color");
        this.unbindColor("groovy.editor.highlight.assert.color");
        this.unbindColor("groovy.editor.highlight.return.color");
        this.unbindColor("java_string");
        this.unbindColor("semanticHighlighting.annotation.color");
        this.unbindColor("java_bracket");
        this.unbindColor("java_operator");
        this.unbindColor("java_default");
    }
}

