/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.frameworkadapter.util.SpecifiedVersion;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.osgi.framework.Version;

public class CompilerSwitchUIHelper {
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_REFRESH_BUNDLES = "-Declipse.refreshBundles=true";
    private static final String PROP_CLEAN = "-Dosgi.clean=true";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";

    public static Composite createCompilerSwitchBlock(Composite parent) {
        Composite compilerPanel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginBottom = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        compilerPanel.setLayout((Layout)layout);
        compilerPanel.setLayoutData((Object)new GridData(4, 0, true, false));
        Label compilerVersion = new Label(compilerPanel, 16384);
        compilerVersion.setText("You are currently using Groovy Compiler version " + CompilerUtils.getGroovyVersion());
        SpecifiedVersion activeGroovyVersion = CompilerUtils.getActiveGroovyVersion();
        SpecifiedVersion[] specifiedVersionArray = SpecifiedVersion.values();
        int n = specifiedVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Version bundleVersion;
            SpecifiedVersion version = specifiedVersionArray[n2];
            if (activeGroovyVersion != version && (bundleVersion = CompilerUtils.getBundleVersion((SpecifiedVersion)version)) != null) {
                Button switchTo = new Button(compilerPanel, 8);
                switchTo.addSelectionListener(CompilerSwitchUIHelper.switchTo(version));
                switchTo.setText("Switch to " + String.valueOf(bundleVersion));
            }
            ++n2;
        }
        Link moreInfoLink = new Link(compilerPanel, 0);
        moreInfoLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> CompilerSwitchUIHelper.openUrl(event.text)));
        moreInfoLink.setText("<a href=\"https://github.com/groovy/groovy-eclipse/wiki\">See here</a> for more information (opens a browser window).");
        return compilerPanel;
    }

    private static SelectionListener switchTo(SpecifiedVersion version) {
        return SelectionListener.widgetSelectedAdapter(event -> {
            Shell shell = ((Button)event.getSource()).getShell();
            boolean result = MessageDialog.openQuestion((Shell)shell, (String)"Change compiler and restart?", (String)"Do you want to change the compiler?\n\nIf you select \"Yes\", the compiler will be changed and Eclipse will be restarted.\n\nMake sure all your work is saved before clicking \"Yes\".");
            if (result) {
                IStatus status = CompilerUtils.switchVersions((SpecifiedVersion)CompilerUtils.getActiveGroovyVersion(), (SpecifiedVersion)version);
                if (status == Status.OK_STATUS) {
                    CompilerSwitchUIHelper.restart(shell);
                } else {
                    String errorString = "Error occurred when trying to enable Groovy " + version.toReadableVersionString();
                    ErrorDialog dialog = new ErrorDialog(shell, "Error occurred", errorString, status, 4);
                    dialog.open();
                }
            }
        });
    }

    private static void openUrl(String location) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (WebBrowserPreference.getBrowserChoice() == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception e) {
                    GroovyCore.logException((String)"Could not open browser", (Throwable)e);
                }
            } else {
                IWebBrowser browser = null;
                int flags = 0;
                flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? (flags |= 0x26) : (flags |= 0x86);
                browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, "org.eclipse.contribution.weaving.jdt", null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException e) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Browser initialization error", (String)"Browser could not be initiated");
        }
        catch (MalformedURLException e) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Malformed URL", (String)location);
        }
    }

    private static void restart(Shell shell) {
        String commandLine = CompilerSwitchUIHelper.buildCommandLine(shell);
        if (commandLine == null) {
            return;
        }
        System.out.println("Restart command line begin:\n " + commandLine);
        System.out.println("Restart command line end");
        System.setProperty(PROP_EXIT_DATA, commandLine);
        System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
        Workbench.getInstance().restart();
    }

    private static String buildCommandLine(Shell shell) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            MessageDialog.openError((Shell)shell, (String)"Missing System Property", (String)NLS.bind((String)"Unable to relaunch the platform because the {0} property has not been set.", (Object)PROP_VM));
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append(property);
        result.append(NEW_LINE);
        Object vmargs = System.getProperty(PROP_VMARGS, "");
        vmargs = (String)vmargs + "\n-Declipse.refreshBundles=true\n-Dosgi.clean=true\n";
        result.append((String)vmargs);
        property = System.getProperty(PROP_COMMANDS);
        if (property != null) {
            result.append(property);
        }
        if (vmargs != null) {
            result.append(CMD_VMARGS);
            result.append(NEW_LINE);
            result.append((String)vmargs);
        }
        return result.toString();
    }
}

