/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.session.composer.dialog;

import com.kms.katalon.session.core.model.SessionExpireSchedule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ReloginViaRememberDialog
extends MessageDialog {
    private static final int RELOGIN_ID = 0;
    private static final int LOGIN_WITH_ANOTHER_ACCOUNT_ID = 1025;
    private Runnable reloginHandler;
    private Runnable loginWithAnotherAccountHandler;

    public ReloginViaRememberDialog(Shell parentShell, SessionExpireSchedule.Reason expireReason) {
        super(parentShell, ReloginViaRememberDialogMessages.TITLE_KS_NOTIFICATION, null, ReloginViaRememberDialog.getExpireExplanation(expireReason), 0, new String[]{ReloginViaRememberDialogMessages.BTN_RELOGIN}, 0);
    }

    public void setReloginHandler(Runnable reloginHandler) {
        this.reloginHandler = reloginHandler;
    }

    public void setLoginWithAnotherAccountHandler(Runnable loginWithAnotherAccountHandler) {
        this.loginWithAnotherAccountHandler = loginWithAnotherAccountHandler;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, ReloginViaRememberDialogMessages.BTN_LOGIN_WITH_ANOTHER_ACCOUNT, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025 && this.loginWithAnotherAccountHandler != null) {
            this.loginWithAnotherAccountHandler.run();
            return;
        }
        super.buttonPressed(buttonId);
        if (buttonId == 0 && this.reloginHandler != null) {
            this.reloginHandler.run();
        }
    }

    protected void handleShellCloseEvent() {
        if (this.loginWithAnotherAccountHandler != null) {
            this.loginWithAnotherAccountHandler.run();
        }
        super.handleShellCloseEvent();
    }

    private static String getExpireExplanation(SessionExpireSchedule.Reason expireReason) {
        switch (expireReason) {
            case TOKEN_WILL_EXPIRE_AND_NO_WAY_TO_RENEW: 
            case TOKEN_WILL_EXPIRE_AND_FAILED_TO_RENEW: {
                return ReloginViaRememberDialogMessages.MSG_TOKEN_EXPIRE;
            }
            case LICENSE_EXPIRED: 
            case LICENSE_ERROR: {
                return ReloginViaRememberDialogMessages.MSG_LICENSE_EXPIRE;
            }
            case USER_IDLE: {
                return ReloginViaRememberDialogMessages.MSG_USER_IDLE;
            }
        }
        return ReloginViaRememberDialogMessages.MSG_UNKNOWN_EXPIRE;
    }

    public static class ReloginViaRememberDialogMessages
    extends NLS {
        private static final String BUNDLE_NAME = "com.kms.katalon.session.composer.dialog.ReloginViaRememberDialogMessages";
        public static String TITLE_KS_NOTIFICATION;
        public static String BTN_RELOGIN;
        public static String BTN_LOGIN_WITH_ANOTHER_ACCOUNT;
        public static String MSG_TOKEN_EXPIRE;
        public static String MSG_LICENSE_EXPIRE;
        public static String MSG_USER_IDLE;
        public static String MSG_UNKNOWN_EXPIRE;

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, ReloginViaRememberDialogMessages.class);
        }
    }
}

