/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.configuration;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.mobile.configuration.impl.MobileExecutionSetting;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.driver.MobileDriverConnector;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public abstract class MobileRunConfiguration
extends AbstractRunConfiguration {
    protected MobileDriverConnector mobileDriverConnector;
    protected String projectDir;

    public MobileRunConfiguration(String projectDir, MobileDriverConnector mobileDriverConnector) throws IOException {
        this.mobileDriverConnector = mobileDriverConnector;
        this.projectDir = projectDir;
        this.doInitExecutionSetting();
    }

    public Map<String, IDriverConnector> getDriverConnectors() {
        LinkedHashMap<String, IDriverConnector> driverCollector = new LinkedHashMap<String, IDriverConnector>();
        driverCollector.put("Mobile", (IDriverConnector)this.mobileDriverConnector);
        return driverCollector;
    }

    public String getAppiumDir() {
        return (String)this.mobileDriverConnector.getSystemProperties().get("appiumDirectory");
    }

    public String getName() {
        return super.getName() + " - " + this.mobileDriverConnector.getDeviceId();
    }

    public String getReportDriverName() {
        return super.getName();
    }

    protected void initExecutionSetting() {
        this.executionSetting = new MobileExecutionSetting();
        ContextInjectionFactory.inject((Object)this.executionSetting, (IEclipseContext)this.context);
    }

    public IRunConfiguration.Type getType() {
        return IRunConfiguration.Type.MOBILE;
    }

    public void setDevice(MobileDeviceInfo device) {
        this.mobileDriverConnector.setDevice(device);
    }

    public MobileDeviceInfo getDevice() {
        return this.mobileDriverConnector.getDevice();
    }
}

