/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.mobile.device;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.execution.mobile.device.AndroidSDKManager;
import com.kms.katalon.execution.mobile.device.MobileDeviceInfo;
import com.kms.katalon.execution.mobile.exception.AndroidSDKNotFoundException;
import com.kms.katalon.execution.mobile.exception.AndroidSetupException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class AndroidDeviceInfo
extends MobileDeviceInfo {
    private static final String BIN = "bin";
    private static final String UNIX_PATH_SEPARATOR = ":";
    private static final String WIN32_PATH_SEPARATOR = ";";
    private static final String PATH = "PATH";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String JRE = "jre";
    private static final String MAC_JRE_HOME_RELATIVE_PATH = "jre" + File.separator + "Contents" + File.separator + "Home";
    private static final String EMULATOR_SUFFIX = ")";
    private static final String FOR_ANDROID_VERSION = " - Android ";
    private static final String ANDROID_EMULATOR_PREFIX = "emulator-";
    private static final String ANDROID_HOME_ENVIRONMENT_VARIABLE_NAME = "ANDROID_HOME";
    private static final String ADB = "adb";
    private static final String RO_PRODUCT_MANUFACTURER = "ro.product.manufacturer";
    private static final String RO_PRODUCT_MODEL = "ro.product.model";
    private static final String RO_BUILD_VERSION_RELEASE = "ro.build.version.release";
    private static final String RO_QEMU_AVD_NAME = "ro.boot.qemu.avd_name";
    private static final String NET_BT_NAME = "net.bt.name";
    private static final String GETPROP_COMMAND = "getprop";
    private static final String SHELL = "shell";
    private static final String S_FLAG = "-s";
    private static String adbPath;
    private String emulatorName;
    private String deviceManufacture;
    private String deviceModel;
    private String deviceOs;
    private String deviceOSVersion;
    private boolean isEmulator;

    @Override
    public boolean isEmulator() {
        return this.isEmulator;
    }

    public AndroidDeviceInfo(String deviceId) throws AndroidSetupException, IOException, InterruptedException {
        super(deviceId);
        this.isEmulator = deviceId.startsWith(ANDROID_EMULATOR_PREFIX);
        this.initDeviceProperties();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.deviceId).append((Object)this.deviceManufacture).append((Object)this.deviceModel).append((Object)this.deviceModel).append((Object)this.deviceOSVersion).append((Object)this.deviceOs).append(this.isEmulator).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndroidDeviceInfo other = (AndroidDeviceInfo)obj;
        return new EqualsBuilder().append((Object)this.deviceId, (Object)other.deviceId).append((Object)this.deviceManufacture, (Object)other.deviceManufacture).append((Object)this.deviceModel, (Object)other.deviceModel).append((Object)this.deviceOSVersion, (Object)other.deviceOSVersion).append((Object)this.deviceOs, (Object)other.deviceOs).append(this.isEmulator, this.isEmulator).isEquals();
    }

    protected void initDeviceProperties() throws IOException, InterruptedException, AndroidSetupException {
        this.emulatorName = this.initEmulatorName();
        this.deviceManufacture = this.initAndroidDeviceManufacturer();
        this.deviceModel = this.initAndroidDeviceModel();
        this.deviceOs = this.initAndroidDeviceOS();
        this.deviceOSVersion = this.initAndroidDeviceOSVersion();
    }

    private String initEmulatorName() throws AndroidSetupException, IOException, InterruptedException {
        if (this.isEmulator) {
            String[] getAvdNameCommand = new String[]{AndroidDeviceInfo.getADBPath(), S_FLAG, this.deviceId, SHELL, GETPROP_COMMAND, RO_QEMU_AVD_NAME};
            return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])getAvdNameCommand);
        }
        return "";
    }

    private String initAndroidDeviceOS() throws AndroidSetupException, IOException, InterruptedException {
        String[] getOSCommand = new String[]{AndroidDeviceInfo.getADBPath(), S_FLAG, this.deviceId, SHELL, GETPROP_COMMAND, NET_BT_NAME};
        return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])getOSCommand);
    }

    private String initAndroidDeviceOSVersion() throws IOException, InterruptedException, AndroidSetupException {
        String[] getManufacturerCommand = new String[]{AndroidDeviceInfo.getADBPath(), S_FLAG, this.deviceId, SHELL, GETPROP_COMMAND, RO_BUILD_VERSION_RELEASE};
        return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])getManufacturerCommand);
    }

    private String initAndroidDeviceModel() throws AndroidSetupException, IOException, InterruptedException {
        String[] getAndroidDeviceModelCommand = new String[]{AndroidDeviceInfo.getADBPath(), S_FLAG, this.deviceId, SHELL, GETPROP_COMMAND, RO_PRODUCT_MODEL};
        return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])getAndroidDeviceModelCommand);
    }

    private String initAndroidDeviceManufacturer() throws IOException, InterruptedException, AndroidSetupException {
        String[] getManuFacturerCommand = new String[]{AndroidDeviceInfo.getADBPath(), S_FLAG, this.deviceId, SHELL, GETPROP_COMMAND, RO_PRODUCT_MANUFACTURER};
        return ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])getManuFacturerCommand);
    }

    public static File getAndroidSDKDirectory() throws IOException, AndroidSetupException {
        AndroidSDKManager androidSDKManager = new AndroidSDKManager();
        if (!androidSDKManager.checkSDKExists()) {
            throw new AndroidSDKNotFoundException();
        }
        return androidSDKManager.getSDKFolder();
    }

    public static String getADBPath() throws AndroidSetupException {
        if (StringUtils.isNotBlank((String)adbPath) && new File(adbPath).exists()) {
            return adbPath;
        }
        AndroidSDKManager androidSDKManager = new AndroidSDKManager();
        File platformToolsFolder = androidSDKManager.getSDKLocator().getPlatformToolsFolder();
        adbPath = new File(platformToolsFolder, ADB).getAbsolutePath();
        return adbPath;
    }

    public static void makeAllAndroidSDKBinaryExecutable() throws IOException, InterruptedException, AndroidSetupException {
        if ("win32".equals(Platform.getOS())) {
            return;
        }
        File androidSDKDirectory = AndroidDeviceInfo.getAndroidSDKDirectory();
        AndroidDeviceInfo.makeAllFileExecutable(androidSDKDirectory);
        AndroidDeviceInfo.makeFileExecutable(new File(AndroidDeviceInfo.getADBPath()));
    }

    private static void makeAllFileExecutable(File parentFolder) throws IOException, InterruptedException {
        if (!parentFolder.exists() || !parentFolder.isDirectory()) {
            return;
        }
        ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])new String[]{"chmod", "-R", "+x", parentFolder.getAbsolutePath()});
    }

    @Override
    public String getDisplayName() {
        if (this.isEmulator) {
            return this.getEmulatorName() + " (" + this.getDeviceId() + " - " + this.getDeviceModel() + FOR_ANDROID_VERSION + this.getDeviceOSVersion() + EMULATOR_SUFFIX;
        }
        return this.getDeviceManufacturer() + " " + this.getDeviceModel() + " (" + this.getDeviceOS() + " " + this.getDeviceOSVersion() + EMULATOR_SUFFIX;
    }

    @Override
    public String getDeviceName() {
        return this.getDisplayName();
    }

    @Override
    public String getDeviceManufacturer() {
        return this.deviceManufacture;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public String getDeviceOS() {
        return this.deviceOs;
    }

    @Override
    public String getDeviceOSVersion() {
        return this.deviceOSVersion;
    }

    private String getEmulatorName() {
        return this.emulatorName;
    }

    public static Map<String, String> getAndroidAdditionalEnvironmentVariables() throws IOException, AndroidSetupException {
        String androidSDKFolder = AndroidDeviceInfo.getAndroidSDKDirectory().getAbsolutePath();
        if (StringUtils.isEmpty((String)androidSDKFolder)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> addtionalEnvironmentVariables = new HashMap<String, String>();
        addtionalEnvironmentVariables.put(ANDROID_HOME_ENVIRONMENT_VARIABLE_NAME, androidSDKFolder);
        File jreFolder = AndroidDeviceInfo.getJREFolder();
        addtionalEnvironmentVariables.put(JAVA_HOME, jreFolder.getAbsolutePath());
        String path = System.getenv(PATH) + (Platform.getOS() == "win32" ? WIN32_PATH_SEPARATOR : UNIX_PATH_SEPARATOR) + String.valueOf(jreFolder) + File.separator + BIN;
        if (Platform.getOS().equals("macosx")) {
            path = path + ":/usr/local/bin/";
        }
        addtionalEnvironmentVariables.put(PATH, path);
        return addtionalEnvironmentVariables;
    }

    private static File getJREFolder() throws IOException {
        Bundle bundleExec = Platform.getBundle((String)"com.kms.katalon.core.mobile");
        File bundleFile = FileLocator.getBundleFile((Bundle)bundleExec);
        if (bundleFile.isDirectory()) {
            return new File(System.getProperty("java.home"));
        }
        File parentFile = AndroidDeviceInfo.getConfigurationFolder().getParentFile();
        if ("macosx".equals(Platform.getOS())) {
            return new File(parentFile, MAC_JRE_HOME_RELATIVE_PATH);
        }
        return new File(parentFile, JRE);
    }

    private static File getConfigurationFolder() throws IOException {
        File configurationFolder = new File(FileLocator.resolve((URL)Platform.getConfigurationLocation().getURL()).getFile());
        return configurationFolder;
    }
}

