/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelHelper {
    private static Logger logger = LoggerFactory.getLogger(ExcelHelper.class);

    public static Map<String, String> readFrom(String filePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            FileInputStream file = new FileInputStream(new File(filePath));
            XSSFWorkbook workbook = new XSSFWorkbook((InputStream)file);
            XSSFSheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                Iterator cellIterator = row.cellIterator();
                int i = 0;
                String key = "";
                String value = "";
                while (cellIterator.hasNext() && i < 2) {
                    Cell cell = (Cell)cellIterator.next();
                    if (i == 0) {
                        key = cell.getStringCellValue();
                    } else {
                        value = cell.getStringCellValue();
                    }
                    ++i;
                }
                map.put(key, value);
            }
            file.close();
        }
        catch (Exception e) {
            logger.error("Not an excel file or of expected format (two columns: key - value)", (Throwable)e);
        }
        return map;
    }
}

