/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.runtime.Assert;

public class EnclosingASTNodeFragment
implements IASTFragment {
    private final ASTNode node;

    EnclosingASTNodeFragment(ASTNode node) {
        this.node = node;
    }

    @Override
    public void accept(FragmentVisitor visitor) {
        visitor.previsit(this);
        visitor.visit(this);
    }

    @Override
    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        return null;
    }

    @Override
    public int fragmentLength() {
        return 1;
    }

    @Override
    public Expression getAssociatedExpression() {
        Assert.isLegal((boolean)false, (String)"EnclosingASTNodeFragment has no associated expression");
        return null;
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.node;
    }

    @Override
    public int getEnd() {
        return this.node.getEnd();
    }

    @Override
    public int getStart() {
        return this.node.getStart();
    }

    @Override
    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        char[] contents = unit.getContents();
        int end = this.getEnd();
        int start = this.node.getStart();
        while (end > start && Character.isWhitespace(contents[end])) {
            --end;
        }
        return end;
    }

    @Override
    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    @Override
    public ASTFragmentKind kind() {
        return ASTFragmentKind.ENCLOSING;
    }

    @Override
    public boolean matches(IASTFragment other) {
        return this.kind() == other.kind() && this.node == ((EnclosingASTNodeFragment)other).getAssociatedNode();
    }

    @Override
    public String print(int indentLvl) {
        return "(E) " + this.node.toString();
    }

    public String toString() {
        return this.print(0);
    }
}

