/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.collector;

import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.execution.configuration.contributor.IDriverConnectorContributor;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DriverConnectorCollector {
    private static DriverConnectorCollector _instance;
    private List<IDriverConnectorContributor> driverConnectorContributorList = new ArrayList<IDriverConnectorContributor>();

    private DriverConnectorCollector() {
    }

    public static DriverConnectorCollector getInstance() {
        if (_instance == null) {
            _instance = new DriverConnectorCollector();
        }
        return _instance;
    }

    public void addBuiltinDriverConnectorContributor(IDriverConnectorContributor driverConnectorContributor) {
        this.driverConnectorContributorList.add(driverConnectorContributor);
    }

    public Map<String, IDriverConnector> getDriverConnectors(File configFolder) throws IOException {
        LinkedHashMap<String, IDriverConnector> connectorCollectors = new LinkedHashMap<String, IDriverConnector>();
        block0: for (IDriverConnectorContributor driverConnectorContributor : this.driverConnectorContributorList) {
            IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(configFolder.getAbsolutePath());
            int n = iDriverConnectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDriverConnector driverConnector = iDriverConnectorArray[n2];
                if (new File(configFolder, driverConnector.getSettingFileName() + ".properties").exists()) {
                    connectorCollectors.put(driverConnectorContributor.getName(), driverConnector);
                    continue block0;
                }
                ++n2;
            }
        }
        return connectorCollectors;
    }

    public IDriverConnector getDriverConnector(String configFileName, String configFolderPath) throws IOException, ExecutionException {
        for (IDriverConnectorContributor driverConnectorContributor : this.driverConnectorContributorList) {
            IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(configFolderPath);
            int n = iDriverConnectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDriverConnector driverConnector = iDriverConnectorArray[n2];
                if ((driverConnector.getSettingFileName() + ".properties").equals(configFileName)) {
                    return driverConnector;
                }
                ++n2;
            }
        }
        return null;
    }

    public String getContributorName(IDriverConnector connector, String configFolderPath) throws IOException {
        for (IDriverConnectorContributor driverConnectorContributor : this.driverConnectorContributorList) {
            IDriverConnector[] iDriverConnectorArray = driverConnectorContributor.getDriverConnector(configFolderPath);
            int n = iDriverConnectorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDriverConnector existedConnector = iDriverConnectorArray[n2];
                if (existedConnector.getSettingFileName().equals(connector.getSettingFileName())) {
                    return driverConnectorContributor.getName();
                }
                ++n2;
            }
        }
        return null;
    }

    public IDriverConnectorContributor[] getAllBuiltinDriverConnectorContributors() {
        return this.driverConnectorContributorList.toArray(new IDriverConnectorContributor[this.driverConnectorContributorList.size()]);
    }
}

